<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\MonthlyContribution;
use App\Street;
use App\IncomeCategory;
use App\Admin;
use Carbon\Carbon;
use App\Config;
use App\Status;
use Illuminate\Support\Facades\Mail;
use App\Mail\EmailReminder;
use App\Mail\EmailCharge;
use DB;



class AccountReceivable extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'accounts_receivables';
    protected $fillable = ['category','debt','to_pay','month','residence','deadline','description','estatus','reason'];


    public static function debtMonth()
    {
    	
        $config = Config::first();
        
        $mc = $config->multiple_contributions;

        $street = Street::where('empty_residence',0)->get();
        $category = IncomeCategory::where('name','monthly')->first();
        $actual_month = Admin::getActualMonth();
        //$config = Config::find(1);
        $day = $config->days_to_be_debtor;
        $fecha = Carbon::now();
        $status = Status::where('name','activo')->first();

        $d = $fecha->toDateString();

        $nuevafecha = strtotime ( '+'.$day.'days' , strtotime ($fecha->toDateString()));
        $nuevafecha = date ( 'Y-m-j' , $nuevafecha );

        

        if($mc == 1)
        {
            foreach ($street as $streets) 
            {
                $amount = MonthlyContribution::findOrfail($streets->contribution);
                
                if($amount)
                {
                    if($amount->amount > 0)
                    {
                        $account = AccountReceivable::create([

                            'category' => $category->id,
                            'debt'     => $amount->amount,
                            'to_pay'   => $amount->amount,
                            'month'    => $actual_month->id,
                            'residence' => $streets->id,
                            'deadline'  => $nuevafecha,
                            'estatus'    => $status->id,
                            'description' => $actual_month->month_year_text,

                        ]);
                    }
                }
            }

        }
        else
        {

            $w = MonthlyContribution::where('asign', 1)->first();



            if(is_null($w))
            {
                $am = MonthlyContribution::find(1);
                $amount = $am->amount;

            }
            else
            {

                $amount = $w->amount;
            }
           
            

           

            if($amount > 0)
            {
                

                foreach ($street as $streets) 
                {
                    $account = AccountReceivable::create([

                        'category' => $category->id,
                        'debt'     => $amount,
                        'to_pay'   => $amount,
                        'month'    => $actual_month->id,
                        'residence' => $streets->id,
                        'deadline'  => $nuevafecha,
                        'estatus'    => $status->id,
                        'description' => $actual_month->month_year_text,

                    ]);
                }
            }
        }


    }


    public static function advancePayments()
    {

        
        try
        {

            DB::beginTransaction();
            $status = Status::where('name','adelantado')->first();
            $status2 = Status::where('name','pagado')->first();
            $status3 = Status::where('name','aprobado')->first();
            $status4 = Status::where('name','activo')->first();
            $category = IncomeCategory::where('name','monthly')->first();
            $fecha= Carbon::now();
            $pago = Payment::where('status',$status->id)->get();


            $actual_month = Admin::getActualMonth();
            foreach ($pago as $pagos) 
            {
                
               
                $cuenta = AccountReceivable::where('residence',$pagos->residence)->where('category',$category->id)->where('estatus',$status4->id)->where('to_pay','!=',0)->first();
              
                if(is_null($cuenta))
                {
                }
                else
                {
                    $cruzado = PaymentAccountReceivable::where('id_payment',$pagos->id)->get();
                    //dd($cruzado);
                   
                    if($cruzado->isEmpty())
                    {
                        $monto = $pagos->amount;
                        $totalpago = $pagos->amount;
                    }
                    else
                    {
                        $monto = $cruzado->sum('paid');
                        $totalpago = $pagos->amount - $monto;

                    }

                    

                    
                    
                    $total = $totalpago - $cuenta->to_pay;
                   
                    if($total <= 0)
                    {
                        $pagar = $cuenta->to_pay - $totalpago;
                        $newdebt = $cuenta->to_pay - $totalpago;
                        $pagado = $totalpago;
                        $sobra = 0;
                    }
                    else
                    {
                        $pagar = 0;
                        $newdebt = 0;
                        $pagado = $cuenta->to_pay;
                        $sobra = $total;
                    }
                    
                    
                    $olddebt = $cuenta->to_pay;

                    $cuenta->update([

                        'to_pay' => $pagar,

                    ]);

                    if($cuenta->to_pay == 0)
                    {
                        $cuenta->update([

                            'estatus' => $status2->id,
                        ]);
                    }

                   
                    $payment = PaymentAccountReceivable::create([

                        'id_payment'               => $pagos->id,
                        'id_account_receivables'   => $cuenta->id,
                        'paid'                     => $pagado,
                        'new_debt'                 => $newdebt,
                        'old_debt'                 => $olddebt,
                    ]);  

                    $pa = Payment::findOrfail($pagos->id);
                    if($sobra == 0)
                    {
                        $pa->update([

                            'status'     => $status3->id,

                        ]);
                    }
                   
                    
                }
            }

             DB::commit();

        
         } catch (\Illuminate\Database\QueryException $e) {
             
          
             throw $e;
          
                
        } catch (\Exception $e) {
        
           throw $e;
          
              
        }

    }

    public static function emailReminder()
    {
       
        $street = Street::where('empty_residence',0)->get();
          
        foreach ($street as $streets) 
        {

            $user = User::where('street_id',$streets->id)->get();
            
            if(empty($user))
            {

            }
            else
            {
                
                foreach ($user as $users) 
                {
                   
              
                    $status2 = Status::where('name','adelantado')->first();
                    $adelantado = Payment::where('residence',$streets->id)->where('status',$status2->id)->get();
                    if($adelantado->isEmpty())
                    {

                        $st = Status::where('name','activo')->first();  
                        $saldo = AccountReceivable::select(DB::raw('SUM(to_pay) as deuda'),'residence')->where('residence',$streets->id)->where('estatus',$st->id)->first();
                        $pago = 0;
                        $pagoadelantado = "";
                        //Mail::to($user->email)->send(new EmailReminder($user,$saldo,$pagoadelantado,$pago));
                        
                    }
                    else
                    {
                        $pago = 1;
                        $st = Status::where('name','activo')->first();  
                        $saldo = AccountReceivable::select(DB::raw('SUM(to_pay) as deuda'),'residence')->where('residence',$streets->id)->where('estatus',$st->id)->first();
                        $status = Status::where('name',"adelantado")->first();
                        $pay = Payment::where('status',$status2->id)->where('residence',$streets->id)->get();
                        if($pay->isEmpty())
                        {
                            $total = " ";
                        }
                        foreach ($pay as $pays) 
                        {
                            $pagos = Payment::findOrfail($pays->id);
                            $totalpagos = $pagos->amount;
                            $monto = PaymentAccountReceivable::where('id_payment',$pays->id)->get();
                            $montototal = $monto->sum('paid');


                            if($totalpagos == $montototal)
                            {
                                $total[] = 0;
                            }
                            else
                            {
                                $total[] = $totalpagos - $montototal;
                            }


                        }


                        
                        if(empty($total))
                        {
                            $suma = 0;
                        }
                        else
                        {
                            $suma = 0;
                            foreach ($total as $key => $totales) 
                            {
                                $suma = $suma + $totales;
                            }

                            
                        }
                        
                        
                      
                        $pagoadelantado= $suma;
                        //Mail::to($user->email)->send(new EmailReminder($user,$saldo,$pagoadelantado,$pago));
                        
                    }


                    Mail::to($users->email)->send(new EmailReminder($users,$saldo,$pagoadelantado,$pago));
                }


                

                
            }

         
            
        }

     
              
    }

    public static function emailDeadline()
    {
        $street = Street::where('empty_residence',0)->get();
        $status = Status::where('name','activo')->first();
        $status2 = Status::where('name','adelantado')->first();
        

        foreach ($street as $streets) 
        {
            $user = User::where('street_id',$streets->id)->get();
            if(empty($user))
            {

            }
            else
            {
                foreach($user as $users)
                {
                    $saldo = AccountReceivable::select(DB::raw('SUM(to_pay) as deuda'))->where('residence',$streets->id)->where('estatus',$status->id)->first();

                    if(!empty($saldo))
                    {
                        if($saldo->deuda == 0)
                        {

                        }
                        else
                        {
                            $pagoadelantado = "";
                            $pago = 0;
                            Mail::to($users->email)->send(new EmailReminder($users,$saldo,$pagoadelantado,$pago));
                        }
                    }
                }
            }
        }
    }


    public static function chargeMonthlyContribution()
    {

        try
        {

            DB::beginTransaction();
        
            $config = Config::all();
            foreach ($config as $configs) 
            {
                $type_charge = $configs->type_charge;
                $amount_charge = $configs->amount_charge;
                $charge_no_pay = $configs->charge_no_pay;
                $dias_credito = $configs->days_to_be_debtor;
                $email_charge = $configs->email_charge;
            }

            if($charge_no_pay == 1)
            {
                $street = Street::where('empty_residence',0)->get();
                $status = Status::where('name','activo')->first();
                $charge = IncomeCategory::where('name','charge')->first();
                $monthly = IncomeCategory::where('name','monthly')->first();
                $date = Carbon::now();
                
                $actual_month = Admin::getActualMonth();
                
                foreach ($street as $streets) 
                {
           
                    $saldo = AccountReceivable::select(DB::raw('SUM(to_pay) as deuda'),'recargo')
                        ->leftjoin(DB::raw('(SELECT SUM(to_pay) as recargo,residence  FROM accounts_receivables WHERE estatus = "'.$status->id.'" AND residence = "'.$streets->id.'" AND category = "'.$charge->id.'") as recargos'),'accounts_receivables.residence','=','recargos.residence')
                        ->where('category',$monthly->id)
                        ->where('deadline','<',$date->toDateString())
                        ->where('accounts_receivables.residence',$streets->id)
                        ->where('estatus',$status->id)
                        ->first();
                    //$h[] = $saldo;
                    if(empty($saldo->deuda))
                    {

                    }
                    else
                    {
                        if($type_charge == 1) // porcentaje
                        {
                            $deuda = $saldo->deuda+$saldo->recargo;
                            $total = ($deuda*$amount_charge)/100;
                        }
                        elseif($type_charge == 2) // fijo
                        {
                            $total = $amount_charge;
                        }

                        if($total == 0)
                        {

                        }
                        else
                        {

                            $nuevafecha = strtotime ( '+'.$dias_credito.'days' , strtotime ($date->toDateString()));
                            $nuevafecha = date ( 'Y-m-j' , $nuevafecha );

                            $account = AccountReceivable::create([

                                'category' => $charge->id,
                                'debt'     => $total,
                                'to_pay'   => $total,
                                'month'    => $actual_month->id,
                                'residence' => $streets->id,
                                'deadline'  => $date->toDateString(),
                                'estatus'    => $status->id,
                                'description' => $actual_month->month_year_text,

                            ]);
                        }

                        if($email_charge == 1)
                        {
                            $saldo = AccountReceivable::select(DB::raw('SUM(to_pay) as deuda'))->where('residence',$streets->id)->where('estatus',$status->id)->first();
                            $user = User::where('street_id',$streets->id)->first();
                            if(empty($user))
                            {

                            }
                            else
                            {
                                Mail::to($user->email)->send(new EmailCharge($user,$total,$saldo));
                            }
                        }
                    }
                }

            //dd($h);
            }

            DB::commit();

        
         } catch (\Illuminate\Database\QueryException $e) {
             
            throw $e;
           
        } catch (\Exception $e) {
        
           throw $e;
              
        }

    }

    

}
