<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use App\AccountInfo;
use DB;
use App\GuardInfo;
use Auth;
use App\Month;
use Carbon\Carbon;
use App\MemberColony;
use App\Income;
use App\Street;


class Admin extends Model
{
    
    public static function incomeResident()
    {

        $incomes_resident = DB::table('incomes_residents')
            ->join('streets', 'streets.id', '=', 'residence')
            ->join('income_categories', 'income_categories.id', '=', 'category')
            ->join('payment_types', 'payment_type', '=', 'payment_types.id')
            ->join('months', 'incomes_residents.month', '=', 'months.id')
            ->select('incomes_residents.*', 'streets.name_street', 'streets.number', 'income_categories.category_name', 'payment_types.payment_name', 'months.month_year_text')
            ->whereNull('incomes_residents.deleted_at')
            ->where('incomes_residents.check',0)
            ->distinct()
            ->paginate(15);

        return $incomes_resident;
        
    }

    public static function getActualMonth()
    {
    	$fecha= Carbon::now();
        $t = $fecha->toDateString();
        $year = substr($t, -10,4);
        $mon = substr($t, -5,2);
        $actual_month = Month::where('year',$year)->where('month',$mon)->first();

        return $actual_month;
    }

    public static function getExpenses($month)
    {
        
       
        $expense = Expense::where('month',$month)->get();

        $exp = $expense->sum('amount');
        return $exp;
    }

    public static function getIncomes($month)
    {
        
        $income = Income::where('month', $month)->get();
      
        $inc = $income->sum('quantity');
        return $inc;

    }

    public static function expectIncomes($month)
    {
    
        $cantidad = AccountInfo::find(1);
    
        $amount = $cantidad->amount;

        $street = Street::all();
        $can = 0;
        foreach ($street as $streets) 
        {
            $can = $can+$amount;
        }

       
        return $can;
    }

    public static function residentLatePay()
    {
        $account = AccountReceivable::all();
        $debt = 0;

        foreach ($account as $accounts) 
        {
            $debt = $debt + $accounts->to_pay;
        }

        return $debt;
    }

    public static function userDebt()
    {
        $account = AccountReceivable::where('residence', Auth::user()->street_id)->get();

        $debt = 0;
        foreach ($account as $accounts) 
        {
            $debt = $debt + $accounts->to_pay;
        }

        return $debt;

    }
}
