<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\MemberColony;

class Colony extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'colonies';
    
    protected $fillable = ['colony_name', 'president_colony_name', 'treasurer_colony_name', 'secretary_colony_name',];

    public function colonyMember()
    {
        return $this->hasMany('App\MemberColony');
    }

    /** FUNCION QUE CREA LA INFORMACION DE LA COLONIA Y MIEMBROS DE LA MESA DIRECTIVA **/
    public static function createColony($request)
    {
        $colony = Colony::create([

            'colony_name' => $request->colony_name, 
            'president_colony_name' => $request->president_colony_name, 
            'treasurer_colony_name' => $request->treasurer_colony_name, 
            'secretary_colony_name' => $request->secretary_colony_name,             
        ]);
                
        $c = count($request->member_colony_name);

        if($c == 1)
        {
            for ($i=0; $i < count($request->member_colony_name); $i++)
            {
                if(!is_null($request->member_colony_name[$i]))
                {
                    MemberColony::create([

                        'colony_id' => $colony->id,
                        'member_colony_name' => $request->member_colony_name[$i],
                            
                    ]);
                }
            }
        }
        else
        {
            for ($i=0; $i < count($request->member_colony_name); $i++)
            {
                
                    MemberColony::create([

                        'colony_id' => $colony->id,
                        'member_colony_name' => $request->member_colony_name[$i],
                            
                    ]);
                
            }
        }
        

    }

    /** FUNCION QUE ACTUALIZA LA INFORMACION DE LA COLONIA Y MIEMBROS DE LA MESA DIRECTIVA **/
    public static function updateColony($request,$colony)
    {
        $colony->update([

            'colony_name' => $request->colony_name, 
            'president_colony_name' => $request->president_colony_name, 
            'treasurer_colony_name' => $request->treasurer_colony_name, 
            'secretary_colony_name' => $request->secretary_colony_name, 
        ]);

        $member = MemberColony::where('colony_id', $colony->id)->get();
        
        if(!$request->id_member_colony)
        {
            $member = MemberColony::where('colony_id', $colony->id);
            $member->delete();

            if($request->member_colony_name)
            {
                $c = count($request->member_colony_name);

                for ($i=0; $i < count($request->member_colony_name); $i++)
                {
                    if($c == 1 && is_null($request->member_colony_name[$i]))
                    {
                        
                    
                    }
                    else
                    {
                            MemberColony::create([
                                'colony_id' => $colony->id,
                                'member_colony_name' => $request->member_colony_name[$i],
                             ]);
                    }
                  
                }
            }
        }
        else
        {

            foreach ($member as $members)
            {                             
                if(!in_array($members->id,$request->id_member_colony))
                { 
                    $member = MemberColony::findOrfail($members->id);
                    $member->delete();     
                }  
            }

            for ($i=0; $i < count($request->id_member_colony); $i++)
            {
                $member = MemberColony::findOrfail($request->id_member_colony[$i]);
                $member->update([
                    'member_colony_name' => $request->member_colony_name_edit[$i],
                ]);
            }
            

            if($request->member_colony_name)
            {
                $c = count($request->member_colony_name);

                for ($i=0; $i < count($request->member_colony_name); $i++)
                {
                    if($c == 1 && is_null($request->member_colony_name[$i]))
                    {
                        
                    
                    }
                    else
                    {
                            MemberColony::create([
                                'colony_id' => $colony->id,
                                'member_colony_name' => $request->member_colony_name[$i],
                             ]);
                    }
                  
                }
            }
        }

                  
       

    }

    public function userColony()
    {
        return $this->belongsTo('App\User');
    }

}
