<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use DB;
use App\Status;
use Carbon\Carbon;
use Auth;

class Config extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'configs';
    protected $fillable = [ 
    	'send_mail',
	    'access_debtor', 
	    'max_reservation_months',
	    'days_to_be_debtor',
	    'guard_visit',
	    'guard_employe',
	    'guard_guest',
	    'reminder_email',
	    'day_send_reminder',
	    'show_debt_resident',
	    'charge_no_pay',
	    'time_to_be_debtor',
	    'type_time_to_be_debtor',
	    'amount_charge',
	    'type_charge',
	    'email_cancel_reservation',
	    'email_charge',
	    'email_extraordinary_account',
        'discussion_debtor',
        'multiple_contributions',
        'limit_events',
        'events_house'
    ];


    public static function permissionDebtors() 
    {

            $config = Config::all();
            foreach ($config as $configs) 
            {
                $access_debtor = $configs->access_debtor;
                $time = $configs->time_to_be_debtor;
                $dias_credito = $configs->days_to_be_debtor;
            }

            if($access_debtor == 1)
            {
                $date = Carbon::now();
                $user = User::findOrfail(Auth::id());
                $estatus = Status::where('name','activo')->first();

                $mes_actual = date("m");

                $category = IncomeCategory::where('name','monthly')->first();
                 
                // #Cambio restriccion a moroso 
                $consulta = DB::select('select deadline,residence,MONTH(deadline) as limite,created_at FROM accounts_receivables WHERE  deadline < "'.$date->toDateString().'" AND estatus = "'.$estatus->id.'" AND residence = "'.$user->street_id.'" AND category = "'.$category->id.'" AND to_pay != 0');
                   

                if(empty($consulta))
                {
                    $hide = 1;
                }
                else
                {
                    if($time == 0)
                    {
                        $hide = 1;
                    }
                    else
                    {


                            $deudas = count($consulta);
                            if($deudas >= $time)
                            {
                                $hide = 0;
                            }
                            else
                            {
                                $hide = 1;
                            }
                        
                        }
                    }
                    
                    

            }
            else
            {
                $hide = 1;
            }

                
        

        return $hide;
    }
}
