<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use DB;
use Carbon\Carbon;

class CheckOut extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'Check_Out';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Marcar la salida pendiente de las visitas a la residencia.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

        DB::beginTransaction();
        try{
            $date = Carbon::now();
            $dant = $date->subDays(30)->toDateString();
            
            DB::table('access_colonies')
                ->where('check_in','<=',$dant)
                ->where('check_out','=',NULL)
                ->update(['check_out' => Carbon::now()]);  

            DB::table('recurrent_employes')
                ->leftjoin('access_colonies', 'access_colonies.employe_id','=','recurrent_employes.employe_id')
                ->where('access_colonies.check_in','<=',$dant)
                ->where('recurrent_employes.check_in','=',1)
                ->update(['recurrent_employes.check_in' => 0]);

            DB::table('recurrent_visits')
                ->leftjoin('access_colonies', 'access_colonies.visit_id','=','recurrent_visits.visit_id')
                ->where('access_colonies.check_in','<=',$dant)
                ->where('recurrent_visits.check_in','=',1)
                ->update(['recurrent_visits.check_in' => 0]);
            
            DB::commit();
        } catch(\Exeption $e){
            DB::rollback();
        }
    }
}
