<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use Illuminate\Foundation\Inspiring;
use App\Http\Controllers\Controller;
use PhpImap\Mailbox as ImapMailbox;
use PhpImap\IncomingMail;
use PhpImap\IncomingMailAttachment;
use DB;
use App\Payment;
use App\AccountReceivable;
use App\Admin;
use App\Month;
use App\PaymentAccountReceivable;
use App\User;
use Carbon\Carbon;
use App\Status;

class RecibirCorreo extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'RecibirCorreo';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'leer correo para obtener subject y body';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        /*************** Configuracion del servidor IMAP ***************************/

        $hostname = '{imap.gmail.com:993/imap/ssl}INBOX';
        $username = '[notificaciones@residenz.mx]';
        $password = '[I&uA<eTY>QY86eM%#]';
        $fecha = '08-ENE-2021';

        /************** Intento de conexión *********************/

        $imap = imap_open($hostname, $username, $password) or die('Cannot connect to Gmail: ' . imap_last_error());

        /*************** TERMINA INTENTO DE CONEXION ******************************/


        ///// SI EXISTE LA CONEXION AL CORREO //////
        if ($imap) {

            /// BUSCAR LOS CORREO QUE SON UNSEEN ///////
            $emails = imap_search($imap, 'UNSEEN');

            ////// SI HAY CORREOS UNSEEN ////////////////
            if ($emails) {
                $output = '';
                rsort($emails);

                $i = 0;

                /****** FOREACH DE CADA CORREO *********************************/

                foreach ($emails as $email_number) {

                    //// SE OBTIENE LA INFORMACION DEL CORREO ////////

                    $overview = imap_fetch_overview($imap, $email_number, 0);
                    $date = $overview[0]->date;
                    if (isset($overview[0]->subject)) {
                        $subject = imap_utf8($overview[0]->subject);
                    } else {
                        $subject = " ";
                    }


                    if (!is_null($subject)) {
                        $from = imap_utf8($overview[0]->from);
                        /*$structure = imap_fetchstructure($imap,$email_number);

                                $attachments = array ();
                                if (isset ( $structure->parts ) && count ( $structure->parts )) {
                                        for($i = 0; $i < count ( $structure->parts ); $i ++) {
                                            $attachments [$i] = array (
                                                    'is_attachment' => false,
                                            );
                                            if ($structure->parts [$i]->ifdparameters) {
                                                foreach ( $structure->parts [$i]->dparameters as $object ) {
                                                    if (strtolower ( $object->attribute ) == 'filename') {
                                                        $attachments [$i] ['is_attachment'] = true;
                                                    }
                                                }
                                            }
                                            if ($attachments [$i] ['is_attachment']) {
                                                
                                                $parte = 1.2;
                                            }
                                            else
                                            {
                                                $parte = 2;
                                            }

                                        }
                                }*/


                        /// obtener correo from y limpiar ///
                        $a = explode("<", $from);
                        $b = $a[1];
                        $c = str_replace(">", '', $b);
                        $correo_from = $c;

                        // convertir formato de fecha de correo //
                        $unixTimestamp = strtotime($date);
                        $fecha_correo = date("Y-m-d", $unixTimestamp);



                        $key_word = strtolower($subject);
                        $key_nospace = str_replace(' ', '', $key_word);
                        $findme = "#pago";
                        $pos = strpos($key_nospace, $findme);


                        if ($pos === false) {
                        } else {
                            $d = explode("#pago", $key_nospace);
                            $e = str_replace(',', '', $d[1]);

                            if (is_numeric($e)) {
                                $titulo = $e;
                                /*$mess = imap_fetchbody($imap,$email_number,$parte);
                                        $message = quoted_printable_decode($mess);*/

                                /*$descripcion = substr($message, 15, 45);*/

                                $usuario = User::all();

                                $fecha = Carbon::now();
                                $actual_month = Admin::getActualMonth();
                                $status = Status::where('name', 'confirmar')->first();
                                $n = 0;
                                foreach ($usuario as $usuarios) {

                                    $pos = strpos($correo_from, $usuarios->email);
                                    if ($pos !== false) {

                                        $user = $usuarios->id;
                                        $pay = new Payment([
                                            'amount'        => $titulo,
                                            'description'   => "Aviso de pago por correo",
                                            'residence'     => $usuarios->street_id,
                                            'capture_date'  => $fecha->toDateString(),
                                            'payment_date'  => $fecha_correo,
                                            'payment_type'  => 6,
                                            'month'         => $actual_month->id,
                                            'status'        => $status->id,
                                        ]);
                                        $pay->save();
                                    } else {
                                        $n++;
                                    }
                                }
                            } else {
                            }
                        }
                    }







                    /// MARCAR LOS CORREO COMO SEEN //////
                    $estado = imap_setflag_full($imap, $email_number, "\Seen");
                }

                /*************** TERMINA FOREACH ***************************************/

                /// SE CIERRA LA CONEXION ////
                imap_close($imap);
            } else {
                /// SI NO HAY CORREO UNSSEN SE CIERRA LA CONEXION AL CORREO ////
                imap_close($imap);
            }
            ////// TERMINA SI HAY CORREOS UNSEEN ////////////////

        }
    }
}
