<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Config;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        
        \App\Console\Commands\limitTimeReservation::class,
        \App\Console\Commands\AccountReceivableMonth::class,
        \App\Console\Commands\AdvancedPayment::class,
        \App\Console\Commands\EmailReminder::class,
        \App\Console\Commands\EmailDeadline::class,
        \App\Console\Commands\ChargeMonthlyContribution::class,
        \App\Console\Commands\EndDiscussion::class,
        \App\Console\Commands\RecibirCorreo::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        
        $schedule->command('AccountReceivableMonth')->monthlyOn(1,'02:00');
        $schedule->command('AdvancedPayment')->monthlyOn(1,'02:00');
        $schedule->command('EmailReminder')->monthlyOn(1,'02:00');
        $schedule->command('EndDiscussion')->dailyAt('01:00');
        //$schedule->command('RecibirCorreo')->dailyAt('00:00');

        $config = Config::all();
        foreach ($config as $configs) 
        {
            $dias = $configs->days_to_be_debtor;
            $permiso = $configs->reminder_email;
            $recargo = $configs->charge_no_pay;
            $cancel_reservation = $configs->email_cancel_reservation;
        }



        if($cancel_reservation == 1)
        {
            $schedule->command('limitTimeReservation')->dailyAt('00:00');
        }

        if($permiso == 1)
        {
            if($dias == 0)
            {

            }
            else
            {
                $schedule->command('EmailDeadline')->monthlyOn($dias,'00:00');
            }
        }

        if($recargo == 1)
        {
            $fecha = $dias + 1;
            $schedule->command('ChargeMonthlyContribution')->monthlyOn($fecha,'01:00');
        }



    }

    /**
     * Register the Closure based commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        require base_path('routes/console.php');
    }
}
