<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Discussion;
use Carbon\Carbon;
use App\Status;

class Discussion extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'discussions';
    protected $fillable = [

    	'title', 
    	'description', 
    	'start_date', 
    	'end_date', 
    	'status'
    ];


    public static function finishDiscussion(){


        $discusion = Discussion::all();
        $date = Carbon::now();
        $aceptada = Status::where('name','aceptada')->first();
        $rechazada = Status::where('name','rechazada')->first();

        foreach ($discusion as $discusiones) 
        {
            if($discusiones->end_date < $date->toDateString())
            {
                $result1 = DiscussionResidence::where('id_discussions',$discusiones->id)->where('id_discussions_options',1)->get();
                $result2 = DiscussionResidence::where('id_discussions',$discusiones->id)->where('id_discussions_options',2)->get();
                $result3 = DiscussionResidence::where('id_discussions',$discusiones->id)->where('id_discussions_options',3)->get();

                $favor = count($result1);
                $contra = count($result2);
                $absten = count($result3);

                if($favor > $contra && $favor > $absten)
                {
                    $status = $aceptada->id;
                }
                else
                {
                     $status = $rechazada->id;
                }

                $disc = Discussion::findOrfail($discusiones->id);
                $disc->update([

                    'status' => $status,
                ]);
            }
        }

    }
 
}
