<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;
use Auth;
use App\AccessType;
use Validator;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use Illuminate\Support\Str; // Importar la clase Str


class Employe extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];


    protected $table = 'employes';
    protected $fillable = ['name', 'category', 'type', 'residence_id', 'file_name', 'url_file', 'file_size', 'file_type'];


    public static function createEmploye($request)
    {
        if ($request->file) {
            if ($request->hasFile('file')) {
                $fileInput = $request->file('file');
                $fileType = $fileInput->getMimeType();
                $clave = Str::random(5);

                if (in_array($fileType, ['image/jpg', 'image/jpeg', 'image/png'])) {
                    $type = $fileType == "image/jpeg" ? "jpg" : ($fileType == "image/png" ? "png" : null);

                    if ($request->imageData) {
                        $data = base64_decode($request->imageData);
                        $im = imagecreatefromstring($data);
                        if ($im !== false) {
                            $fecha = Carbon::now();
                            $et = EmployeType::where('name', $request->employe_type)->first();

                            $employe = Employe::create([
                                'name' => $request->name,
                                'category' => $request->category,
                                'type' => $et->id,
                                'residence_id' => Auth::user()->street_id,
                            ]);

                            $name_imagen = $employe->id . "." . $type;
                            $url = '/uploads/photos/employes/';
                            $path = public_path() . $url . $name_imagen;
                            $peso = $request->sizeData * 1024;
                            header('Content-Type: ', $request->contentData);
                            imagejpeg($im, $path);
                            imagedestroy($im);

                            $employe->update([
                                'file_name' => $name_imagen,
                                'url_file' => $url . $name_imagen,
                                'file_size' => $peso,
                                'file_type' => $request->contentType,
                            ]);

                            if ($request->employe_type == "recurrente") {
                                $access_id = RecurrentEmploye::create([
                                    'date_start' => $fecha->toDateString(),
                                    'date_end' => $request->date_end,
                                    'monday' => $request->monday ? 1 : 0,
                                    'tuesday' => $request->tuesday ? 1 : 0,
                                    'wendsday' => $request->wendsday ? 1 : 0,
                                    'thursday' => $request->thursday ? 1 : 0,
                                    'friday' => $request->friday ? 1 : 0,
                                    'saturday' => $request->saturday ? 1 : 0,
                                    'sunday' => $request->sunday ? 1 : 0,
                                    'time_start' => $request->time_start,
                                    'time_end' => $request->time_end,
                                    'employe_id' => $employe->id,
                                ]);
                            } else {
                                $type = AccessType::where('name', 'empleado')->first();
                                $access_id = AccessColony::create([
                                    'date' => $request->date,
                                    'residence_id' => Auth::user()->street_id,
                                    'type' => $type->id,
                                    'employe_id' => $employe->id,
                                ]);
                            }
                        } else {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                            return redirect()->back()->withErrors($errors);
                        }
                    } else {
                        $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                        return redirect()->back()->withErrors($errors);
                    }
                } else {
                    $path = public_path() . '/uploads/photos/employes/';
                    $url = '/uploads/photos/employes/';
                    $fileSize = $fileInput->getSize() / 1024;

                    $fecha = Carbon::now();
                    $et = EmployeType::where('name', $request->employe_type)->first();

                    $employe = Employe::create([
                        'name' => $request->name,
                        'category' => $request->category,
                        'type' => $et->id,
                        'residence_id' => Auth::user()->street_id,
                    ]);

                    $fileName = $employe->id . "." . $type;

                    if ($fileInput->move($path, $fileName)) {
                        $employe->update([
                            'file_name' => $fileName,
                            'url_file' => $url . $fileName,
                            'file_size' => $fileSize,
                            'file_type' => $fileType,
                        ]);
                    }

                    if ($request->employe_type == "recurrente") {
                        $access_id = RecurrentEmploye::create([
                            'date_start' => $fecha->toDateString(),
                            'date_end' => $request->date_end,
                            'monday' => $request->monday ? 1 : 0,
                            'tuesday' => $request->tuesday ? 1 : 0,
                            'wendsday' => $request->wendsday ? 1 : 0,
                            'thursday' => $request->thursday ? 1 : 0,
                            'friday' => $request->friday ? 1 : 0,
                            'saturday' => $request->saturday ? 1 : 0,
                            'sunday' => $request->sunday ? 1 : 0,
                            'time_start' => $request->time_start,
                            'time_end' => $request->time_end,
                            'employe_id' => $employe->id,
                        ]);
                    } else {
                        $type = AccessType::where('name', 'empleado')->first();
                        $access_id = AccessColony::create([
                            'date' => $request->date,
                            'residence_id' => Auth::user()->street_id,
                            'type' => $type->id,
                            'employe_id' => $employe->id,
                        ]);
                    }
                }

                return $access_id;
            }
        } else if ($request->file1) {
            if ($request->hasFile('file1')) {
                $fileInput1 = $request->file('file1');
                $fileType = $fileInput1->getMimeType();
                $clave = Str::random(5);

                if (in_array($fileType, ['image/jpg', 'image/jpeg', 'image/png'])) {
                    $type = $fileType == "image/jpeg" ? "jpg" : ($fileType == "image/png" ? "png" : null);

                    if ($request->imageData2) {
                        $data = base64_decode($request->imageData2);
                        $im = imagecreatefromstring($data);
                        if ($im !== false) {
                            $fecha = Carbon::now();
                            $et = EmployeType::where('name', $request->employe_type)->first();

                            $employe = Employe::create([
                                'name' => $request->name,
                                'category' => $request->category,
                                'type' => $et->id,
                                'residence_id' => Auth::user()->street_id,
                            ]);

                            $name_imagen = $employe->id . "." . $type;
                            $url = '/uploads/photos/employes/';
                            $path = public_path() . $url . $name_imagen;
                            $peso = $request->sizeData2 * 1024;
                            header('Content-Type: ', $request->contentData2);
                            imagejpeg($im, $path);
                            imagedestroy($im);

                            $employe->update([
                                'file_name' => $name_imagen,
                                'url_file' => $url . $name_imagen,
                                'file_size' => $peso,
                                'file_type' => $request->contentType,
                            ]);

                            if ($request->employe_type == "recurrente") {
                                $access_id = RecurrentEmploye::create([
                                    'date_start' => $fecha->toDateString(),
                                    'date_end' => $request->date_end,
                                    'monday' => $request->monday ? 1 : 0,
                                    'tuesday' => $request->tuesday ? 1 : 0,
                                    'wendsday' => $request->wendsday ? 1 : 0,
                                    'thursday' => $request->thursday ? 1 : 0,
                                    'friday' => $request->friday ? 1 : 0,
                                    'saturday' => $request->saturday ? 1 : 0,
                                    'sunday' => $request->sunday ? 1 : 0,
                                    'time_start' => $request->time_start,
                                    'time_end' => $request->time_end,
                                    'employe_id' => $employe->id,
                                ]);
                            } else {
                                $type = AccessType::where('name', 'empleado')->first();
                                $access_id = AccessColony::create([
                                    'date' => $request->date,
                                    'residence_id' => Auth::user()->street_id,
                                    'type' => $type->id,
                                    'employe_id' => $employe->id,
                                ]);
                            }
                        } else {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                            return redirect()->back()->withErrors($errors);
                        }
                    } else {
                        $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                        return redirect()->back()->withErrors($errors);
                    }
                } else {
                    $path = public_path() . '/uploads/photos/employes/';
                    $url = '/uploads/photos/employes/';
                    $fileSize = $fileInput1->getSize() / 1024;

                    $fecha = Carbon::now();
                    $et = EmployeType::where('name', $request->employe_type)->first();

                    $employe = Employe::create([
                        'name' => $request->name,
                        'category' => $request->category,
                        'type' => $et->id,
                        'residence_id' => Auth::user()->street_id,
                    ]);

                    $fileName = $employe->id . "." . $type;

                    if ($fileInput1->move($path, $fileName)) {
                        $employe->update([
                            'file_name' => $fileName,
                            'url_file' => $url . $fileName,
                            'file_size' => $fileSize,
                            'file_type' => $fileType,
                        ]);
                    }

                    if ($request->employe_type == "recurrente") {
                        $access_id = RecurrentEmploye::create([
                            'date_start' => $fecha->toDateString(),
                            'date_end' => $request->date_end,
                            'monday' => $request->monday ? 1 : 0,
                            'tuesday' => $request->tuesday ? 1 : 0,
                            'wendsday' => $request->wendsday ? 1 : 0,
                            'thursday' => $request->thursday ? 1 : 0,
                            'friday' => $request->friday ? 1 : 0,
                            'saturday' => $request->saturday ? 1 : 0,
                            'sunday' => $request->sunday ? 1 : 0,
                            'time_start' => $request->time_start,
                            'time_end' => $request->time_end,
                            'employe_id' => $employe->id,
                        ]);
                    } else {
                        $type = AccessType::where('name', 'empleado')->first();
                        $access_id = AccessColony::create([
                            'date' => $request->date,
                            'residence_id' => Auth::user()->street_id,
                            'type' => $type->id,
                            'employe_id' => $employe->id,
                        ]);
                    }
                }

                return $access_id;
            }
        }
    }



    public static function editEmploye($request, $employe)
    {


        $fecha = Carbon::now();
        $et = EmployeType::where('name', $request->employe_type)->first();

        function str_random($length)
        {
            return Str::random($length);
        }

        if ($request->file) {
            if (request()->hasFile('file')) {
                $fileInput = request()->file('file');
                $fileType = $fileInput->getMimeType();
                $clave = str_random(5);

                if ($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png') {

                    if ($fileType == "image/jpeg") {
                        $type = "jpg";
                    } else if ($fileType == "application/pdf") {
                        $type = "pdf";
                    } else if ($fileType == "image/png") {
                        $type = "png";
                    }

                    $name_imagen = $employe->id . "." . $type;
                    $url = '/uploads/photos/employes/';
                    $path = public_path() . $url . $name_imagen;
                    $peso = $request->sizeData * 1024;

                    if ($request->imageData) {
                        $data = base64_decode($request->imageData);
                        $im = imagecreatefromstring($data);
                        if ($im !== false) {
                            header('Content-Type: ', $request->contentData);
                            imagejpeg($im, $path);
                            imagedestroy($im);

                            $fecha = Carbon::now();

                            if ($request->employe_type == "recurrente") {
                                $type = EmployeType::where('name', "recurrente")->first();
                                $type2 = $employe->type;

                                if ($type2 == $type->id) {
                                    if ($request->monday) {
                                        $monday = 1;
                                    } else {
                                        $monday = 0;
                                    }
                                    if ($request->tuesday) {
                                        $tuesday = 1;
                                    } else {
                                        $tuesday = 0;
                                    }
                                    if ($request->wendsday) {
                                        $wendsday = 1;
                                    } else {
                                        $wendsday = 0;
                                    }
                                    if ($request->thursday) {
                                        $thursday = 1;
                                    } else {
                                        $thursday = 0;
                                    }
                                    if ($request->friday) {
                                        $friday = 1;
                                    } else {
                                        $friday = 0;
                                    }
                                    if ($request->saturday) {
                                        $saturday = 1;
                                    } else {
                                        $saturday = 0;
                                    }
                                    if ($request->sunday) {
                                        $sunday = 1;
                                    } else {
                                        $sunday = 0;
                                    }

                                    $recurrentemploye = RecurrentEmploye::findOrfail($request->recurrent_id);

                                    $recurrentemploye->update([

                                        'date_start' => $fecha->toDateString(),
                                        'date_end'   => $request->date_end,
                                        'monday'     => $monday,
                                        'tuesday'    => $tuesday,
                                        'wendsday'   => $wendsday,
                                        'thursday'   => $thursday,
                                        'friday'     => $friday,
                                        'saturday'   => $saturday,
                                        'sunday'     => $sunday,
                                        'time_start' => $request->time_start,
                                        'time_end'   => $request->time_end,

                                    ]);

                                    $employe->update([

                                        'name'          => $request->name,
                                        'category'      => $request->category,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url . $name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,

                                    ]);
                                } else {
                                    if ($request->monday) {
                                        $monday = 1;
                                    } else {
                                        $monday = 0;
                                    }
                                    if ($request->tuesday) {
                                        $tuesday = 1;
                                    } else {
                                        $tuesday = 0;
                                    }
                                    if ($request->wendsday) {
                                        $wendsday = 1;
                                    } else {
                                        $wendsday = 0;
                                    }
                                    if ($request->thursday) {
                                        $thursday = 1;
                                    } else {
                                        $thursday = 0;
                                    }
                                    if ($request->friday) {
                                        $friday = 1;
                                    } else {
                                        $friday = 0;
                                    }
                                    if ($request->saturday) {
                                        $saturday = 1;
                                    } else {
                                        $saturday = 0;
                                    }
                                    if ($request->sunday) {
                                        $sunday = 1;
                                    } else {
                                        $sunday = 0;
                                    }

                                    RecurrentEmploye::create([

                                        'date_start' => $fecha->toDateString(),
                                        'date_end'   => $request->date_end,
                                        'monday'     => $monday,
                                        'tuesday'    => $tuesday,
                                        'wendsday'   => $wendsday,
                                        'thursday'   => $thursday,
                                        'friday'     => $friday,
                                        'saturday'   => $saturday,
                                        'sunday'     => $sunday,
                                        'time_start' => $request->time_start,
                                        'time_end'   => $request->time_end,
                                        'employe_id' => $employe->id,

                                    ]);

                                    $employe->update([

                                        'name'          => $request->name,
                                        'category'      => $request->category,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url . $name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,

                                    ]);
                                }
                            } else {

                                $type = EmployeType::where('name', "eventual")->first();
                                $type2 = $employe->type;
                                if ($type2 == $type->id) {
                                    $employe->update([

                                        'name'          => $request->name,
                                        'category'      => $request->category,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url . $name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,
                                    ]);
                                } else {
                                    $employe->update([

                                        'name'          => $request->name,
                                        'category'      => $request->category,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url . $name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType,

                                    ]);

                                    $recurrentemployes = RecurrentEmploye::findOrfail($request->recurrent_id);
                                    $recurrentemployes->forceDelete();
                                }
                            }
                        } else {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                            return redirect()->back()
                                ->withErrors($errors);
                        }
                    } else {
                        $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                        return redirect()->back()
                            ->withErrors($errors);
                    }
                } else {

                    $fileName = $employe->id . "." . $type;;
                    $path = public_path() . '/uploads/photos/employes/';
                    $url = '/uploads/photos/employes/';
                    $fileType = $fileInput->getMimeType();
                    if ($fileType == "image/jpeg") {
                        $type = "jpg";
                    } else if ($fileType == "application/pdf") {
                        $type = "pdf";
                    } else if ($fileType == "image/png") {
                        $type = "png";
                    }
                    $fileSize = $fileInput->getClientSize() / 1024;

                    if ($fileInput->move($path, $fileName)) {
                        $fecha = Carbon::now();

                        if ($request->employe_type == "recurrente") {
                            $type = EmployeType::where('name', "recurrente")->first();
                            $type2 = $employe->type;

                            if ($type2 == $type->id) {
                                if ($request->monday) {
                                    $monday = 1;
                                } else {
                                    $monday = 0;
                                }
                                if ($request->tuesday) {
                                    $tuesday = 1;
                                } else {
                                    $tuesday = 0;
                                }
                                if ($request->wendsday) {
                                    $wendsday = 1;
                                } else {
                                    $wendsday = 0;
                                }
                                if ($request->thursday) {
                                    $thursday = 1;
                                } else {
                                    $thursday = 0;
                                }
                                if ($request->friday) {
                                    $friday = 1;
                                } else {
                                    $friday = 0;
                                }
                                if ($request->saturday) {
                                    $saturday = 1;
                                } else {
                                    $saturday = 0;
                                }
                                if ($request->sunday) {
                                    $sunday = 1;
                                } else {
                                    $sunday = 0;
                                }

                                $recurrentemploye = RecurrentEmploye::findOrfail($request->recurrent_id);

                                $recurrentemploye->update([

                                    'date_start' => $fecha->toDateString(),
                                    'date_end'   => $request->date_end,
                                    'monday'     => $monday,
                                    'tuesday'    => $tuesday,
                                    'wendsday'   => $wendsday,
                                    'thursday'   => $thursday,
                                    'friday'     => $friday,
                                    'saturday'   => $saturday,
                                    'sunday'     => $sunday,
                                    'time_start' => $request->time_start,
                                    'time_end'   => $request->time_end,

                                ]);

                                $employe->update([

                                    'name'          => $request->name,
                                    'category'      => $request->category,
                                    'type'          => $type->id,
                                    'file_name'     => $fileName,
                                    'url_file'      => $url . $fileName,
                                    'file_size'     => $fileSize,
                                    'file_type'     => $fileType,

                                ]);
                            } else {
                                if ($request->monday) {
                                    $monday = 1;
                                } else {
                                    $monday = 0;
                                }
                                if ($request->tuesday) {
                                    $tuesday = 1;
                                } else {
                                    $tuesday = 0;
                                }
                                if ($request->wendsday) {
                                    $wendsday = 1;
                                } else {
                                    $wendsday = 0;
                                }
                                if ($request->thursday) {
                                    $thursday = 1;
                                } else {
                                    $thursday = 0;
                                }
                                if ($request->friday) {
                                    $friday = 1;
                                } else {
                                    $friday = 0;
                                }
                                if ($request->saturday) {
                                    $saturday = 1;
                                } else {
                                    $saturday = 0;
                                }
                                if ($request->sunday) {
                                    $sunday = 1;
                                } else {
                                    $sunday = 0;
                                }

                                RecurrentEmploye::create([

                                    'date_start' => $fecha->toDateString(),
                                    'date_end'   => $request->date_end,
                                    'monday'     => $monday,
                                    'tuesday'    => $tuesday,
                                    'wendsday'   => $wendsday,
                                    'thursday'   => $thursday,
                                    'friday'     => $friday,
                                    'saturday'   => $saturday,
                                    'sunday'     => $sunday,
                                    'time_start' => $request->time_start,
                                    'time_end'   => $request->time_end,
                                    'employe_id' => $employe->id,

                                ]);

                                $employe->update([

                                    'name'          => $request->name,
                                    'category'      => $request->category,
                                    'type'          => $type->id,
                                    'file_name'     => $fileName,
                                    'url_file'      => $url . $fileName,
                                    'file_size'     => $fileSize,
                                    'file_type'     => $fileType,

                                ]);
                            }
                        } else {

                            $type = EmployeType::where('name', "eventual")->first();
                            $type2 = $employe->type;
                            if ($type2 == $type->id) {
                                $employe->update([

                                    'name'          => $request->name,
                                    'category'      => $request->category,
                                    'file_name'     => $fileName,
                                    'url_file'      => $url . $fileName,
                                    'file_size'     => $fileSize,
                                    'file_type'     => $fileType,
                                ]);
                            } else {
                                $employe->update([

                                    'name'          => $request->name,
                                    'category'      => $request->category,
                                    'type'          => $type->id,
                                    'file_name'     => $fileName,
                                    'url_file'      => $url . $fileName,
                                    'file_size'     => $fileSize,
                                    'file_type'     => $fileType,

                                ]);
                            }

                            $recurrentemployes = RecurrentEmploye::findOrfail($request->recurrent_id);
                            $recurrentemployes->forceDelete();
                        }
                    }
                }
            }
        } else if ($request->file1) {

            if (request()->hasFile('file1')) {

                $fileInput1 = request()->file('file1');
                $fileType = $fileInput1->getMimeType();
                $clave = str_random(5);
                if ($fileType == "image/jpeg") {
                    $type = "jpg";
                } else if ($fileType == "application/pdf") {
                    $type = "pdf";
                } else if ($fileType == "image/png") {
                    $type = "png";
                }

                if ($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png') {

                    $name_imagen = $employe->id . "." . $type;
                    $url = '/uploads/photos/employes/';
                    $path = public_path() . $url . $name_imagen;
                    $peso = $request->sizeData2 * 1024;

                    if ($request->imageData2) {
                        $data = base64_decode($request->imageData2);
                        $im = imagecreatefromstring($data);
                        if ($im !== false) {
                            header('Content-Type: ', $request->contentData2);
                            imagejpeg($im, $path);
                            imagedestroy($im);

                            $fecha = Carbon::now();
                            if ($request->employe_type == "recurrente") {
                                $type = EmployeType::where('name', "recurrente")->first();
                                $type2 = $employe->type;

                                if ($type2 == $type->id) {
                                    if ($request->monday) {
                                        $monday = 1;
                                    } else {
                                        $monday = 0;
                                    }
                                    if ($request->tuesday) {
                                        $tuesday = 1;
                                    } else {
                                        $tuesday = 0;
                                    }
                                    if ($request->wendsday) {
                                        $wendsday = 1;
                                    } else {
                                        $wendsday = 0;
                                    }
                                    if ($request->thursday) {
                                        $thursday = 1;
                                    } else {
                                        $thursday = 0;
                                    }
                                    if ($request->friday) {
                                        $friday = 1;
                                    } else {
                                        $friday = 0;
                                    }
                                    if ($request->saturday) {
                                        $saturday = 1;
                                    } else {
                                        $saturday = 0;
                                    }
                                    if ($request->sunday) {
                                        $sunday = 1;
                                    } else {
                                        $sunday = 0;
                                    }

                                    $recurrentemploye = RecurrentEmploye::findOrfail($request->recurrent_id);

                                    $recurrentemploye->update([

                                        'date_start' => $fecha->toDateString(),
                                        'date_end'   => $request->date_end,
                                        'monday'     => $monday,
                                        'tuesday'    => $tuesday,
                                        'wendsday'   => $wendsday,
                                        'thursday'   => $thursday,
                                        'friday'     => $friday,
                                        'saturday'   => $saturday,
                                        'sunday'     => $sunday,
                                        'time_start' => $request->time_start,
                                        'time_end'   => $request->time_end,

                                    ]);

                                    $employe->update([

                                        'name'          => $request->name,
                                        'category'      => $request->category,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url . $name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType2,

                                    ]);
                                } else {
                                    if ($request->monday) {
                                        $monday = 1;
                                    } else {
                                        $monday = 0;
                                    }
                                    if ($request->tuesday) {
                                        $tuesday = 1;
                                    } else {
                                        $tuesday = 0;
                                    }
                                    if ($request->wendsday) {
                                        $wendsday = 1;
                                    } else {
                                        $wendsday = 0;
                                    }
                                    if ($request->thursday) {
                                        $thursday = 1;
                                    } else {
                                        $thursday = 0;
                                    }
                                    if ($request->friday) {
                                        $friday = 1;
                                    } else {
                                        $friday = 0;
                                    }
                                    if ($request->saturday) {
                                        $saturday = 1;
                                    } else {
                                        $saturday = 0;
                                    }
                                    if ($request->sunday) {
                                        $sunday = 1;
                                    } else {
                                        $sunday = 0;
                                    }

                                    RecurrentEmploye::create([

                                        'date_start' => $fecha->toDateString(),
                                        'date_end'   => $request->date_end,
                                        'monday'     => $monday,
                                        'tuesday'    => $tuesday,
                                        'wendsday'   => $wendsday,
                                        'thursday'   => $thursday,
                                        'friday'     => $friday,
                                        'saturday'   => $saturday,
                                        'sunday'     => $sunday,
                                        'time_start' => $request->time_start,
                                        'time_end'   => $request->time_end,
                                        'employe_id' => $employe->id,

                                    ]);

                                    $employe->update([

                                        'name'          => $request->name,
                                        'category'      => $request->category,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url . $name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType2,

                                    ]);
                                }
                            } else {

                                $type = EmployeType::where('name', "eventual")->first();
                                $type2 = $employe->type;
                                if ($type2 == $type->id) {
                                    $employe->update([

                                        'name'          => $request->name,
                                        'category'      => $request->category,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url . $name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType2,
                                    ]);
                                } else {
                                    $employe->update([

                                        'name'          => $request->name,
                                        'category'      => $request->category,
                                        'type'          => $type->id,
                                        'file_name'     => $name_imagen,
                                        'url_file'      => $url . $name_imagen,
                                        'file_size'     => $peso,
                                        'file_type'     => $request->contentType2,

                                    ]);

                                    $recurrentemployes = RecurrentEmploye::findOrfail($request->recurrent_id);
                                    $recurrentemployes->forceDelete();
                                }
                            }
                        } else {
                            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                            return redirect()->back()
                                ->withErrors($errors);
                        }
                    } else {
                        $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                        return redirect()->back()
                            ->withErrors($errors);
                    }
                } else {
                    $fileName = $employe->id . "." . $type;
                    $path = public_path() . '/uploads/photos/employes/';
                    $url = '/uploads/photos/employes/';
                    $fileType = $fileInput1->getMimeType();
                    if ($fileType == "image/jpeg") {
                        $type = "jpg";
                    } else if ($fileType == "application/pdf") {
                        $type = "pdf";
                    } else if ($fileType == "image/png") {
                        $type = "png";
                    }
                    $fileSize = $fileInput1->getClientSize() / 1024;

                    if ($fileInput1->move($path, $fileName)) {
                        $fecha = Carbon::now();
                        if ($request->employe_type == "recurrente") {
                            $type = EmployeType::where('name', "recurrente")->first();
                            $type2 = $employe->type;

                            if ($type2 == $type->id) {
                                if ($request->monday) {
                                    $monday = 1;
                                } else {
                                    $monday = 0;
                                }
                                if ($request->tuesday) {
                                    $tuesday = 1;
                                } else {
                                    $tuesday = 0;
                                }
                                if ($request->wendsday) {
                                    $wendsday = 1;
                                } else {
                                    $wendsday = 0;
                                }
                                if ($request->thursday) {
                                    $thursday = 1;
                                } else {
                                    $thursday = 0;
                                }
                                if ($request->friday) {
                                    $friday = 1;
                                } else {
                                    $friday = 0;
                                }
                                if ($request->saturday) {
                                    $saturday = 1;
                                } else {
                                    $saturday = 0;
                                }
                                if ($request->sunday) {
                                    $sunday = 1;
                                } else {
                                    $sunday = 0;
                                }

                                $recurrentemploye = RecurrentEmploye::findOrfail($request->recurrent_id);

                                $recurrentemploye->update([

                                    'date_start' => $fecha->toDateString(),
                                    'date_end'   => $request->date_end,
                                    'monday'     => $monday,
                                    'tuesday'    => $tuesday,
                                    'wendsday'   => $wendsday,
                                    'thursday'   => $thursday,
                                    'friday'     => $friday,
                                    'saturday'   => $saturday,
                                    'sunday'     => $sunday,
                                    'time_start' => $request->time_start,
                                    'time_end'   => $request->time_end,

                                ]);

                                $employe->update([

                                    'name'          => $request->name,
                                    'category'      => $request->category,
                                    'type'          => $type->id,
                                    'file_name'     => $fileName,
                                    'url_file'      => $url . $fileName,
                                    'file_size'     => $fileSize,
                                    'file_type'     => $fileType,

                                ]);
                            } else {
                                if ($request->monday) {
                                    $monday = 1;
                                } else {
                                    $monday = 0;
                                }
                                if ($request->tuesday) {
                                    $tuesday = 1;
                                } else {
                                    $tuesday = 0;
                                }
                                if ($request->wendsday) {
                                    $wendsday = 1;
                                } else {
                                    $wendsday = 0;
                                }
                                if ($request->thursday) {
                                    $thursday = 1;
                                } else {
                                    $thursday = 0;
                                }
                                if ($request->friday) {
                                    $friday = 1;
                                } else {
                                    $friday = 0;
                                }
                                if ($request->saturday) {
                                    $saturday = 1;
                                } else {
                                    $saturday = 0;
                                }
                                if ($request->sunday) {
                                    $sunday = 1;
                                } else {
                                    $sunday = 0;
                                }

                                RecurrentEmploye::create([

                                    'date_start' => $fecha->toDateString(),
                                    'date_end'   => $request->date_end,
                                    'monday'     => $monday,
                                    'tuesday'    => $tuesday,
                                    'wendsday'   => $wendsday,
                                    'thursday'   => $thursday,
                                    'friday'     => $friday,
                                    'saturday'   => $saturday,
                                    'sunday'     => $sunday,
                                    'time_start' => $request->time_start,
                                    'time_end'   => $request->time_end,
                                    'employe_id' => $employe->id,

                                ]);

                                $employe->update([

                                    'name'          => $request->name,
                                    'category'      => $request->category,
                                    'type'          => $type->id,
                                    'file_name'     => $fileName,
                                    'url_file'      => $url . $fileName,
                                    'file_size'     => $fileSize,
                                    'file_type'     => $fileType,

                                ]);
                            }
                        } else {

                            $type = EmployeType::where('name', "eventual")->first();
                            $type2 = $employe->type;
                            if ($type2 == $type->id) {
                                $employe->update([

                                    'name'          => $request->name,
                                    'category'      => $request->category,
                                    'file_name'     => $fileName,
                                    'url_file'      => $url . $fileName,
                                    'file_size'     => $fileSize,
                                    'file_type'     => $fileType,
                                ]);
                            } else {
                                $employe->update([

                                    'name'          => $request->name,
                                    'category'      => $request->category,
                                    'type'          => $type->id,
                                    'file_name'     => $fileName,
                                    'url_file'      => $url . $fileName,
                                    'file_size'     => $fileSize,
                                    'file_type'     => $fileType,

                                ]);

                                $recurrentemployes = RecurrentEmploye::findOrfail($request->recurrent_id);
                                $recurrentemployes->forceDelete();
                            }
                        }
                    }
                }
            }
        } else {
            $fecha = Carbon::now();

            if ($request->employe_type == "recurrente") {
                $type = EmployeType::where('name', "recurrente")->first();
                $type2 = $employe->type;

                if ($type2 == $type->id) {
                    if ($request->monday) {
                        $monday = 1;
                    } else {
                        $monday = 0;
                    }
                    if ($request->tuesday) {
                        $tuesday = 1;
                    } else {
                        $tuesday = 0;
                    }
                    if ($request->wendsday) {
                        $wendsday = 1;
                    } else {
                        $wendsday = 0;
                    }
                    if ($request->thursday) {
                        $thursday = 1;
                    } else {
                        $thursday = 0;
                    }
                    if ($request->friday) {
                        $friday = 1;
                    } else {
                        $friday = 0;
                    }
                    if ($request->saturday) {
                        $saturday = 1;
                    } else {
                        $saturday = 0;
                    }
                    if ($request->sunday) {
                        $sunday = 1;
                    } else {
                        $sunday = 0;
                    }

                    $recurrentemploye = RecurrentEmploye::findOrfail($request->recurrent_id);

                    $recurrentemploye->update([

                        'date_start' => $fecha->toDateString(),
                        'date_end'   => $request->date_end,
                        'monday'     => $monday,
                        'tuesday'    => $tuesday,
                        'wendsday'   => $wendsday,
                        'thursday'   => $thursday,
                        'friday'     => $friday,
                        'saturday'   => $saturday,
                        'sunday'     => $sunday,
                        'time_start' => $request->time_start,
                        'time_end'   => $request->time_end,

                    ]);

                    $employe->update([

                        'name'          => $request->name,
                        'category'      => $request->category,
                        'type'          => $type->id,

                    ]);
                } else {
                    if ($request->monday) {
                        $monday = 1;
                    } else {
                        $monday = 0;
                    }
                    if ($request->tuesday) {
                        $tuesday = 1;
                    } else {
                        $tuesday = 0;
                    }
                    if ($request->wendsday) {
                        $wendsday = 1;
                    } else {
                        $wendsday = 0;
                    }
                    if ($request->thursday) {
                        $thursday = 1;
                    } else {
                        $thursday = 0;
                    }
                    if ($request->friday) {
                        $friday = 1;
                    } else {
                        $friday = 0;
                    }
                    if ($request->saturday) {
                        $saturday = 1;
                    } else {
                        $saturday = 0;
                    }
                    if ($request->sunday) {
                        $sunday = 1;
                    } else {
                        $sunday = 0;
                    }

                    RecurrentEmploye::create([

                        'date_start' => $fecha->toDateString(),
                        'date_end'   => $request->date_end,
                        'monday'     => $monday,
                        'tuesday'    => $tuesday,
                        'wendsday'   => $wendsday,
                        'thursday'   => $thursday,
                        'friday'     => $friday,
                        'saturday'   => $saturday,
                        'sunday'     => $sunday,
                        'time_start' => $request->time_start,
                        'time_end'   => $request->time_end,
                        'employe_id' => $employe->id,

                    ]);

                    $employe->update([

                        'name'          => $request->name,
                        'category'      => $request->category,
                        'type'          => $type->id,

                    ]);
                }
            } else {

                $type = EmployeType::where('name', "eventual")->first();
                $type2 = $employe->type;
                if ($type2 == $type->id) {
                    $employe->update([

                        'name'          => $request->name,
                        'category'      => $request->category,
                    ]);
                } else {
                    $employe->update([

                        'name'          => $request->name,
                        'category'      => $request->category,
                        'type'          => $type->id,

                    ]);

                    $recurrentemployes = RecurrentEmploye::findOrfail($request->recurrent_id);
                    $recurrentemployes->forceDelete();
                }
            }
        }
    }
}
