<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\GuardSchedule;

class GuardInfo extends Model
{
    use SoftDeletes;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    
    protected $table = 'guard_infos';
    protected $fillable = ['name_guard','days','time_in','time_out','phone','schedule'];

    /** FUNCION QUE CREA INFORMACIPON DE GUARDIAS **/
    public static function createGuardInfo($request)
    {
    	
        $guard = GuardInfo::create([

            'name_guard' => $request->name_guard,
            'phone' => $request->phone,    

        ]);

        for ($i=0; $i < count($request->days); $i++)
        {
            if($request->schedule[$i] == null || $request->days[$i] == null)
            {

            }
            else
            {
                GuardSchedule::create([

                    'guard_id' => $guard->id,
                    'days'     => $request->days[$i],
                    'schedule' => $request->schedule[$i], 

                ]);

            }

        }
    }

    /** FUNCION QUE ACTUALIZA INFORMACIPON DE GUARDIAS **/
    public static function updateGuardInfo($request,$guardInfo)
    {
    	
        $guardInfo->update([

            'name_guard' => $request->name_guard,
            'phone' => $request->phone,
        ]);

        for ($i=0; $i < count($request->id); $i++)
        {
            if($request->schedulee[$i] == null || $request->dayse[$i] == null)
            {

            }
            else
            {
                $schedule =  GuardSchedule::findOrfail($request->id[$i]);
                $schedule->update([

                    'days'     => $request->dayse[$i],
                    'schedule' => $request->schedulee[$i], 

                ]);
            }
        }

        if($request->days)
        {
            for ($i=0; $i < count($request->days); $i++)
            {              
                if($request->schedule[$i] == null || $request->days[$i] == null)
                {

                }
                else
                {
                    GuardSchedule::create([

                        'guard_id' => $guardInfo->id,
                        'days'     => $request->days[$i],
                        'schedule' => $request->schedule[$i], 

                    ]);

                }
            }
        }



    }

}
