<?php

namespace App\Http\Controllers\API;

use App\User; // Asegúrate de usar el espacio de nombres correcto
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    public function login(Request $request)
    {
        // Validar las credenciales del usuario
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required|string',
            // 'device_token' => 'required|string'
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $credentials = $request->only('email', 'password');

        // Verificar las credenciales y autenticar al usuario
        if (!Auth::attempt($credentials)) {
            return response()->json(['message' => 'Credenciales inválidas'], 401);
        }

        // Obtener el usuario autenticado
        $user = User::where('email', $request->email)->first();

        // Generar y obtener el token de acceso para el usuario
        $token = $user->createToken('token-name')->plainTextToken;

        // $user->device_token = $request->device_token;
        $user->save();

        return response()->json([
            'token' => $token,
        ]);
    }

    public function logout(Request $request)
    {
        // Obtener el usuario autenticado
        $user = Auth::user();

        if ($user) {
            // Revocar todos los tokens del usuario
            $user->tokens()->delete();
        }

        return response()->json(['message' => 'Sesión cerrada exitosamente']);
    }

    public function multiLogin($apiToken)
    {
        // Si el usuario ya está logeado, lo redirigimos al dashboard
        if (Auth::check()) {
            return redirect()->route('admin.dashboard');
        }

        $user = User::whereHas('tokens', function ($query) use ($apiToken) {
            $query->where('token', hash('sha256', $apiToken));
        })->first();

        if (!$user) {
            abort(401, 'Token inválido');
        }

        // Logeamos al usuario en el sistema
        Auth::login($user);
        return redirect()->route('admin.dashboard');
    }
}
