<?php

namespace App\Http\Controllers;

use App\AccessColony;
use Illuminate\Http\Request;
use Auth;
use App\AccessType;
use App\Employe;
use DB;
use Validator;
use App\EmployeType;
use App\Visit;
use App\Street;
use Carbon\Carbon;
use Input;
use App\User;
use App\Config;
use QrCode;

class AccessColonyController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $user = User::find(Auth::id());

        $permission = Config::permissionDebtors();
        if ($permission == 1) {
            $em = AccessType::where('name', 'empleado')->first();
            $in = AccessType::where('name', 'invitado')->first();
            $vi = AccessType::where('name', 'visitante')->first();

            $residencia = $request->input('streetnumber');

            //$residencia = $request->input('streetnumber3');

            $fechatodos1 = $request->input('fechatodos1');
            $fechatodos2 = $request->input('fechatodos2');
            $calle = $request->street;
            $searchstreetnumber = $request->input('searchstreetnumber');
            //dd($streetId);

            /*$fechatodos1 = $request->input('fechaempleados1');
            $fechatodos2 = $request->input('fechaempleados2');

            $fechatodos1 = $request->input('fechavisitas1');
            $fechatodos2 = $request->input('fechavisitas2');*/

            $tipo1 = $request->input('tipo1');

            $id = Auth::user()->street_id;

            if ($tipo1 == 1) {
            } elseif ($tipo1 == 2) {
            } elseif ($tipo1 == 3) {
            } else {
            }

            if ($id == 1) {
                $acces = AccessColony::join('access_types', 'type', '=', 'access_types.id')
                    ->leftjoin('employes', 'employe_id', '=', 'employes.id')
                    ->leftjoin('employes_types', 'employes.type', '=', 'employes_types.id')
                    ->leftjoin('recurrent_employes', 'recurrent_employes.employe_id', '=', 'employes.id')
                    ->leftjoin('visits', 'visits.id', '=', 'visit_id')
                    ->leftjoin('guest', 'guest.id', '=', 'guest_id')
                    ->leftjoin('streets', 'streets.id', '=', 'access_colonies.residence_id')
                    ->select('streets.name_street as nameR', 'streets.number as nameN', 'employes.name as names', 'visits.name as namev', 'guest.name_guest as nameg', 'access_types.name_type', 'date', 'access_colonies.check_in', 'access_colonies.check_out', 'employes_types.name as etype', 'time_start', 'time_end', 'guard_create')
                    //->where('access_colonies.residence_id',Auth::user()->street_id)
                    ->when($fechatodos1, function ($query) use ($fechatodos1, $fechatodos2) {

                        if (is_null($fechatodos2)) {
                            return $query->where('access_colonies.date', '>=', $fechatodos1);
                        } else {

                            return $query->whereBetween('access_colonies.date', [$fechatodos1, $fechatodos2]);
                        }
                    })
                    ->when($fechatodos2, function ($query) use ($fechatodos1, $fechatodos2) {

                        if (is_null($fechatodos1)) {
                            return $query->where('access_colonies.date', '<=', $fechatodos2);
                        }
                    })
                    ->when($residencia, function ($query) use ($residencia) {
                        return $query->where('access_colonies.residence_id', $residencia);
                    })
                    ->where('access_colonies.check_in', '!=', null)
                    //->where('access_colonies.check_out','!=',null)
                    ->orderBy('access_colonies.date', 'DESC')
                    ->paginate($perPage = 15, $columns = ['*'], $pageName = 'acces');
            } else {
                $acces = AccessColony::join('access_types', 'type', '=', 'access_types.id')
                    ->leftjoin('employes', 'employe_id', '=', 'employes.id')
                    ->leftjoin('employes_types', 'employes.type', '=', 'employes_types.id')
                    ->leftjoin('recurrent_employes', 'recurrent_employes.employe_id', '=', 'employes.id')
                    ->leftjoin('visits', 'visits.id', '=', 'visit_id')
                    ->leftjoin('guest', 'guest.id', '=', 'guest_id')
                    ->select('employes.name as names', 'visits.name as namev', 'guest.name_guest as nameg', 'access_types.name_type', 'date', 'access_colonies.check_in', 'access_colonies.check_out', 'employes_types.name as etype', 'time_start', 'time_end', 'guard_create')
                    ->where('access_colonies.residence_id', Auth::user()->street_id)
                    ->when($fechatodos1, function ($query) use ($fechatodos1, $fechatodos2) {

                        if (is_null($fechatodos2)) {
                            return $query->where('access_colonies.date', '>=', $fechatodos1);
                        } else {

                            return $query->whereBetween('access_colonies.date', [$fechatodos1, $fechatodos2]);
                        }
                    })
                    ->when($fechatodos2, function ($query) use ($fechatodos1, $fechatodos2) {

                        if (is_null($fechatodos1)) {
                            return $query->where('access_colonies.date', '<=', $fechatodos2);
                        }
                    })
                    ->where('access_colonies.check_in', '!=', null)
                    //->where('access_colonies.check_out','!=',null)
                    ->orderBy('access_colonies.date', 'DESC')
                    ->paginate($perPage = 15, $columns = ['*'], $pageName = 'acces');
            }


            $employe = AccessColony::join('employes', 'employe_id', '=', 'employes.id')
                ->join('employes_categories', 'category', '=', 'employes_categories.id')
                ->join('employes_types', 'employes.type', '=', 'employes_types.id')
                ->leftjoin('recurrent_employes', 'recurrent_employes.employe_id', '=', 'employes.id')
                ->select('employes.name as names', 'name_category', 'date', 'access_colonies.check_in', 'check_out', 'time_start', 'time_end', 'employes_types.name as typename', 'guard_create')
                ->where('access_colonies.type', $em->id)
                ->where('access_colonies.residence_id', Auth::user()->street_id)
                ->when($fechatodos1, function ($query) use ($fechatodos1, $fechatodos2) {

                    if (is_null($fechatodos2)) {
                        return $query->where('access_colonies.date', '>=', $fechatodos1);
                    } else {

                        return $query->whereBetween('access_colonies.date', [$fechatodos1, $fechatodos2]);
                    }
                })
                ->when($fechatodos2, function ($query) use ($fechatodos1, $fechatodos2) {

                    if (is_null($fechatodos1)) {

                        return $query->where('access_colonies.date', '<=', $fechatodos2);
                    }
                })
                ->where('access_colonies.check_in', '!=', null)
                //->where('access_colonies.check_out','!=',null)
                ->orderBy('access_colonies.date', 'DESC')
                ->paginate($perPage = 15, $columns = ['*'], $pageName = 'employe');


            if ($id == 1) {
                $guest = AccessColony::join('access_types', 'type', '=', 'access_types.id')
                    /*->leftjoin('employes','employe_id','=','employes.id')
                    ->leftjoin('employes_types','employes.type','=','employes_types.id')
                    ->leftjoin('recurrent_employes','recurrent_employes.employe_id','=','employes.id')
                    ->leftjoin('visits','visits.id','=','visit_id')
                    ->leftjoin('guest','guest.id','=','guest_id')
                    ->leftjoin('streets','streets.id','=','access_colonies.residence_id')
                    //->where('access_colonies.residence_id',Auth::user()->street_id)
                    ->when($fechatodos1, function ($query) use ($fechatodos1,$fechatodos2) {
                            
                        if(is_null($fechatodos2))
                        {
                            return $query->where('access_colonies.date','>=',$fechatodos1);
                        }
                        else
                        {
                                
                            return $query->whereBetween('access_colonies.date',[$fechatodos1,$fechatodos2]);
                                
                        }
                        
                    })
                    ->when($fechatodos2, function ($query) use ($fechatodos1,$fechatodos2) {
                            
                        if(is_null($fechatodos1))
                        {   
                            return $query->where('access_colonies.date','<=',$fechatodos2);
                        }
                        
                    })
                    ->when($residencia, function ($query) use ($residencia){
                        return $query->where('access_colonies.residence_id',$residencia);
                    })
                    ->where('access_colonies.check_in','!=',null)
                    //->where('access_colonies.check_out','!=',null)
                    ->where('access_colonies.residence_id','!=',1)
                    ->orderBy('access_colonies.date','DESC')
                    ->get(['streets.name_street as nameR','streets.number as nameN','employes.name as names','visits.name as namev','guest.name_guest as nameg','access_types.name_type','date','access_colonies.check_in','access_colonies.check_out','employes_types.name as etype','time_start','time_end','guard_create']);*/
                    ->leftjoin('employes', 'employe_id', '=', 'employes.id')
                    ->leftjoin('employes_types', 'employes.type', '=', 'employes_types.id')
                    ->leftjoin('recurrent_employes', 'recurrent_employes.employe_id', '=', 'employes.id')
                    ->leftjoin('guest', 'guest_id', '=', 'guest.id')
                    ->leftjoin('visits', 'visits.id', '=', 'visit_id')
                    ->leftjoin('streets', 'streets.id', '=', 'access_colonies.residence_id')
                    ->select('streets.name_street as nameR', 'streets.number as nameN', 'employes.name as names', 'visits.name as namev', 'guest.name_guest as nameg', 'access_types.name as namest', 'access_types.name_type', 'date', 'access_colonies.check_in', 'access_colonies.check_out', 'employes_types.name as etype', 'time_start', 'time_end', 'guard_create', 'visits.url_file as vurl_file', 'guest.url_file as gurl_file', 'guard_create')
                    //->select('streets.name_street as nameR','streets.number as nameN','employes.name as names','visits.name as namev','guest.name_guest as nameg','access_types.name_type','date','access_colonies.check_in','access_colonies.check_out','employes_types.name as etype','time_start','time_end','guard_create','visits.url_file as vurl_file','guest.url_file as gurl_file','guard_create')
                    //->select('streets.name_street as nameR','streets.number as nameN','guest.name_guest as names','visits.name as namev','name_type','access_types.name as namest','date','check_in','check_out','visits.url_file as vurl_file','guest.url_file as gurl_file','guard_create')
                    //->where('access_colonies.residence_id',Auth::user()->street_id)
                    ->when($fechatodos1, function ($query) use ($fechatodos1, $fechatodos2) {

                        if (is_null($fechatodos2)) {
                            return $query->where('access_colonies.date', '>=', $fechatodos1);
                        } else {

                            return $query->whereBetween('access_colonies.date', [$fechatodos1, $fechatodos2]);
                        }
                    })
                    ->when($fechatodos2, function ($query) use ($fechatodos1, $fechatodos2) {

                        if (is_null($fechatodos1)) {
                            return $query->where('access_colonies.date', '<=', $fechatodos2);
                        }
                    })
                    ->when($residencia, function ($query) use ($residencia) {
                        return $query->where('access_colonies.residence_id', $residencia);
                    })
                    ->where('access_colonies.check_in', '!=', null)
                    //->where('access_colonies.check_out','!=',null)
                    ->where('access_colonies.residence_id', '!=', 1)
                    ->orderby('access_colonies.date', 'DESC')
                    ->paginate($perPage = 15, $columns = ['*'], $pageName = 'guest');
            } else {
                $guest = AccessColony::join('access_types', 'type', '=', 'access_types.id')
                    ->leftjoin('guest', 'guest_id', '=', 'guest.id')
                    ->leftjoin('visits', 'visits.id', '=', 'visit_id')
                    ->select('guest.name_guest as names', 'visits.name as namev', 'name_type', 'access_types.name as namest', 'date', 'check_in', 'check_out', 'visits.url_file as vurl_file', 'guest.url_file as gurl_file', 'guard_create')
                    ->where('access_colonies.residence_id', Auth::user()->street_id)
                    ->where(function ($query) use ($vi, $in) {
                        $query->where('access_colonies.type', $vi->id)
                            ->orwhere('access_colonies.type', $in->id);
                    })
                    ->when($fechatodos1, function ($query) use ($fechatodos1, $fechatodos2) {

                        if (is_null($fechatodos2)) {
                            return $query->where('access_colonies.date', '>=', $fechatodos1);
                        } else {

                            /*$fecha = strtotime ( '+1 days' , strtotime ($fechatodos2));
                                $fecha  = date ( 'Y-m-d' , $fecha );*/
                            return $query->whereBetween('access_colonies.date', [$fechatodos1, $fechatodos2]);
                        }
                    })
                    ->when($fechatodos2, function ($query) use ($fechatodos1, $fechatodos2) {

                        if (is_null($fechatodos1)) {
                            /*$fechat = strtotime ( '+1 days' , strtotime ($fechatodos2));
                                $fechat  = date ( 'Y-m-d' , $fechat );
                                return $query->where('access_colonies.date','<=',$fechat);*/
                            return $query->where('access_colonies.date', '<=', $fechatodos2);
                        }
                    })
                    ->where('access_colonies.check_in', '!=', null)
                    //->where('access_colonies.check_out','!=',null)
                    ->orderby('access_colonies.date', 'DESC')
                    ->paginate($perPage = 15, $columns = ['*'], $pageName = 'guest');
            }

            /*$guest = AccessColony::join('access_types','type','=','access_types.id')
                    ->leftjoin('guest','guest_id','=','guest.id')
                    ->leftjoin('visits','visits.id','=','visit_id')
                    ->select('guest.name_guest as names','visits.name as namev','name_type','access_types.name as namest','date','check_in','check_out','visits.url_file as vurl_file','guest.url_file as gurl_file','guard_create')
                    ->where('access_colonies.residence_id',Auth::user()->street_id)
                    ->where(function ($query) use ($vi,$in) {
                        $query->where('access_colonies.type',$vi->id)
                            ->orwhere('access_colonies.type', $in->id);
                    })
                    ->when($fechatodos1, function ($query) use ($fechatodos1,$fechatodos2) {
                            
                        if(is_null($fechatodos2))
                        {
                            return $query->where('access_colonies.date','>=',$fechatodos1);
                        }
                        else
                        {
                                
                            
                            return $query->whereBetween('access_colonies.date',[$fechatodos1,$fechatodos2]);
                                
                        }
                        
                    })
                    ->when($fechatodos2, function ($query) use ($fechatodos1,$fechatodos2) {
                            
                        if(is_null($fechatodos1))
                        {   
                            
                            return $query->where('access_colonies.date','<=',$fechatodos2);
                        }
                        
                    })
                    ->where('access_colonies.check_in','!=',null)
                    ->where('access_colonies.check_out','!=',null)
                    ->orderby('access_colonies.date','DESC')
                    ->get(); */


            $a = 0;

            $h = 0;
            $n = 0;
            if ($tipo1 == 1) {
                $h = 1;
            } elseif ($tipo1 == 2) {
                $h = 2;
            } elseif ($tipo1 == 3) {
                $h = 3;
            } else {
                $h = 0;
            }
            if (!is_null($fechatodos1) && $tipo1 == 1) {
                $h = 1;
            }
            if (!is_null($fechatodos2) && $tipo1 == 1) {
                $h = 1;
            }


            if (!is_null($fechatodos1) && $tipo1 == 2) {
                $h = 2;
            }
            if (!is_null($fechatodos2) && $tipo1 == 2) {
                $h = 2;
            }

            if (!is_null($fechatodos1) && $tipo1 == 3) {
                $h = 3;
            }
            if (!is_null($fechatodos2) && $tipo1 == 3) {
                $h = 3;
            }
            if (!is_null($residencia) && $tipo1 == 1) {
                //$residencia = Street::findOrfail($residencia);      
                $h = 1;
            }
            if (!is_null($residencia) && $tipo1 == 3) {
                $h = 3;
            }


            $data = [
                'acces' => $acces,
                'fechatodos1' => $fechatodos1,
                'fechatodos2' => $fechatodos2,
                'tipo1' => $tipo1
            ];
            $residen = $residencia;
            return view('access_colony.history_access', compact('id', 'acces', 'employe', 'guest', 'a', 'h', 'n', 'fechatodos1', 'fechatodos2',   'data', 'tipo1', 'residen', 'calle', 'searchstreetnumber'));
        } else {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $user = User::find(Auth::id());

        $permission = Config::permissionDebtors();
        if ($permission == 1) {
            $access_type = AccessType::where('name', 'visitante')->Orwhere('name', 'empleado')->get();
            $employe = Employe::where('residence_id', Auth::user()->street_id)->get();
            if ($request->abierto == 1) {
                $abierto = 1;
            } else {
                $abierto = 0;
            }

            $type = EmployeType::all();

            $visit = Visit::join('employes_types', 'employes_types.id', '=', 'type')
                ->select('visits.id', 'visits.name as vname', 'type', 'name_type', 'url_file')
                ->where('residence_id', Auth::user()->street_id)
                ->paginate(15);

            if ($visit->isEmpty()) {
                $visit = "";
            }
            $b = 0;
            $a = 0;
            if ($request->u) {
                $modal = 1;
                $u = $request->u;
                $n = $request->n;
            } else {
                $modal = 0;
                $u = "";
                $n = "";
            }

            return view('access_colony.create', compact('access_type', 'employe', 'abierto', 'type', 'visit', 'a', 'b', 'modal', 'u', 'n'));
        } else {
            return redirect('/home');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {


        try {

            $messages = [

                'mimes'         => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                'max'           => 'el archivo no debe pesar mas de 5 mb.',
                'uploaded'      => 'El archivo no debe pesar mas de 5 mb.',
                'required'      => 'Este campo es requerido.',
                'required_if'   => 'Este campo es requerido.',
            ];

            $rules = [
                'name'          => 'required',
                'visit_type'    => 'required',
                'date'          => 'required_if:visit_type,eventual',
                'file'          => 'max:5000|mimes:jpeg,jpg,png', //5000kb image/jpeg image/png
                'file1'         => 'max:5000|mimes:jpeg,jpg,png',

            ];

            $validator = Validator::make($request->all(), $rules, $messages);

            if ($validator->fails()) {

                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            } else {

                DB::beginTransaction();
                $a_id = Visit::createVisit($request);
                DB::commit();

                /// nuevo
                if ($request->visit_type == "recurrente") {
                    $id_visit = $a_id->id;
                    $type_access = 1;
                    $type = 3;

                    return redirect()->action('AccessColonyController@create');
                } else {
                    $id_visit = $a_id->id;
                    $type_access = 2;
                    $type = $a_id->type;

                    $date = Carbon::now();
                    $qstr = str_random(8);
                    $qrdate = $request->date;
                    $nameqr =  $qstr . $id_visit . $qrdate . '.png';
                    $url = '/qrcodes/' . $nameqr;
                    $path = public_path() . $url;

                    QrCode::format('png')->size(500)->merge('/public/assets/image-resources/logoqr.png', .1, false)->generate($id_visit . "/" . $type_access . "/" . $type . "/" . $qrdate, $path);

                    //ID de acceso
                    $str = strlen($nameqr);

                    $idn = substr($nameqr, 8, 2);
                    $idacc = $id_visit;

                    //ID de visitante
                    $idvd = $a_id->visit_id;
                    $pas1_7 = str_replace('{', '55', $idvd);
                    $pas2_7 = str_replace('}', '', $pas1_7);
                    $vidf = $pas2_7;

                    //ID de la residencia
                    $rid = Visit::join('employes_types', 'employes_types.id', '=', 'type')
                        ->select('visits.residence_id')
                        ->where('residence_id', Auth::user()->street_id)
                        ->where('visits.id', '=', $idvd)
                        ->get();

                    $pas1_3 = substr($rid, 17);
                    $pas2_3 = str_replace('}]', '', $pas1_3);
                    $ridf = $pas2_3;

                    //Nombre del visitante
                    $visit2 = Visit::join('employes_types', 'employes_types.id', '=', 'type')
                        ->select('visits.name')
                        ->where('residence_id', Auth::user()->street_id)
                        ->where('visits.id', '=', $idvd)
                        ->get();

                    $pas1 = substr($visit2, 10);
                    $pas2 = str_replace('"}]', '', $pas1);
                    $nameVisit = $pas2;

                    $nameVisit = str_replace('\u00c1', 'Á', $nameVisit);
                    $nameVisit = str_replace('u00c1', 'Á', $nameVisit);
                    $nameVisit = str_replace('\u00e1', 'á', $nameVisit);
                    $nameVisit = str_replace('u00e1', 'á', $nameVisit);
                    $nameVisit = str_replace('\u00c9', 'É', $nameVisit);
                    $nameVisit = str_replace('u00c9', 'É', $nameVisit);
                    $nameVisit = str_replace('\u00e9', 'é', $nameVisit);
                    $nameVisit = str_replace('u00e9', 'é', $nameVisit);
                    $nameVisit = str_replace('\u00cd', 'Í', $nameVisit);
                    $nameVisit = str_replace('u00cd', 'Í', $nameVisit);
                    $nameVisit = str_replace('\u00ed', 'í', $nameVisit);
                    $nameVisit = str_replace('u00ed', 'í', $nameVisit);
                    $nameVisit = str_replace('\u00d3', 'Ó', $nameVisit);
                    $nameVisit = str_replace('u00d3', 'Ó', $nameVisit);
                    $nameVisit = str_replace('\u00f3', 'ó', $nameVisit);
                    $nameVisit = str_replace('u00f3', 'ó', $nameVisit);
                    $nameVisit = str_replace('\u00da', 'Ú', $nameVisit);
                    $nameVisit = str_replace('u00da', 'Ú', $nameVisit);
                    $nameVisit = str_replace('\u00fa', 'ú', $nameVisit);
                    $nameVisit = str_replace('u00fa', 'ú', $nameVisit);
                    $nameVisit = str_replace('\u00d1', 'Ñ', $nameVisit);
                    $nameVisit = str_replace('u00d1', 'Ñ', $nameVisit);
                    $nameVisit = str_replace('\u00f1', 'ñ', $nameVisit);
                    $nameVisit = str_replace('u00f1', 'ñ', $nameVisit);
                    $nameVisit = str_replace('\u00b4', '´', $nameVisit);
                    $nameVisit = str_replace('u00b4', '´', $nameVisit);
                    $nameVisit = str_replace('\u00fc', 'ü', $nameVisit);
                    $nameVisit = str_replace('u00fc', 'ü', $nameVisit);
                    $nameVisit = str_replace('\u00dc', 'Ü', $nameVisit);
                    $nameVisit = str_replace('u00dc', 'Ü', $nameVisit);

                    /*$errors = ['error' => $nameVisit];
                    return redirect()->back()
                        ->withErrors($errors);*/

                    //URL de la colonia 
                    $urls = DB::table('domine_colonies')
                        ->select('url')
                        ->get();

                    $pas1_1 = substr($urls, 9);
                    $pas2_1 = str_replace('"}]', '', $pas1_1);
                    $pas3_1 = str_replace('\/', '/', $pas2_1);
                    $urlf = $pas3_1;

                    //Calle y numero de la residencia
                    $residence = DB::table('streets')
                        ->where('id', '=', Auth::user()->street_id)
                        ->select('name_street', 'number')
                        ->get();

                    $pas1_4 = str_replace('[{"name_street":"', ' ', $residence);
                    $pas2_4 = str_replace('","number":"', ' ', $pas1_4);
                    $pas3_4 = str_replace('"}]', ' ', $pas2_4);
                    $residencef = $pas3_4;

                    //Imagen nuevax
                    $im = imagecreate(600, 200);
                    $bg = imagecolorallocate($im, 255, 255, 255);
                    $textcolor = imagecolorallocate($im, 0, 0, 0);
                    $textcolora = imagecolorallocate($im, 51, 122, 230);
                    $string1_1 = "QR de uso unico";
                    $font = 'fonts/arial.ttf';
                    imagettftext($im, 11, 0, 198, 11, $textcolor, $font, $string1_1);

                    $string1_1 = "Expira el:";
                    //imagestring($im, 3, 0, 15, $string1_1, $textcolor);
                    imagettftext($im, 12, 0, 72, 35, $textcolor, $font, $string1_1);
                    $string2_1 = "" . $qrdate;
                    //imagestring($im, 3, 100, 15, $string2_1, $textcolora);
                    imagettftext($im, 12, 0, 142, 35, $textcolora, $font, $string2_1);

                    $string1_3 = "Direccion:";
                    //imagestring($im, 3, 0, 27, $string1_2, $textcolor);
                    imagettftext($im, 12, 0, 72, 60, $textcolor, $font, $string1_3);
                    $string2_3 = "" . $residencef;
                    //imagestring($im, 3, 100, 27, $string2_2, $textcolora);
                    imagettftext($im, 12, 0, 145, 60, $textcolora, $font, $string2_3);

                    $string1_4 = "Invitado:";
                    //imagestring($im, 3, 0, 38, $string1_2, $textcolor);
                    imagettftext($im, 12, 0, 72, 85, $textcolor, $font, $string1_4);
                    $string2_4 = "" . $nameVisit;
                    //imagestring($im, 3, 93, 38, $string2_2, $textcolora);
                    imagettftext($im, 12, 0, 135, 85, $textcolora, $font, $string2_4);

                    /*$string1_5 = "Sitio web:";                              
                    //imagestring($im, 3, 0, 49, $string1_2, $textcolor);
                    imagettftext($im, 11, 0, 165, 112, $textcolor, $font, $string1_5); */
                    $string2_5 = "https://residenz.mx/";
                    //imagestring($im, 3, 100, 49, $string2_2, $textcolora);   
                    imagettftext($im, 11, 0, 190, 112, $textcolora, $font, $string2_5);

                    $nu = substr($url, 1);

                    $baseimagen = ImageCreate(500, 580);
                    $black = ImageColorAllocate($baseimagen, 255, 255, 255);
                    $ts_viewer = ImageCreateFromPng($nu);
                    $union2 = imagecopymerge($baseimagen, $ts_viewer, 0, 20, 0, 0, 500, 600, 100);
                    $img1 = ImageCreateFromPng('images/logo_residenz_ok.png');
                    $union3 = imagecopymerge($baseimagen, $im, 0, 455, 0, 0, 500, 200, 100);
                    $union1 = imagecopymerge($baseimagen, $img1, 200, 25, 0, 0, 300, 40, 100);
                    header("Content-Type: image/png");
                    ImagePng($baseimagen, "qrcodes/" . $nameqr);

                    $url = '/qrcodes/' . $nameqr;

                    return redirect()->action('AccessColonyController@create', ['abierto' => 1, 'u' => $url, 'n' => $nameqr]);
                }
            }
        } catch (\Illuminate\Database\QueryException $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        } catch (\Exception $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\AccessColony  $accessColony
     * @return \Illuminate\Http\Response
     */
    public function show(AccessColony $accessColony)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\AccessColony  $accessColony
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $v = Visit::findOrfail($id);
        $visit = Visit::leftjoin('recurrent_visits', 'visit_id', '=', 'visits.id')
            ->where('visits.id', $id)
            ->first();

        $type = EmployeType::all();
        return view('access_colony.edit', compact('visit', 'type', 'v'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\AccessColony  $accessColony
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        try {

            $messages = [

                'mimes'         => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                'max'           => 'el archivo no debe pesar mas de 5 mb.',
                'uploaded'      => 'El archivo no debe pesar mas de 5 mb.',
                'required'      => 'Este campo es requerido.',
                'required_if'   => 'Este campo es requerido.',
            ];

            $rules = [
                'name'          => 'required',
                'visit_type'    => 'required',
                'file'          => 'max:5000|mimes:jpeg,jpg,png', //5000kb image/jpeg image/png
                'file1'         => 'max:5000|mimes:jpeg,jpg,png',

            ];

            $validator = Validator::make($request->all(), $rules, $messages);

            if ($validator->fails()) {

                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            } else {

                DB::beginTransaction();
                Visit::updateVisit($request, $id);
                DB::commit();
                return redirect()->action('AccessColonyController@create');
            }
        } catch (\Illuminate\Database\QueryException $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        } catch (\Exception $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\AccessColony  $accessColony
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        try {

            $visit = Visit::findOrfail($request->id);

            $visit->delete();
            return redirect('access_colony/create');
        } catch (\Illuminate\Database\QueryException $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
            //throw $e;

        } catch (\Exception $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
            //throw $e;
        }
    }
}
