<?php

namespace App\Http\Controllers;

use App\Account;
use Illuminate\Http\Request;
use Auth;
use Session;
use App\AccountType;
use Validator;

class AccountController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $user = Auth::user();

        if($user->can('index', \App\AccountInfo::class))
        {
            $accounts= Account::join('account_types','account_types.id','=','account_type')->get(['accounts.id as ids','account_name','description','balance','status','bank_name','number_account','branch_office','CLABE','card','titular','email']);
            if($accounts->isEmpty())
            {
                $account = $accounts->toArray();
            }
            else
            {
                $account = $accounts;
            }

            $account_type = AccountType::all();

            $a = 0;

            if($request->abierto == 1)
            {
                 $abierto = 1;
            }
            else
            {
                 $abierto = 0;
            }

            if($request->abierto1 == 1)
            {
                 $abierto1 = 1;
            }
            else
            {
                 $abierto1 = 0;
            }

            $e = 0;

            return view('accounts.index', compact('account','a','account_type','abierto','abierto1','e'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();

        /*if($user->can('create', \App\Account::class))
        {*/
            $account_type = AccountType::all();
            return view('accounts.create', compact('account_type'));
       /* }
        else
        {
            return redirect('/home');
        }*/
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         try{

          $messages = [
            'required'    => 'Este campo es requerido.',
            'required_if' => 'Este campo es requerido.',
            'min'      => 'No puede ser 0.',

          ];

          $rules = [

              'account_type'      => 'required',
              'description'       => 'required',
              'balance'           => 'required|min:0',
              'bank_name'         => 'required_if:account_type,1',
              'number_account'    => 'required_if:account_type,1',
              'CLABE'             => 'required_if:account_type,1',

          ];

          $validator = Validator::make($request->all(),$rules,$messages);

          if ($validator->fails()) {
           
              return redirect()->back()
                  ->withErrors($validator)
                  ->withInput();
          }
          else
          {

            
              Account::create([

                  'description'       => $request->description,
                  'account_type'      => $request->account_type,
                  'bank_name'         => $request->bank_name,
                  'balance'           => $request->balance,
                  'original_balance'  => $request->balance,
                  'number_account'    => $request->number_account,
                  'branch_office'     => $request->branch_office,
                  'CLABE'             => $request->CLABE,
                  'card'              => $request->card,
                  'titular'           => $request->titular,
                  'email'             => $request->email,
                  'status'            => 1,
              ]);

              return redirect()->action('AccountController@index', ['abierto' => "1"]);

          }


        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\AccountInfo  $accountInfo
     * @return \Illuminate\Http\Response
     */
    public function show(Account $account,$id)
    {
        

         $estado = Account::leftjoin(DB::raw('(SELECT  date,description,residence,amount FROM `payments` where account_id = "'.$id.'") as abonos'),'abonos.account_id','=','accounts.id')
          ->leftjoin(DB::raw('(SELECT  date,description,amount FROM `expenses` where account_id = "'.$id.'") as cargos'),'cargos.account_id','=','accounts.id')
          ->select('abonos.date','cargos.date','abonos.description','cargos.description','abonos.amount','cargos.amount')
          ->where('accounts.id', 1)
          ->orderBy('abonos.date', 'DESC')
          ->orderBy('cargos.date','DESC')
          ->get();

        dd($estado);
          

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\AccountInfo  $accountInfo
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
       
        try{

            $user = Auth::user();

            /*if($user->can('edit', $account))
            {*/ $account = Account::findOrfail($id);
                $account_type = AccountType::all();

                return view('accounts.edit', compact('account','account_type'));
            /*}
            else
            {*/
                return redirect('/home');
            //}

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\AccountInfo  $accountInfo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Account $account,$id)
    {
        
       
        try{

            $messages = [
              'required'    => 'Este campo es requerido.',
              'required_if' => 'Este campo es requerido.',
            ];

            $rules = [

                'account_type'      => 'required',
                'description'       => 'required',
                'bank_name'         => 'required_if:account_type,1',
                'number_account'    => 'required_if:account_type,1',
                'CLABE'             => 'required_if:account_type,1',

            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
             
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {
                $account = Account::findOrfail($id);
                $user = Auth::user();

                if($request->account_type == 1)
                {
                    
                    if($account->account_type == $request->account_type)
                    {
                        $account->update([

                            'description'       => $request->description,
                            'account_type'      => $request->account_type,
                            'bank_name'         => $request->bank_name,
                            'number_account'    => $request->number_account,
                            'branch_office'     => $request->branch_office,
                            'CLABE'             => $request->CLABE,
                            'card'              => $request->card,
                            'titular'           => $request->titular,
                            'email'             => $request->email,
                          
                            'status'            => 1,
                        ]);
                    }
                    else if($account->account_type == 2)
                    {
                        $account->update([

                            'description'       => $request->description,
                            'account_type'      => $request->account_type,
                            'bank_name'         => $request->bank_name,
                            'number_account'    => $request->number_account,
                            'branch_office'     => $request->branch_office,
                            'CLABE'             => $request->CLABE,
                            'card'              => $request->card,
                            'titular'           => $request->titular,
                            'email'             => $request->email,
                            
                            'status'            => 1,
                        ]);

                    }
                    else
                    {
                        $account->update([

                            'description'       => $request->description,
                            'account_type'      => $request->account_type,
                            'bank_name'         => null,
                            'number_account'    => null,
                            'branch_office'     => null,
                            'CLABE'             => null,
                            'card'              => null,
                            'titular'           => null,
                            'email'             => null,
                           
                            'status'            => 1,
                        ]);
                    }
                }
                else
                {
               

                        $account->update([

                            'description'       => $request->description,
                            'account_type'      => $request->account_type,
                            'bank_name'         => null,
                            'number_account'    => null,
                            'branch_office'     => null,
                            'CLABE'             => null,
                            'card'              => null,
                            'titular'           => null,
                            'email'             => null,
                           
                            'status'            => 1,
                        ]);
                    

                }
                

                return redirect('/bank');

            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\AccountInfo  $accountInfo
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        
        try{
            

            $user = Auth::user();
            
            /*if($user->can('delete', $accountInfo))
            {*/
                $account = Account::findOrfail($request->id);
                $account->delete();
                return redirect('/bank');
            /*}
            else
            {*/
                //return redirect('/home');
            //}

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }
}
