<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccountReceivable;
use DB;
use Carbon\Carbon;
use App\Status;
use Auth;
use App\Street;

class AccountStatusController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = Auth::user();
      
        if($user->can('index', \App\Income::class))
        {
            $ocultar = 0;
            $filtro = $request->input('filtro');
            $estatus = Status::where('name','activo')->first();
            if(!is_null($filtro))
            {
                $ocultar = 1;
            } 
           
            $date = Carbon::now();

            $total = AccountReceivable::select(DB::raw('SUM(to_pay) as pay'))
                ->where('estatus',$estatus->id)
                ->when($filtro, function ($query) use ($filtro) {
                       
                    return $query->where('residence',$filtro);
                })
                ->first();


            $estatus = Status::where('name','activo')->first();
            

            $estado = Street::leftjoin('accounts_receivables','streets.id','=','accounts_receivables.residence')
                ->leftjoin(DB::raw('(SELECT SUM(to_pay) as pasado,residence  FROM accounts_receivables WHERE deadline < "'.$date->toDateString().'" AND estatus = "'.$estatus->id.'"  GROUP BY accounts_receivables.residence) as corriente'),'accounts_receivables.residence','=','corriente.residence')
                ->leftjoin(DB::raw('(SELECT SUM(to_pay) as vigente,residence  FROM accounts_receivables WHERE deadline >= "'.$date->toDateString().'" AND estatus = "'.$estatus->id.'"  GROUP BY accounts_receivables.residence) as vencido'),'accounts_receivables.residence','=','vencido.residence')
                ->leftjoin(DB::raw('(SELECT SUM(to_pay) as pay,residence FROM accounts_receivables WHERE estatus = "8" GROUP BY residence) as deuda'),'accounts_receivables.residence','=','deuda.residence')
                ->leftjoin(DB::raw('(SELECT  pago,SUM(amount) as monto,residence FROM `payments` LEFT JOIN (SELECT sum(paid) as pago, id_payment FROM payments_account_receivables GROUP BY id_payment) as adelantado ON payments.id = adelantado.id_payment WHERE status = "10" GROUP BY residence) as pagoadelantado'),'streets.id','=','pagoadelantado.residence')
                ->select('pay','vigente','pasado','monto','pago','accounts_receivables.residence','name_street','number','streets.id as street_id')
                ->when($filtro, function ($query) use ($filtro) {
                       
                    return $query->where('streets.id',$filtro);
                })
                ->where('empty_residence',0)
                ->groupBy('streets.id')
                ->orderBy('name_street','ASC')
                ->orderBy('number','ASC')
                ->paginate(15);

            //dd($estado);

            $a = 0;
            $b = 0;
            $c = 0;
            $e = 0;
            $f = 0;
            

            $stado = Status::where('name','activo')->first();
                

            return view('account_status.index', compact('deuda','vencido','corriente','ii','a','b','c','total','e','stado','f','ocultar','totalvencido','totalcorriente','estado'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
