<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Payment;
use Auth;
use App\AccountReceivable;
use App\IncomeCategory;
use App\Status;
use App\Month;
use DB;
use App\Admin;
use App\Street;
use Carbon\Carbon;

class AccountToPayAdminController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
         
        //dd($request->all());
        $user = Auth::user();
      
        if($user->can('index', \App\Income::class))
        {
            $actual_month = Admin::getActualMonth();
            $activo = Status::where('name','activo')->first();
            $date = Carbon::now();
            $d = strtotime ($date->toDateString());
            $fecha = date ( 'Y-m-d' , $d );
            $h = 0;
            

            $filtro1 = $request->input('filter1');

            $suma1 = AccountReceivable::join('streets','streets.id','=','residence')
                ->select(DB::raw('SUM(to_pay) as pay'),DB::raw('SUM(debt) as deuda'))
                ->where('accounts_receivables.estatus',$activo->id)
                ->where('to_pay','!=',0)
                ->where('deadline','<',$date->toDateString())
                ->when($filtro1, function ($query) use ($filtro1) {
                    if($filtro1 == 1)
                    {
                        return $query->groupBy('name_street');   
                    }
                    elseif($filtro1 == 2)
                    {
                        return $query->groupBy('residence');
                    }
                    elseif($filtro1 == 3)
                    {
                        return $query->groupBy('category');
                    }
                })
                ->get();
            

          
            $vencida = AccountReceivable::join('months','accounts_receivables.month','=','months.id')
                ->join('income_categories','category','=','income_categories.id')
                ->join('streets','streets.id','=','residence')
                ->join('status','estatus','=','status.id')
                ->select('debt','to_pay','category_name','month_year_text','initial_debt','accounts_receivables.id as account_id','name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','residence', 'category','status.name as stname')
                ->where('accounts_receivables.estatus',$activo->id)
                ->where('to_pay','!=',0)
                ->where('deadline','<',$date->toDateString())
                ->when($filtro1, function ($query) use ($filtro1) {
                    if($filtro1 == 1)
                    {
                        return $query->orderBy('name_street','ASC');
                    }
                    elseif($filtro1 == 2)
                    {

                    }
                    elseif($filtro1 == 3)
                    {
                        return $query->orderBy('category','ASC');
                    }
                    else
                    {
                        
                    }
                })
                ->orderBy('residence','ASC')
                ->orderBy('accounts_receivables.month','ASC')
                ->get();
            if($vencida->isEmpty())
            {
                $vencida = "";
            }
            $iii = count($vencida);

           

            
            $filtro2 = $request->input('filter2');

            $suma = AccountReceivable::join('streets','streets.id','=','residence')
                ->select(DB::raw('SUM(to_pay) as pay'),DB::raw('SUM(debt) as deuda'))
                ->where('accounts_receivables.estatus',$activo->id)
                ->where('to_pay','!=',0)
                ->whereDate('deadline','>=',$date->toDateString())
                ->when($filtro2, function ($query) use ($filtro2) {
                    if($filtro2 == 1)
                    {
                        return $query->groupBy('name_street');   
                    }
                    elseif($filtro2 == 2)
                    {
                        return $query->groupBy('residence');
                    }
                    elseif($filtro2 == 3)
                    {
                        return $query->groupBy('category');
                    }
                })
                ->get();
            

            

            $corriente = AccountReceivable::join('months','accounts_receivables.month','=','months.id')
                ->join('income_categories','category','=','income_categories.id')
                ->join('streets','streets.id','=','residence')
                ->join('status','estatus','=','status.id')
                ->select('debt','to_pay','category_name','month_year_text','initial_debt','accounts_receivables.id as account_id','name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','residence','category','status.name as stname')
                ->where('accounts_receivables.estatus',$activo->id)
                ->where('to_pay','!=',0)
                ->whereDate('deadline','>=',$date->toDateString())
                ->when($filtro2, function ($query) use ($filtro2) {
                    if($filtro2 == 1)
                    {
                        return $query->orderBy('name_street','ASC');
                    }
                    elseif($filtro2 == 2)
                    {

                    }
                    elseif($filtro2 == 3)
                    {
                        return $query->orderBy('category','ASC');
                    }
                    else
                    {
                        
                    }
                })
                ->orderBy('residence','ASC')
                ->orderBy('accounts_receivables.month','ASC')
                ->get();
            if($corriente->isEmpty())
            {
                $corriente = "";
            }

           $i = count($corriente);
          
    
           ////// QUERY Y FILTRO DE HISTORICO //////////////////////
            $filtro3 = $request->input('filter3');
            $street = $request->input('streetnumber');
            $categoria = $request->input('category');
            $estado = $request->input('estatus');
            $fecha1 = $request->input('fecha1');
            $fecha2 = $request->input('fecha2');
            $historico = $request->input('historico');
           
            if(!is_null($estado))
            {
                
                $h = 3;
            }
            if(is_null($estado))
            {
                if($historico == 0)
                {
                    $estado = " ";
                }
                else
                {
                    $estado = null;

                }
                
            }
            

            if(is_null($estado) && is_null($filtro3) && is_null($street) && is_null($fecha1) && is_null($fecha2))
            {
                $ss = Status::where('name','activo')->first();
                $estado = $ss->id;
                $h = 0;
            }
            
            if($filtro3 == 4)
            {
                $estado = null;
            }
            
            
            //dd($estado);
            $suma3 = AccountReceivable::join('streets','streets.id','=','residence')
                ->select(DB::raw('SUM(to_pay) as pay'),DB::raw('SUM(debt) as deuda'),'category')
                ->withTrashed()
                ->when($street, function ($query) use ($street) {
                    return $query->where('residence',$street);
                })
                ->when($categoria, function ($query) use ($categoria) {
                    return $query->where('category',$categoria);
                })
                ->when($estado, function ($query) use ($estado,$filtro3) {

                    $esta = Status::where('name','cancelado')->first();
                    $estad = Status::where('name','incobrable')->first();
                    $esta2 = Status::where('name','activo')->first();
                    $esta3 = Status::where('name','pagado')->first();
                    
                    if($estado == $esta->id)
                    {
                        
                        return $query->where('estatus',$estado); 
                    }
                    elseif($estado ==  " ")
                    {
                       return $query->where('estatus','!=',$estad->id)
                                    ->where('estatus','!=',$esta->id);
                      
                    }
                    elseif(is_null($estado))
                    {
                        return $query->where('estatus','!=',$estad->id)
                                    ->where('estatus','!=',$esta->id);
                    }
                    else
                    {
                         
                        return $query->where('estatus',$estado); 
                    }
                       
                })
                ->when($fecha1, function ($query) use ($fecha1,$fecha2) {
                    
                    if(is_null($fecha2))
                    {
                         return $query->where('accounts_receivables.created_at','>=',$fecha1);
                    }
                    else
                    {
                        
                        
                            $fechatreinta = strtotime ( '+1 days' , strtotime ($fecha2));
                            $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                            return $query->whereBetween('accounts_receivables.created_at',[$fecha1,$fechatreinta]);
                        
                       
                    }
                   
                })
                ->when($fecha2, function ($query) use ($fecha1,$fecha2) {
                    
                    if(is_null($fecha1))
                    {   
                        $fechat = strtotime ( '+1 days' , strtotime ($fecha2));
                        $fechat  = date ( 'Y-m-d' , $fechat );
                        return $query->where('accounts_receivables.created_at','<=',$fechat);
                    }
                   
                })
                ->when($filtro3, function ($query) use ($filtro3) {
                    if($filtro3 == 1)
                    {
                       
                        return $query->groupBy('name_street');   
                    }
                    elseif($filtro3 == 2)
                    {
                        return $query->groupBy('residence');
                    }
                    elseif($filtro3 == 3)
                    {
                        
                        return $query->groupBy('category');
                    }
                    elseif($filtro3 == 4)
                    {
                        
                        return $query->groupBy('estatus');
                    }
                })
                ->get();


            

            $z = count($suma3);
                 
      
            if(is_null($filtro3))
            {
                $filtro3=8;
            }

            $historico = AccountReceivable::join('months','accounts_receivables.month','=','months.id')
                ->join('income_categories','category','=','income_categories.id')
                ->join('streets','streets.id','=','residence')
                ->join('status','estatus','=','status.id')
                ->when($filtro3, function ($query) use ($filtro3,$street,$categoria,$estado,$fecha1,$fecha2) {
                    if($filtro3 == 1)
                    {
                        $calle = "";
                        $cat = "";
                        $est = "";
                        $date1 = "";
                        $date2 = "";

                        if(!is_null($street))
                        {
                            $calle = "AND residence =".$street."";
                                                        
                        }
                        if(!is_null($categoria))
                        {
                            $cat = "AND category = ".$categoria."";
                        }
                        if(!is_null($estado))
                        {
                            if($estado == " ")
                            {
                                
                            }
                            else
                            {
                                $est = "AND estatus = ".$estado."";
                                                    
                            }
                                                        
                        }
                        if(!is_null($fecha1))
                        {
                            if(is_null($fecha2))
                            {
                                $date1 = "AND accounts_receivables.created_at >= ".$fecha1."";
                            }
                            else
                            {

                                $fechatreinta = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                                $date1 = "AND (accounts_receivables.created_at >= '".$fecha1."' AND accounts_receivables.created_at <= '".$fechatreinta."')";
                                //$date1 = "AND DATE_FORMAT('accounts_receivables.created_at', '%Y-%m-%d') BETWEEN ".$fecha1." AND ".$fechatreinta."";
                           
                            }
                                                        
                        }
                        if(!is_null($fecha2))
                        {
                            if(is_null($fecha1))
                            {
                                $fechat = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechat  = date ( 'Y-m-d' , $fechat );
                                $date2 = "AND accounts_receivables.created_at <= '".$fecha2."'";
                                                        
                            }
                        }

                       
                        return $query->leftjoin(DB::raw('(select SUM(to_pay) as pagos, SUM(debt) as deudas,residence,name_street,accounts_receivables.created_at FROM accounts_receivables JOIN streets ON streets.id = residence WHERE (estatus = "8" OR estatus = "9") '.$calle.' '.$cat.' '.$est.' '.$date1.' '.$date2.' GROUP BY streets.name_street ORDER BY name_street ASC) as deudas'), 'streets.name_street','=','deudas.name_street')
                                    ->select('pagos','accounts_receivables.debt','deudas','accounts_receivables.to_pay','category_name','month_year_text','initial_debt','accounts_receivables.id as account_id','streets.name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','accounts_receivables.residence', 'category','estatus','status_name','status.name as stname','income_categories.name as catname','reason');
     
                    }
                    elseif($filtro3 == 2)
                    {
                        $calle = "";
                        $cat = "";
                        $est = "";
                        $date1 = "";
                        $date2 = "";
                        
                        if(!is_null($street))
                        {
                            $calle = "AND residence =".$street."";
                                                        
                        }
                        if(!is_null($categoria))
                        {
                            $cat = "AND category = ".$categoria."";
                        }
                        if(!is_null($estado))
                        {
                            if($estado == " ")
                            {
                                
                            }
                            else
                            {
                                $est = "AND estatus = ".$estado."";
                                                    
                            }
                                                        
                        }
                        if(!is_null($fecha1))
                        {
                            if(is_null($fecha2))
                            {
                                $date1 = "AND accounts_receivables.created_at >= ".$fecha1."";
                            }
                            else
                            {

                                $fechatreinta = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                                $date1 = "AND (accounts_receivables.created_at >= '".$fecha1."' AND accounts_receivables.created_at <= '".$fechatreinta."')";
                           
                            }
                                                        
                        }
                        if(!is_null($fecha2))
                        {
                            if(is_null($fecha1))
                            {
                                $fechat = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechat  = date ( 'Y-m-d' , $fechat );
                                $date2 = "AND accounts_receivables.created_at <= ".$fechat."";
                                                        
                            }
                        }
                       
                        return $query->leftjoin(DB::raw('(select SUM(to_pay) as pagos, SUM(debt) as deudas,residence FROM accounts_receivables WHERE (estatus = "8" OR estatus = "9") '.$calle.' '.$cat.' '.$est.' '.$date1.' '.$date2.' GROUP BY residence ORDER BY residence ASC) as deudas'), 'accounts_receivables.residence','=','deudas.residence')
                                    ->select('deudas','accounts_receivables.debt','pagos','accounts_receivables.to_pay','category_name','month_year_text','initial_debt','accounts_receivables.id as account_id','name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','accounts_receivables.residence', 'category','estatus','status_name','status.name as stname','income_categories.name as catname','reason');
                    }
                    elseif($filtro3 == 3)
                    {
                        $calle = "";
                        $cat = "";
                        $est = "";
                        $date1 = "";
                        $date2 = "";
                        
                        if(!is_null($street))
                        {
                            $calle = "AND residence =".$street."";
                                                        
                        }
                        if(!is_null($categoria))
                        {
                            $cat = "AND category = ".$categoria."";
                        }
                        if(!is_null($estado))
                        {
                            if($estado == " ")
                            {
                                
                            }
                            else
                            {
                                $est = "AND estatus = ".$estado."";
                                                    
                            }
                                                        
                        }
                        if(!is_null($fecha1))
                        {
                            if(is_null($fecha2))
                            {
                                $date1 = "AND accounts_receivables.created_at >= ".$fecha1."";
                            }
                            else
                            {

                                $fechatreinta = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                                $date1 = "AND (accounts_receivables.created_at >= '".$fecha1."' AND accounts_receivables.created_at <= '".$fechatreinta."')";
                           
                            }
                                                        
                        }
                        if(!is_null($fecha2))
                        {
                            if(is_null($fecha1))
                            {
                                $fechat = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechat  = date ( 'Y-m-d' , $fechat );
                                $date2 = "AND accounts_receivables.created_at <= '".$fechat."'";
                                                        
                            }
                        }
                        return $query->leftjoin(DB::raw('(select SUM(to_pay) as pagos, SUM(debt) as deudas,residence,category FROM accounts_receivables WHERE (estatus = "8" OR estatus = "9") '.$calle.' '.$cat.' '.$est.' '.$date1.' '.$date2.' GROUP BY category ORDER BY category ASC) as deudas'), 'accounts_receivables.category','=','deudas.category')
                            ->select('deudas','accounts_receivables.debt','pagos','accounts_receivables.to_pay','category_name','month_year_text','initial_debt','accounts_receivables.id as account_id','name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','accounts_receivables.residence', 'accounts_receivables.category','estatus','status_name','status.name as stname','income_categories.name as catname','reason');
                    }   
                    elseif($filtro3 == 4)
                    {
                        $calle = "";
                        $cat = "";
                        $est = "";
                        $date1 = "";
                        $date2 = "";
                        
                        if(!is_null($street))
                        {
                            $calle = "AND residence =".$street."";
                                                        
                        }
                        if(!is_null($categoria))
                        {
                            $cat = "AND category = ".$categoria."";
                        }
                        if(!is_null($estado))
                        {
                            if($estado == " ")
                            {
                                
                            }
                            else
                            {
                                $est = "AND estatus = ".$estado."";
                                                    
                            }
                                                        
                        }
                        if(!is_null($fecha1))
                        {
                            if(is_null($fecha2))
                            {
                                $date1 = "AND accounts_receivables.created_at >= '".$fecha1."'";
                            }
                            else
                            {

                                $fechatreinta = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                                $date1 = "AND (accounts_receivables.created_at >= '".$fecha1."' AND accounts_receivables.created_at <= '".$fechatreinta."')";
                           
                            }
                                                        
                        }
                        if(!is_null($fecha2))
                        {
                            if(is_null($fecha1))
                            {
                                $fechat = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechat  = date ( 'Y-m-d' , $fechat );
                                $date2 = "AND accounts_receivables.created_at <= '".$fechat."'";
                                                        
                            }
                        }
                        return $query->leftjoin(DB::raw('(select SUM(to_pay) as pagos, SUM(debt) as deudas,residence,estatus FROM accounts_receivables WHERE (estatus = "8" OR estatus = "9") '.$calle.' '.$cat.' '.$est.' '.$date1.' '.$date2.' GROUP BY estatus ORDER BY residence ASC) as deudas'), 'accounts_receivables.estatus','=','deudas.estatus')
                        ->select('deudas','pagos','accounts_receivables.debt','accounts_receivables.to_pay','category_name','month_year_text','initial_debt','accounts_receivables.id as account_id','name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','accounts_receivables.residence', 'category','accounts_receivables.estatus','status_name','status.name as stname','income_categories.name as catname','reason');
                    }
                    else
                    {
                        $calle = "";
                        $cat = "";
                        $est = "";
                        $date1 = "";
                        $date2 = "";
                        if(!is_null($street))
                        {
                            $calle = "AND residence =".$street."";
                                                        
                        }
                        if(!is_null($categoria))
                        {
                            $cat = "AND category = ".$categoria."";
                        }
                        if(!is_null($estado))
                        {
                            if($estado == " ")
                            {
                                
                            }
                            else
                            {
                                $est = "AND estatus = ".$estado."";
                                                    
                            }
                                                        
                        }
                        if(!is_null($fecha1))
                        {
                            if(is_null($fecha2))
                            {
                                $date1 = "AND accounts_receivables.created_at >= '".$fecha1."'";
                            }
                            else
                            {

                                $fechatreinta = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                                $date1 = "AND (accounts_receivables.created_at >= '".$fecha1."' AND accounts_receivables.created_at <= '".$fechatreinta."')";
                           
                            }
                                                        
                        }
                        if(!is_null($fecha2))
                        {
                            if(is_null($fecha1))
                            {
                                $fechat = strtotime ( '+1 days' , strtotime ($fecha2));
                                $fechat  = date ( 'Y-m-d' , $fechat );
                                $date2 = "AND accounts_receivables.created_at <= '".$fechat."'";
                                                        
                            }
                        }
                        
                        return $query->leftjoin(DB::raw('(select SUM(to_pay) as pagos, SUM(debt) as deudas,residence FROM accounts_receivables WHERE (estatus = "8" OR estatus = "9") '.$calle.' '.$cat.' '.$est.' '.$date1.' '.$date2.' ORDER BY residence ASC) as deudas'), 'accounts_receivables.residence','=','deudas.residence')
                            ->select('deudas','accounts_receivables.debt','pagos','accounts_receivables.to_pay','category_name','month_year_text','initial_debt','accounts_receivables.id as account_id','name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','accounts_receivables.residence', 'category','estatus','status_name','status.name as stname','income_categories.name as catname','reason');
                    }
                })
                ->withTrashed()
                ->when($street, function ($query) use ($street) {
                    return $query->where('accounts_receivables.residence',$street);
                })
                ->when($categoria, function ($query) use ($categoria) {
                    return $query->where('category',$categoria);
                })
                ->when($estado, function ($query) use ($estado) {
                    
                    if($estado == " ")
                    {
                       
                    }
                    else
                    {
                        return $query->where('estatus',$estado);
                    }
                        
                })
                ->when($fecha1, function ($query) use ($fecha1,$fecha2) {
                    
                    if(is_null($fecha2))
                    {
                         return $query->where('accounts_receivables.created_at','>=',$fecha1);
                    }
                    else
                    {
                        
                        $fechatreinta = strtotime ( '+1 days' , strtotime ($fecha2));
                        $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                        return $query->whereBetween('accounts_receivables.created_at',[$fecha1,$fechatreinta]);
                        
                    }
                   
                })
                ->when($fecha2, function ($query) use ($fecha1,$fecha2) {
                    
                    if(is_null($fecha1))
                    {
                        $fechat = strtotime ( '+1 days' , strtotime ($fecha2));
                        $fechat  = date ( 'Y-m-d' , $fechat );
                        return $query->where('accounts_receivables.created_at','<=',$fechat);
                    }
                   
                })
                ->when($filtro3, function ($query) use ($filtro3) {
                    if($filtro3 == 1)
                    {
                        return $query->orderBy('name_street','ASC'); 
                    }
                    elseif($filtro3 == 2)
                    {
                        
                    }
                    elseif($filtro3 == 3)
                    {
                        return $query->orderBy('category','ASC');
                    }
                    elseif($filtro3 == 4)
                    {
                        return $query->orderBy('estatus','ASC');
                    }
                })
                ->where('debt','!=',0)
                ->orderBy('residence','ASC')
                ->orderBy('accounts_receivables.month','ASC')
                ->get();
            if($historico->isEmpty())
            {
                $historico = "";
            }

            //dd($historico);
           
            $ii = count($historico);

            if($z != $ii)
            {

            }
             
            $incomecategory = IncomeCategory::all();
            $estatus = Status::where('name','pagado')->orwhere('name','activo')->orwhere('name','cancelado')->orwhere('name','incobrable')->orderby('name')->get();
           
            $b = -2;
            $c = -2;
            $d = -2;
            $e = 0;
            $f = 0;
            $g = 0;

            $j = 0;
            

           
            $agrupar1 = 0;
            $agrupar = 0;
            $agrupar3 = 0;
            if($filtro1 == 1)
            {
                $agrupar1= 1;
                $h = 1;     
            }
            elseif($filtro1 == 2)
            {
                $agrupar1 = 2;
                $h = 1;
            }
            elseif($filtro1 == 3)
            {
                $agrupar1 = 3;
                $h = 1;
            }
            elseif($filtro1 == 5)
            {
                
                $h = 1;
            }
            if($filtro2 == 1)
            {
                $agrupar = 1;
                $h = 2;     
            }
            elseif($filtro2 == 2)
            {
                $agrupar = 2;
                $h = 2;
            }
            elseif($filtro2 == 3)
            {
                $agrupar = 3;
                $h = 2;
            }
            elseif($filtro2 == 6)
            {
                
                $h = 2;
            }
            
            if($filtro3 == 1)
            {
                $agrupar3 = 1;
                $h = 3;    
            }
            elseif($filtro3 == 2)
            {
                $agrupar3 = 2;
                $h = 3; 
            }
            elseif($filtro3 == 3)
            {
                $agrupar3 = 3;
                $h = 3; 
            }
            elseif($filtro3 == 4)
            {
                $agrupar3 = 4;
                $h = 3; 
            }
            elseif($filtro3 == 7)
            {
                
                $h = 3; 
            }

            if(!is_null($street))
            {
                $street = Street::findOrfail($street);
                $h = 3;
            }
            if(!is_null($categoria))
            {
                
                $h = 3;
            }
           
            if(!is_null($fecha1))
            {
                
                $h = 3;
            }
            if(!is_null($fecha2))
            {
                
                $h = 3;
            }

            
            $a = 0;
          
            $sumatoria = 0;
            return view('accountstopay.admin.index',compact('i','ii','iii','d','e','h','c','f','b','g','j','incomecategory','estatus','vencida','corriente','historico','suma','agrupar','suma3','agrupar3','street','categoria','estado','fecha1','fecha2','agrupar1','suma1','a','z','sumatoria'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
       //dd($request->all());
       try{

            DB::beginTransaction();

            $cuenta = AccountReceivable::findOrfail($id);
            $status = Status::where('name','incobrable')->first();

            if(is_null($request->reason)){ $reason = null; }else{ $reason = $request->reason;}
           
            if($cuenta->debt == $cuenta->to_pay)
            {
                $cuenta->update([

                    'estatus' => $status->id,
                    'reason'  => $reason,
                ]);
            }
            else
            {
                $errors = ['errorcondonar' => 'No se puede condonar la deuda porque ya tiene un pago parcial.'];
                return redirect()->back()
                    ->withErrors($errors)
                    ->withInput();
            }

            

            DB::commit();

            //if(is_null($request->numbercondonar)){ $streetnumber = " "; }else{ $streetnumber = $request->numbercondonar;}
            if(is_null($request->residencecondonar)){ $streetnumber = " "; }else{ $streetnumber = $request->residencecondonar;}
            if(is_null($request->categorycondonar)){ $category = " "; }else{ $category = $request->categorycondonar;}
            if(is_null($request->estatuscondonar)){ $estatus = " "; }else{ $estatus = $request->estatuscondonar;}
            if(is_null($request->fecha1condonar)){ $fecha1 = " "; }else{ $fecha1 = $request->fecha1condonar;}
            if(is_null($request->fecha2condonar)){ $fecha2 = " "; }else{ $fecha2 = $request->fecha2condonar;}
            if(is_null($request->filtrocondonar)){ $filter3 = 7; }else{ $filter3 = $request->filtrocondonar;}

            return redirect()->action('AccountToPayAdminController@index', ['streetnumber' => $streetnumber,'category' => $category ,'estatus' => $estatus ,'fecha1' => $fecha1,'fecha2' => $fecha2,'filter3' => $filter3 ]);

        } catch (\Illuminate\Database\QueryException $e) {
               
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors)
                ->withInput();
                  //throw $e;
      
        } catch (\Exception $e) {
          
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors)
                ->withInput();  
                  //throw $e;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
