<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Payment;
use Auth;
use App\AccountReceivable;
use App\IncomeCategory;
use App\Status;
use Carbon\Carbon;
use DB;

class AccountToPayController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $user = Auth::user();
   
        if($user->can('create', \App\IncomeResident::class))
        {
            $h = 0;
            $activo = Status::where('name','activo')->first();
            $date = Carbon::now();
            
            $total = AccountReceivable::select(DB::raw('SUM(to_pay) as pay'))
                ->where('residence',Auth::user()->street_id)
                ->where('accounts_receivables.estatus',$activo->id)
                ->get();

            $suma1 = AccountReceivable::join('months','accounts_receivables.month','=','months.id')
                ->join('income_categories','category','=','income_categories.id')
                ->join('streets','streets.id','=','residence')
                ->select(DB::raw('SUM(to_pay) as pay'),DB::raw('SUM(debt) as deuda'))
                ->where('residence',Auth::user()->street_id)
                ->where('to_pay','!=',0)
                ->where('accounts_receivables.estatus',$activo->id)
                ->where('deadline','<',$date->toDateString())
                ->orderBy('accounts_receivables.created_at','ASC')
                ->get();

            $vencida = AccountReceivable::join('months','accounts_receivables.month','=','months.id')
                ->join('income_categories','category','=','income_categories.id')
                ->join('streets','streets.id','=','residence')
                ->select('debt','to_pay','category_name','month_year_text','initial_debt','accounts_receivables.id as account_id','name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','residence', 'category')
                ->where('residence',Auth::user()->street_id)
                ->where('to_pay','!=',0)
                ->where('accounts_receivables.estatus',$activo->id)
                ->where('deadline','<',$date->toDateString())
                ->orderBy('accounts_receivables.created_at','ASC')
                ->get();
            if($vencida->isEmpty())
            {
                $vencida = "";
            }

            $suma2 = AccountReceivable::join('income_categories','category','=','income_categories.id')
                ->join('streets','streets.id','=','residence')
                ->select(DB::raw('SUM(to_pay) as pay'),DB::raw('SUM(debt) as deuda'))
                ->where('accounts_receivables.residence',Auth::user()->street_id)
                ->where('to_pay','!=',0)
                ->where('accounts_receivables.estatus',$activo->id)
                ->whereDate('deadline','>=',$date->toDateString())
                ->orderBy('accounts_receivables.created_at','ASC')
                ->get();

            $corriente = AccountReceivable::join('income_categories','category','=','income_categories.id')
                ->join('streets','streets.id','=','residence')
                ->select('debt','to_pay','category_name','initial_debt','accounts_receivables.id as account_id','name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','residence','category')
                ->where('accounts_receivables.residence',Auth::user()->street_id)
                ->where('to_pay','!=',0)
                ->where('accounts_receivables.estatus',$activo->id)
                ->whereDate('deadline','>=',$date->toDateString())
                ->orderBy('accounts_receivables.created_at','ASC')
                ->get();
            if($corriente->isEmpty())
            {
                $corriente = "";
            }
    
            $categoria = $request->input('category');
            $estado = $request->input('estatus');
            $fecha1 = $request->input('fecha1');
            $fecha2 = $request->input('fecha2');
            
            
            if(!is_null($estado))
            {
                
                $h = 1;
            }
            if(is_null($categoria) && is_null($estado) && is_null($fecha1) && is_null($fecha2))
            {
                $ss = Status::where('name','activo')->first();
                $estado = $ss->id;
                $h = 0;
            }
            if($estado == 100)
            {
                $estado = " ";
                $h = 1;
            }

            $suma3 = AccountReceivable::join('months','accounts_receivables.month','=','months.id')
                ->join('income_categories','category','=','income_categories.id')
                ->join('streets','streets.id','=','residence')
                ->join('status','status.id','=','estatus')
                ->withTrashed()
                ->select(DB::raw('SUM(to_pay) as pay'),DB::raw('SUM(debt) as deuda'))
                ->where('residence',Auth::user()->street_id)
                ->when($categoria, function ($query) use ($categoria) {
                    return $query->where('category',$categoria);
                })
                ->when($estado, function ($query) use ($estado) {
                    
                    $esta = Status::where('name','cancelado')->first();
                    $esta2 = Status::where('name','incobrable')->first();
                    
                    if($estado == " ")
                    {
                        return $query->where('estatus','!=',$esta->id)
                                    ->where('estatus','!=',$esta2->id);
                    }
                    else
                    {
                        return $query->where('estatus',$estado);
                    }
                        
                           
                       
                })
                ->when($fecha1, function ($query) use ($fecha1,$fecha2) {
                    
                    if(is_null($fecha2))
                    {
                         return $query->where('accounts_receivables.created_at','>=',$fecha1);
                    }
                    else
                    {
                            $fechatreinta = strtotime ( '+1 days' , strtotime ($fecha2));
                            $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                            return $query->whereBetween('accounts_receivables.created_at',[$fecha1,$fechatreinta]);
                    }
                   
                })
                ->when($fecha2, function ($query) use ($fecha1,$fecha2) {
                    
                    if(is_null($fecha1))
                    {   
                        $fechat = strtotime ( '+1 days' , strtotime ($fecha2));
                        $fechat  = date ( 'Y-m-d' , $fechat );
                        return $query->where('accounts_receivables.created_at','<=',$fechat);
                    }
                   
                })
                ->orderBy('accounts_receivables.created_at','ASC')
                ->get();

                


            $historico = AccountReceivable::join('months','accounts_receivables.month','=','months.id')
                ->join('income_categories','category','=','income_categories.id')
                ->join('streets','streets.id','=','residence')
                ->join('status','status.id','=','estatus')
                ->withTrashed()
                ->select('debt','to_pay','category_name','initial_debt','accounts_receivables.id as account_id','name_street','number','accounts_receivables.description as descrip','deadline','accounts_receivables.created_at','residence','category','status_name')
                ->where('residence',Auth::user()->street_id)
                ->where('debt','!=',0)
                ->when($categoria, function ($query) use ($categoria) {
                    return $query->where('category',$categoria);
                })
                ->when($estado, function ($query) use ($estado) {

                    if($estado == " ")
                    {
                        
                    }
                    else
                    {
                        return $query->where('estatus',$estado);  
                    }
                })
                ->when($fecha1, function ($query) use ($fecha1,$fecha2) {
                    
                    if(is_null($fecha2))
                    {
                         return $query->where('accounts_receivables.created_at','>=',$fecha1);
                    }
                    else
                    {

                        $fechatreinta = strtotime ( '+1 days' , strtotime ($fecha2));
                        $fechatreinta  = date ( 'Y-m-d' , $fechatreinta );
                        return $query->whereBetween('accounts_receivables.created_at',[$fecha1,$fechatreinta]);

                    }
                   
                })
                ->when($fecha2, function ($query) use ($fecha1,$fecha2) {
                    
                    if(is_null($fecha1))
                    {   
                        $fechat = strtotime ( '+1 days' , strtotime ($fecha2));
                        $fechat  = date ( 'Y-m-d' , $fechat );
                        return $query->where('accounts_receivables.created_at','<=',$fechat);
                    }
                   
                })
                ->orderBy('accounts_receivables.created_at','ASC')
                ->get();

            if($historico->isEmpty())
            {
                $historico = "";
            }

            
            if(!is_null($categoria))
            {
                
                $h = 1;
            }
           
            if(!is_null($fecha1))
            {
                
                $h = 1;
            }
            if(!is_null($fecha2))
            {
                
                $h = 1;
            }
            
           


            $incomecategory = IncomeCategory::all();
            $estatus = Status::where('name','pagado')->orwhere('name','activo')->orwhere('name','cancelado')->orwhere('name','incobrable')->orderby('name')->get();
           
                



            return view('accountstopay.index',compact('vencida','corriente','suma1','suma2','total','incomecategory','estatus','categoria','estado','fecha1','fecha2','historico','h','suma3'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
