<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Employe;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use App\AccessColony;
use App\AccessType;
use App\Visit;
use App\Guest;
use Validator;


class AddPhotoEmployeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request->all());
        try{

            $messages = [

                'mimes'         => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                'max'           => 'el archivo no debe pesar mas de 5 mb.',
                'uploaded'      => 'El archivo no debe pesar mas de 5 mb.',
                'required'      => 'Este campo es requerido.',
            ];

            $rules = [
                'file'          => 'max:5000|mimes:jpeg,jpg,png|required', //5000kb image/jpeg image/png

              
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
             
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {
        
                $fileInput= Input::file('file');
                $invitado = AccessType::where('name',"invitado")->first();
                $visitante = AccessType::where('name',"visitante")->first();
                $empleado = AccessType::where('name',"empleado")->first();


                if (Input::hasFile('file'))
                {
                    $fileInput= Input::file('file');
                    $fileType = $fileInput->getMimeType();
                    $clave = str_random(5);

                    if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                    { 
                                  
                        

                        if($fileType == "image/jpeg")
                        {
                            $type = "jpg";
                        }
                        else if($fileType == "application/pdf")
                        {
                            $type = "pdf";
                        }
                        else if($fileType == "image/png")
                        {
                            $type = "png";
                        }


                            if($request->imageData)
                            {

                                $data = base64_decode($request->imageData);
                                $im = imagecreatefromstring($data);

                                if ($im !== false) 
                                {
                                    


                                    if($request->tipovisita == 1)
                                    {
                                                
                                        $access = AccessColony::findOrfail($request->id);
                                        
                                        if($access->type == $invitado->id)
                                        {
                                            $guest = Guest::findOrfail($access->guest_id);
                                            $name_imagen = $guest->id.".".$type;
                                            $url = '/uploads/photos/guest/';
                                            $path = public_path().$url.$name_imagen;
                                            $peso = $request->sizeData*1024;
                                            $guest->update([

                                                'file_name'     => $name_imagen,
                                                'url_file'      => $url.$name_imagen,
                                                'file_size'     => $peso,
                                                'file_type'     => $request->contentType,

                                            ]);
                                        }
                                        else if($access->type == $visitante->id)
                                        {
                                            $visit = Visit::findOrfail($access->visit_id);
                                            $name_imagen = $visit->id.".".$type;
                                            $url = '/uploads/photos/visit/';
                                            $path = public_path().$url.$name_imagen;
                                            $peso = $request->sizeData*1024;
                                            $visit->update([

                                                'file_name'     => $name_imagen,
                                                'url_file'      => $url.$name_imagen,
                                                'file_size'     => $peso,
                                                'file_type'     => $request->contentType,

                                            ]);
                                        }
                                        else if($access->type == $empleado->id)
                                        {

                                            $employe = Employe::findOrfail($access->employe_id);
                                            $name_imagen = $employe->id.".".$type;
                                            $url = '/uploads/photos/employes/';
                                            $path = public_path().$url.$name_imagen;
                                            $peso = $request->sizeData*1024;
                                            $employe->update([

                                                'file_name'     => $name_imagen,
                                                'url_file'      => $url.$name_imagen,
                                                'file_size'     => $peso,
                                                'file_type'     => $request->contentType,

                                            ]);
                                        }
                                                
                                    }
                                    else if($request->tipovisita == 2)
                                    {
                                        $visit = Visit::findOrfail($request->id);
                                        $name_imagen = $visit->id.".".$type;
                                        $url = '/uploads/photos/visit/';
                                        $path = public_path().$url.$name_imagen;
                                        $peso = $request->sizeData*1024;
                                        $visit->update([

                                            'file_name'     => $name_imagen,
                                            'url_file'      => $url.$name_imagen,
                                            'file_size'     => $peso,
                                            'file_type'     => $request->contentType,

                                        ]);

                                    }
                                    else if($request->tipovisita == 3)
                                    {
                                                
                                        $employe = Employe::findOrfail($request->id);
                                        $name_imagen = $employe->id.".".$type;
                                        $url = '/uploads/photos/employes/';
                                        $path = public_path().$url.$name_imagen;
                                        $peso = $request->sizeData*1024;

                                        $employe->update([

                                            'file_name'     => $name_imagen,
                                            'url_file'      => $url.$name_imagen,
                                            'file_size'     => $peso,
                                            'file_type'     => $request->contentType,

                                        ]);
                                    }

                                    header('Content-Type: ',$request->contentData);
                                    imagejpeg($im, $path);

                                    imagedestroy($im);
                                }
                                else 
                                {
                                    $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                        return redirect()->back()
                                        ->withErrors($errors);
                                }
                            }
                            else 
                            {
                                $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                    return redirect()->back()
                                     ->withErrors($errors);
                            }
                        


                    }
                           
                   
                }

                if(!empty($request->backevento))
                {

                    $backsearchevent = $request->backevento;
                    return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $backsearchevent]);
                }
                elseif($request->qrback)
                {
                    return redirect()->action('ReadQRController@create', ['data' => $request->qrback]);
                    
                }
                else
                {
                    $street = $request->back;
                    return redirect()->action('DashboardGuardController@index', ['street' => $street]);
                }
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
              
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
              
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
