<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\AccessColony;
use Response;


class ApiVigilanteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $date = Carbon::now();

        $access = AccessColony::join('access_types','access_types.id','=','type')
            ->leftjoin('employes', 'employe_id','=','employes.id')
            ->leftjoin('employes_categories','category','=','employes_categories.id')
            ->leftjoin('reservations','event_id','=','reservations.id')
            ->leftjoin('social_areas','social_area','=','social_areas.id')
            ->leftjoin('visits','visits.id','=','visit_id')
            ->leftjoin('guest','guest.id','=','guest_id')
            ->where('access_colonies.id',$request->id)
            ->where('access_colonies.date',$date->toDateString())
            ->whereNull('check_out')
            ->get(['employes.name as names','visits.name as namev','guest.name_guest as nameg','name_type','check_in','check_out','access_colonies.id','name_category','access_types.name as namest','access_colonies.residence_id','employes.url_file as eurl_file','visits.url_file as vurl_file','guest.url_file as gurl_file','employes.id as employeid ','social_areas.name_social_area']);

        $data = collect(json_decode($access));
        
        
        /*foreach ($access as $ac) {
            
           
            $data = '{"namev":"'.$ac->namev.'","id":"'.$ac->id.'","residence_id":"'.$ac->residence_id.'"}';
        }*/
        //return Response::json($access);


        return $data;
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
        
            $fecha = Carbon::now();

            $access = AccessColony::findOrfail($request->id);
            
            $access->update([
                'check_in' => $fecha,
            ]);

            if($request->backsearchevent)
            {
                $backsearchevent = $request->backsearchevent;
                return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $backsearchevent]);
            }
            else
            {
              $street = $request->backsearch;
              return redirect()->action('DashboardGuardController@index', ['street' => $street]);
            }
        
        } catch (\Illuminate\Database\QueryException $e) {
             
           $error = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($error);
                
        } catch (\Exception $e) {
        
            $error = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($error);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $date = Carbon::now();

        $access = AccessColony::join('access_types','access_types.id','=','type')
            ->leftjoin('employes', 'employe_id','=','employes.id')
            ->leftjoin('employes_categories','category','=','employes_categories.id')
            ->leftjoin('reservations','event_id','=','reservations.id')
            ->leftjoin('social_areas','social_area','=','social_areas.id')
            ->leftjoin('visits','visits.id','=','visit_id')
            ->leftjoin('guest','guest.id','=','guest_id')
            ->where('access_colonies.residence_id',$id)
            ->where('access_colonies.date',$date->toDateString())
            ->whereNull('check_out')
            ->get(['employes.name as names','visits.name as namev','guest.name_guest as nameg','name_type','check_in','check_out','access_colonies.id','name_category','access_types.name as namest','access_colonies.residence_id','employes.url_file as eurl_file','visits.url_file as vurl_file','guest.url_file as gurl_file','employes.id as employeid','social_areas.name_social_area']);

        return $access;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
