<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use Validator;
use Auth;
use Session;
use Hash;

class ChangePasswordResController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try{
                $user = Auth::user();
              
                /*if($user->can('updatePassword', $user))
                {*/ $messages = [

                        'required' => 'Este campo es requerido.',
                        'confirmed' => 'No coincide el campo confirmar constraseña',
                        'min'       => 'La contraseña debe tener mínimo 6 caracteres.'
                       
                    ];


                    $validator = Validator::make($request->all(), [
                        'actual_password' => 'required',
                        'password' => 'required|min:6|confirmed',
                   
                    ],$messages);

                    if ($validator->fails()) 
                    {
                        return redirect()->back()
                            ->withErrors($validator)
                            ->withInput();
                    }
                    else
                    {
                       
                        //$users = User::findOrfail($id);
                        if (Hash::check($request->actual_password, $user->password))
                        {
                            $user->update([

                                'password' => bcrypt($request->password),

                            ]);


                                $mensaje = 'Se ha cambiado la contraseña con éxito.';
                                Session::flash('message', $mensaje );
                                return redirect('configuration/perfil_config');
                            
                        }
                        else
                        {
                            $errors = ['actual_password' => 'Es incorrecta la contraseña actual'];
                            return redirect()->back()
                                    ->withErrors($errors)
                                    ->withInput();
                        }

                    }
                /*}
                else
                {
                    return redirect('/home');
                }*/

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error4' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error4' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
