<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\User;
use Validator;
use Input;
use Illuminate\Contracts\Encryption\DecryptException;
use Session;
use Hash;
class ChangePasswordVigController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //dd($request->all());
        try{
               
            $email = $request->input('email_guard');
            $actual_pass = $request->input('actual_password_guard');
            $pass = $request->input('password_guard'); 
            $user = User::findOrfail(2);
            
            if($email && (!$actual_pass && !$pass))
            {
                if($email != $user->email)
                {

                    $messages = [

                        'unique'    => 'El correo electrónico ya esta registrado.',
                        'email'     => 'Debe ser un correo electrónico válido.',
                    ];

                    $rules = [

                        'email_guard'    => 'unique:users,email|email', 
                    ];

                    $validator = Validator::make($request->all(),$rules,$messages);

                    if ($validator->fails()) 
                    {
                        return redirect()->back()
                            ->withErrors($validator)
                            ->withInput();
                    }
                    else
                    {
                        $user->update([
                            'email' => $request->email_guard,
                        ]);

                        $mensaje = 'Se ha cambiado el correo electrónico con éxito.';
                        Session::flash('message', $mensaje );
                    }
                }
                else
                {
                    $errors = ['email_guard' => 'Correo electrónico actualmente en uso.'];
                    return redirect()->action('ConfigMasterController@index',['c' => 1])->withErrors($errors);
                }
            }
            elseif(($actual_pass || $pass) && !$email) 
            {
                $messages = [

                    'required' => 'Este campo es requerido.',
                    'confirmed' => 'No coincide el campo confirmar constraseña.',
                    'min'       => 'La contraseña debe tener mínimo 6 caracteres.'
                               
                ];


                $validator = Validator::make($request->all(), [
                    'actual_password_guard' => 'required',
                    'password_guard' => 'required|min:6|confirmed',
                           
                ],$messages);

                
                if ($validator->fails()) 
                {
                    return redirect()->action('ConfigMasterController@index',['c' => 1])
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {
                    if (Hash::check($request->actual_password_guard, $user->password))
                    {
                        $user->update([

                            'password' => bcrypt($request->password_guard),

                        ]);

                                            
                        $mensaje = 'Se ha cambiado la contraseña con éxito.';
                        Session::flash('message', $mensaje );  
                                       
                    }
                    else
                    {
                        $errors = ['actual_password_guard' => 'Es incorrecta la contraseña actual.'];
                        return redirect()->action('ConfigMasterController@index',['c' => 1])
                            ->withErrors($errors)
                            ->withInput();
                    }
                        
                }
            }
            elseif($email && ($actual_pass || $pass))
            {

                if($email != $user->email)
                {
                    $messages = [
                        'unique'    => 'El correo electrónico ya esta registrado.',
                        'email'     => 'Debe ser un correo electrónico válido.',
                        'required' => 'Este campo es requerido.',
                        'confirmed' => 'No coincide el campo confirmar constraseña.',
                        'min'       => 'La contraseña debe tener mínimo 6 caracteres.'
                    ];  

                    $rules = [

                        'email_guard'    => 'unique:users,email|email',
                        'actual_password_guard' => 'required',
                        'password_guard' => 'required|min:6|confirmed', 
                    ];
                }
                else
                {
                    $messages = [
                        'required' => 'Este campo es requerido.',
                        'confirmed' => 'No coincide el campo confirmar constraseña.',
                        'min'       => 'La contraseña debe tener mínimo 6 caracteres.'        
                    ];

                    $rules = [
                        'actual_password_guard' => 'required',
                        'password_guard' => 'required|min:6|confirmed', 
                    ];
                }

                    
                $validator = Validator::make($request->all(),$rules,$messages);

                if ($validator->fails()) 
                {
                    return redirect()->action('ConfigMasterController@index',['c' => 1])
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {
                    
                    
                    if (Hash::check($request->actual_password_guard, $user->password))
                    {
                        

                        if($email != $user->email)
                        {
                            $user->update([

                                'email' => $request->email_guard,
                                'password' => bcrypt($request->password_guard),

                            ]);

                            $mensaje = 'Se ha cambiado el correo electrónico y la contraseña con éxito.';
                            Session::flash('message', $mensaje );
                        }
                        else
                        {
                            $user->update([

                                'password' => bcrypt($request->password_guard),

                            ]);

                            $mensaje = 'Se ha cambiado la contraseña con éxito.';
                            Session::flash('message', $mensaje );
                        }  
                                       
                    }
                    else
                    {
                        $errors = ['actual_password_guard' => 'Es incorrecta la contraseña actual.'];
                        return redirect()->action('ConfigMasterController@index',['c' => 1])
                            ->withErrors($errors)
                            ->withInput();
                    }
                        
                }
            }
            else
            {
                $messages = [

                    'required' => 'Este campo es requerido.',

                ];  

                $rules = [

                    'email_guard'    => 'required',
                    'actual_password_guard' => 'required',
                    'password_guard' => 'required|min:6|confirmed', 
                ]; 

                 $validator = Validator::make($request->all(),$rules,$messages);

                if ($validator->fails()) 
                {
                    return redirect()->action('ConfigMasterController@index',['c' => 1])
                        ->withErrors($validator)
                        ->withInput();
                }
                


            }

            
        
            return redirect()->action('ConfigMasterController@index',['c' => 1]);     

                


        } catch (\Illuminate\Database\QueryException $e) {
             
           /*$errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);*/
              throw $e;
                
        } catch (\Exception $e) {
        
            /*$errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);*/
              throw $e;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
