<?php

namespace App\Http\Controllers;

use App\Colony;
use Illuminate\Http\Request;
use Auth;
use App\User;
use App\Rol;
use App\MemberColony;
use Session;
use DB;
use Validator;

class ColonyController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
        $user = Auth::user();
      
        if($user->can('index', \App\Colony::class ))
        {
            $c= Colony::all();
            if($c->isEmpty())
            {
                $colony = $c->toArray();
            }
            else
            {
                $colony = $c;
            }
            
            return view('configuration.colonies.index', compact('colony'));
        }
        else
        {
            return redirect('/home');
            
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
        if($user->can('create', \App\Colony::class ))
        {
            return view('configuration.colonies.create');
        }
        else
        {
             return redirect()->back();
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
   
        try{

            $messages = [

                'required'  => 'Este campo es requerido.',
            ];

            $rules = [

                'colony_name'           => 'required', 
                'president_colony_name' => 'required', 
            
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) 
            {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {
                
               
               
                
                

                    DB::beginTransaction();
                       
                        Colony::createColony($request);
                        
                    DB::commit();

                    return redirect()->action('ConfigMasterController@index',['i' => 1]);
                
            }

            

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors)
              ->withInput();
             
          
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors)
              ->withInput();
          
              
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Colony  $colony
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $member_colony = MemberColony::where('colony_id', $id)->get();
        return view('configuration.colonies.show', compact('member_colony'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Colony  $colony
     * @return \Illuminate\Http\Response
     */
    public function edit(Colony $colony)
    {

        try{

            $user = Auth::user();
            if($user->can('edit', $colony))
            {
                $member = $colony->colonyMember()->get();
                $a = 0;
                return view('configuration.colonies.edit', compact('colony','member','a'));
            }
            else
            {
                return redirect()->back();
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Colony  $colony
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Colony $colony)
    {

        //dd($request->all());
        try{

            $messages = [

                'required'  => 'Este campo es requerido.',
            ];

            $rules = [

                'colony_name'           => 'required', 
                'president_colony_name' => 'required', 
            
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) 
            {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {
                $user = Auth::user();

                if($user->can('update', $colony))
                {
                    
                    Colony::updateColony($request,$colony);

                    return redirect()->action('ConfigMasterController@index',['i' => 1]);
                }
                else
                {
                    return redirect()->back();
                }
            }
                
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors)
              ->withInput();
             
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors)
              ->withInput();
              
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Colony  $colony
     * @return \Illuminate\Http\Response
     */
    public function destroy(Colony $colony)
    {
        $user = Auth::user();
        
        if($user->can('delete', $colony))
        {
            /*$colony->delete();

            return redirect('configuration/colony');*/
        }
        else
        {
            return redirect()->back();
        }
    }
}
