<?php

namespace App\Http\Controllers;

use App\Config;
use Illuminate\Http\Request;
use Auth;
use Session;
use App\MonthlyContribution;
use DB;
use App\Street;

class ConfigController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $user = Auth::user();
      
        if($user->can('index', \App\Config::class))
        {
            $configuration = Config::all();
            if($configuration->isEmpty())
            {
                $config = $configuration->toArray();
            }
            else
            {
                $config = $configuration;
            }
            return view('configuration.configs.index', compact('config'));
        }
        else
        {
            return redirect()->back();
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
      
        if($user->can('create', \App\Config::class))
        {
            return view('configuration.configs.create');
        }
        else
        {
            return redirect()->back();
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Config  $config
     * @return \Illuminate\Http\Response
     */
    public function show(Config $config)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Config  $config
     * @return \Illuminate\Http\Response
     */
    public function edit(Config $config,Request $request)
    {
        $user = Auth::user();
        if($user->can('edit', $config))
        {
            if($request->tconfiguracion == 1)
            {

                if($config->multiple_contributions == 1)
                {

                    $m = MonthlyContribution::where('asign',1)->first();

                    if(is_null($m))
                    {
                        $m = MonthlyContribution::where('asign',1)->first();

                        
                        $monto = "0";
                        
                    }
                    else
                    {
                        $monto = $m->amount;
                    }
                }
                else
                {
                    $table = DB::table('monthly_contributions')->count();
                  
                    if($table > 1)
                    {
                        $m = MonthlyContribution::where('asign',1)->first();
                        $monto = $m->amount;
                    }
                    else
                    {
                        $m = MonthlyContribution::where('asign',1)->first();
                        if(is_null($m))
                        {
                            $m = MonthlyContribution::where('asign',1)->first();
                            #Se cambio $m->amount por $m['amount'] ya que generaba error al editar la configuracin general
                            $monto = $m['amount'];
                        }
                        else
                        {
                            $m= MonthlyContribution::all();
                            foreach ($m as $ms) {
                                $monto = $ms->amount;
                            }
                        }
                    }
                    
                }
                
                
                $tipo = 1;
            }
            elseif($request->tconfiguracion == 2)
            {
                
                $tipo = 2;
            }
            elseif($request->tconfiguracion == 3)
            {
                $tipo = 3;
            }
            
            return view('configuration.configs.edit', compact('config','monto','tipo'));
        }
        else
        {
            return redirect()->back();
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Config  $config
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Config $config)
    {
        
        $user = Auth::user();
        //dd($request->all());
        if($user->can('update', $config))
        {
            try{

                //// tipo 1 /////
                if($request->tipo == 1)
                {

                    // validación dias para ser moroso /////
                    if($request->days_to_be_debtor <= 0 || $request->days_to_be_debtor >= 28)
                    {
                        $errors = ['days_to_be_debtor' => 'No puede ser menor a 1 ni mayor a 28.'];
                        return redirect()->back()
                            ->withErrors($errors)
                             ->withInput();
                    }
                    
                    $time = $request->input('time_to_be_debtor');
                    $amount = $request->input('amount_charge');
                    $type_charge = $request->input('type_charge');
                    //Necesario para capturar los dias de reserva
                    $event = $request->input('events_house');

                    if($request->access_debtor){$access_debtor = 1;}else{$access_debtor = 0; }
                    if($request->show_debt){$show_debt = 1;}else{$show_debt = 0;}
                    if($request->charge_no_pay){$charge_no_pay = 1;}else{$charge_no_pay = 0; }


                    if($access_debtor == 1 && $charge_no_pay == 1)
                    {
                        if(!$time && !$amount && !$type_charge)
                        {
                            $errors = ['time_to_be_debtor' => 'Este campo es requerido.','amount_charge' => 'Este campo es requerido.','type_charge' => 'Este campo es requerido.'];
                            return redirect()->back()
                                ->withErrors($errors)
                                ->withInput();

                        }

                        if(!$amount || !$type_charge)
                        {

                            if($amount && !$type_charge)
                            {
                                $errors = ['type_charge' => 'Este campo es requerido.'];
                                return redirect()->back()
                                    ->withErrors($errors)
                                    ->withInput();
                            }
                            elseif(!$amount && $type_charge)
                            {
                                $errors = ['amount_charge' => 'Este campo es requerido.'];
                                return redirect()->back()
                                    ->withErrors($errors)
                                    ->withInput();
                            }
                            elseif(!$amount && !$type_charge)
                            {
                                
                                $errors = ['amount_charge' => 'Este campo es requerido.', 'type_charge' => 'Este campo es requerido.'];
                                return redirect()->back()
                                    ->withErrors($errors)
                                    ->withInput();
                            }
                            
                        }


                    }

                    if($access_debtor == 1)
                    {
                        if(!$time)
                        {
                            $errors = ['time_to_be_debtor' => 'Este campo es requerido.'];
                            return redirect()->back()
                                ->withErrors($errors)
                                ->withInput();
                        }
                      
                       
                    }

                    if($charge_no_pay == 1)
                    {
                        if(!$amount || !$type_charge)
                        {

                            if($amount && !$type_charge)
                            {
                                $errors = ['type_charge' => 'Este campo es requerido.'];
                                return redirect()->back()
                                    ->withErrors($errors)
                                    ->withInput();
                            }
                            elseif(!$amount && $type_charge)
                            {

                                    $errors = ['amount_charge' => 'Este campo es requerido.'];
                                    return redirect()->back()
                                        ->withErrors($errors)
                                        ->withInput();
                                
                               
                            }
                            elseif(!$amount && !$type_charge)
                            {
                                
                                $errors = ['amount_charge' => 'Este campo es requerido.', 'type_charge' => 'Este campo es requerido.'];
                                return redirect()->back()
                                    ->withErrors($errors)
                                    ->withInput();
                            }
                            
                        }
                    }

                    if($request->limit_events){$limit_events = 1;}else{$limit_events = 0; }
                    if($request->discussion_debtor){$discussion_debtor = 1;}else{$discussion_debtor = 0; }
                    if($request->multiple_contributions){$mcontribution = 1;}else{$mcontribution = 0;}

                    if($mcontribution == 0)
                    {
                        
                        $w = MonthlyContribution::where('asign', 1)->first();

                        if(is_null($w))
                        {
                            $m = MonthlyContribution::findOrfail(1);

                            $m->update([

                                'asign' => 1,

                            ]);

                        }


                        $o = MonthlyContribution::where('asign', 1)->first();

                        $street = Street::where('empty_residence',0)->get();

                        foreach ($street as $streets) 
                        {
                            $s = Street::findOrfail($streets->id);

                            $s->update([
                                'contribution' => $o->id
                            ]);
                        }


                        
                    }
            
                    $config->update([

                        'access_debtor' => $access_debtor,
                        'max_reservation_months' => $request->max_reservation_days,
                        'days_to_be_debtor' => $request->days_to_be_debtor,
                        'show_debt_resident' => $show_debt,
                        'charge_no_pay'  => $charge_no_pay,
                        'time_to_be_debtor' => $request->time_to_be_debtor,
                        'amount_charge' => $request->amount_charge,
                        'type_charge' => $request->type_charge,
                        'discussion_debtor' => $discussion_debtor,
                        'multiple_contributions' => $mcontribution,
                        'limit_events' => $limit_events,
                        'events_house' => $request->events_house,
                    ]);

                    


                    if($request->amount <= "0")
                    {
                        $errors = ['cero' => 'El monto de la aportación del mes no puede ser 0.'];
                       return redirect()->back()
                          ->withErrors($errors);
                    }
                    else
                    {
                        if($config->multiple_contributions == 0)
                        {
                            
                                $monto = MonthlyContribution::where('asign', 1)->first();
                                $monto->update([

                                    'amount' => $request->amount,
                                ]);
                            

                            
                        }
                    }

                    if($mcontribution == 1)
                    {
                        return redirect('/configuration/config/1/edit?tconfiguracion=1');
                    }
                    else
                    {
                        return redirect('/configurations');
                    }


                    

                    
                }
                elseif($request->tipo == 2)
                {
                    if($request->send_mail){$send_mail = 1;}else{$send_mail = 0; }
                    if($request->reminder_email){$reminder_email = 1;}else{$reminder_email = 0; }
                    if($request->email_cancel_reservation){$email_cancel_reservation = 1;}else{$email_cancel_reservation = 0; }
                    if($request->email_charge){$email_charge = 1;}else{$email_charge = 0; }
                    if($request->email_extraordinary_account){$email_extraordinary_account = 1;}else{$email_extraordinary_account = 0; }
                    

                    $config->update([

                        'send_mail' => $send_mail,
                        'reminder_email' => $reminder_email,
                        'email_cancel_reservation' => $email_cancel_reservation,
                        'email_charge' => $email_charge,
                        'email_extraordinary_account'  => $email_extraordinary_account,

                    ]);


                    return redirect('/configurations');
                }
                elseif($request->tipo == 3)
                {
                    if($request->guard_guest){$guard_guest = 1;}else{$guard_guest = 0; }
                    if($request->guard_visit){$guard_visit = 1;}else{$guard_visit = 0; }
                    if($request->guard_employe){$guard_employe = 1;}else{$guard_employe = 0; }

                    $config->update([

                        'guard_guest' => $guard_guest,
                        'guard_visit' => $guard_visit,
                        'guard_employe' => $guard_employe,

                    ]);

                    return redirect('/configurations');
                }

                //return redirect('/configuration/config/1/edit?tconfiguracion=1');


            } catch (\Illuminate\Database\QueryException $e) {
             
               $error5 = ['error5' => 'Ha ocurrido un error intentalo otra vez.'];
               return redirect()->back()
                  ->withErrors($error5);

               
                  
                                   
            } catch (\Exception $e) {
            
               $error5 =  ['error5' => 'Ha ocurrido un error intentalo otra vez.'];
                return redirect()->back()
                  ->withErrors($error5);

              
                 
                 
            }

        }
        else
        {
            return redirect()->back();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Config  $config
     * @return \Illuminate\Http\Response
     */
    public function destroy(Config $config)
    {
        $user = Auth::user();
        if($user->can('update', $config))
        {
            return redirect('/configurations');
        }
        else
        {
            return redirect()->back();
        }
    }
}
