<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Admin;
use Auth;
use App\GuardInfo;
use App\AccountInfo;
use App\Street;
use App\Month;
use App\Income;
use Carbon\Carbon;
use DB;
use App\User;
use Illuminate\Support\Facades\Mail;
use App\Mail\RememberPay;
use Session;
use App\Payment;
use App\Report;
use App\Popup;
use App\Status;
use App\Reservation;
use Illuminate\Session\DatabaseSessionHandler;



class DashboardAdminController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //#Pagos por aprobar
        $counts = DB::table('payments')
            ->where('status',7)
            ->count();
        if($counts > 0)
        {
            $pagos = 1;
        }
        else
        {
            $pagos = 0;
        }


        $user = Auth::user();
      
        if($user->can('index', \App\Admin::class))
        {
            
            $expensepor = Report::getExpensePerCategoryPorcentage();

            $incomenumerals = Report::getIncomeNumeral();
            $incomenumeral = number_format($incomenumerals, 2, '.', ',');
            $expensenumerals = Report::getExpenseNumeral(); 
            $expensenumeral = number_format($expensenumerals, 2, '.', ',');
            $total = $incomenumerals-$expensenumerals;
            $total1 = number_format($total, 2, '.', ',');
            $income = Report::getIncomesLastYear();
            $expensecategory = Report::getExpensePerCategory();
            $incomecategory = Report::getIncomesPerCategoryLastYear();
            $payadvanced = Report::payAdvanced();
            $a = 0.00;
            $alldebts = Report::getAllDebt();
            $alldebt = number_format($alldebts, 2, '.', ',');
            $balances = Report::getBalanceBank();
            $balance  = number_format($balances, 2, '.', ',');
            $accounttopays = Report::getAccountToPay();
            $accounttopay = number_format($accounttopays, 2, '.', ',');
            //$accounttopay = 0;
            $totals = ($alldebts+$balances)-$accounttopays;
            $total2 = number_format($totals, 2, '.', ',');

            $cartera = Report::getAllDebtResident();
            foreach ($cartera as $carteras) 
            {
                $carteravencidas = $carteras['treinta'] +$carteras['sesenta']+$carteras['mas'];
            }
          
            $carteravencida = number_format($carteravencidas, 2, '.', ',');
            $carterap = Report::getallPay();

            $incometotals = Report::getIncomesPerCategoryLastYearTotal2();
            $incometotal = number_format($incometotals, 2, '.', ',');

            $expensetotals = Report::getExpensePerCategoryLastYearTotal();
            $expensetotal = number_format($expensetotals, 2, '.', ',');

            


            $popup = Popup::all();

            $date = Carbon::now();
            
            if($popup->isEmpty())
            {
                $pop = "";
            }
            else
            {
                foreach ($popup as $popups) 
                {
                    $start = $popups->start;
                    $end = $popups->end;
                    $pop = $popups->popup_message;
                }

                if($date->toDateString() >= $start && $date->toDateString() <= $end  )
                {
                    $pop = $pop;
                }
                else
                {
                    $pop = "";
                }
            }

            //$status = Status::where('name','pendiente')->first();
            $status2 = Status::where('name','confirmar')->first();
            $reservation = Reservation::where('reservation_status', $status2->id)->get();
            if($reservation->isEmpty())
            {
                $res = 0;
            }
            else
            {
                $res = 1;
            }
            

            return view('dashboard.administrator', compact('income','a','expensecategory','incomecategory','incomenumeral','expensenumeral','total1','alldebt','balance','accounttopay','total2','cartera','carterap','carteravencida','incometotal','expensetotal','pop','expensepor','accounttopay','res','payadvanced','pagos'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $user = User::where('street_id', $request->id)->first();

        
        Mail::to('jmedellin@innovationti.com.mx')->send(new RememberPay($user));

        $mensaje = 'Se ha enviado el correo exitosamente.';
        Session::flash('message', $mensaje ); 

        return redirect()->action('DashboardAdminController@index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
