<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Employe;
use App\Guest;
use DB;
use Auth;
use Carbon\Carbon;
use App\AccessColony;
use App\Reservation;
use App\EmployeType;
use App\RecurrentEmploye;
use App\Street;
use App\Status;
use App\AccessType;
use App\EmployeCategory;
use App\SocialArea;
use App\Config;
use App\RecurrentVisit;
use Session;
class DashboardGuardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        
        //dd($request->all());
        $user = Auth::user();
        $date = Carbon::now();
        $status = Status::where('name',"cancelado")->first();
        $calle = $request->street;
        $permission = Config::all();

        $fechatodos1 = $request->input('fechatodos1');
        $fechatodos2 = $request->input('fechatodos2');

        foreach ($permission as $permissions) 
        {
          $permission_guest = $permissions->guard_guest;
          $permission_visit = $permissions->guard_visit;
          $permission_employe = $permissions->guard_employe;
        }
        
        /*$access2 = AccessColony::join('access_types','access_types.id','=','type')
            ->leftjoin('employes', 'employe_id','=','employes.id')
            ->leftjoin('employes_categories','category','=','employes_categories.id')
            ->leftjoin('reservations','event_id','=','reservations.id')
            ->leftjoin('social_areas','social_area','=','social_areas.id')
            ->leftjoin('visits','visits.id','=','visit_id')
            ->leftjoin('guest','guest.id','=','guest_id')   
            ->leftjoin('streets','streets.id','=','access_colonies.residence_id')    
            //->where('access_colonies.date',$date->toDateString())                                                 
            //->whereNull('check_out')
            ->where(function($query){
                $query->where('access_colonies.check_in','!=','null')->WhereNull('access_colonies.check_out');
            })
            ->whereNull('check_out')
            //->orwhere('access_colonies.date',$month)
            //->orwhere('access_colonies.date',Carbon::now()->subDay()->toDateString())
            ->select('employes.name as names','visits.name as namev','guest.name_guest as nameg','name_type','check_in','check_out','access_colonies.id','name_category','access_types.name as namest','access_colonies.residence_id','employes.url_file as eurl_file','visits.url_file as vurl_file','guest.url_file as gurl_file','employes.id as employeid','social_areas.name_social_area','streets.name_street as rstr', 'streets.number as rnum')
            ->paginate(15);

        $access3 = AccessColony::join('access_types','access_types.id','=','type')
            ->leftjoin('employes', 'employe_id','=','employes.id')
            ->leftjoin('employes_categories','category','=','employes_categories.id')
            ->leftjoin('reservations','event_id','=','reservations.id')
            ->leftjoin('social_areas','social_area','=','social_areas.id')
            ->leftjoin('visits','visits.id','=','visit_id')
            ->leftjoin('guest','guest.id','=','guest_id')   
            ->leftjoin('streets','streets.id','=','access_colonies.residence_id')  
            //->where('access_colonies.date',$date->toDateString())                                                 
            //->whereNull('check_out')
            ->where(function($query){
                $query->where('access_colonies.check_in','!=','null')->WhereNull('access_colonies.check_out');
            })
            ->whereNull('check_out')
            //->orwhere('access_colonies.date',$month)
            //->orwhere('access_colonies.date',Carbon::now()->subDay()->toDateString())
            ->select('employes.name as names','visits.name as namev','guest.name_guest as nameg','name_type','check_in','check_out','access_colonies.id','name_category','access_types.name as namest','access_colonies.residence_id','employes.url_file as eurl_file','visits.url_file as vurl_file','guest.url_file as gurl_file','employes.id as employeid','social_areas.name_social_area','streets.name_street as rstr', 'streets.number as rnum')
            ->count();*/
        

        if($user->can('index', \App\Guard::class))
        {
            
            
            if($request->backsearchevent)
            {
                $access = AccessColony::join('access_types','access_types.id','=','type')
                  ->join('guest', 'guest_id','=','guest.id')
                  ->where('date',$date->toDateString())
                  ->where('event_id',$request->backsearchevent)
                  ->whereNull('check_out')
                  ->get(['guest.name_guest as names','check_in','check_out','access_colonies.id','access_types.name as namest','access_colonies.residence_id','guest.url_file as gurl_file','name_type']);
                if($access->isEmpty())
                {
                    $access = "";
                } 
                
                $event = Reservation::join('social_areas','social_areas.id','=','social_area')
                  ->join('streets','streets.id','=','residence_id')
                  ->where('date',$date->toDateString())
                  ->whereNull('reservations.deleted_at')
                  ->where('reservation_status','!=',$status->id)
                  ->get(['name_social_area','name_street','number','time_start','time_end','reservations.id as rid']);
                  
                  
                if($event->isEmpty())
                {
                  $event = "";
                }
                  
                $employe = "";

                $st = "";
                $number = "";
                $mensaje = "";
                $reservas = Reservation::findOrfail($request->backsearchevent);
                $nombre_area = SocialArea::findOrfail($reservas->social_area);
                if($permission_guest == 0)
                {
                    $scalle = "";
                }
                else
                {
                    $scalle = $reservas->residence_id;
                }
                
                $backsearchevent = $request->backsearchevent;
                $access_type = AccessType::where('name','empleado')->orWhere('name','visitante')->get();
                $area = Reservation::join('social_areas','social_areas.id','=','social_area')
                    ->where('date',$date->toDateString())
                    ->whereNull('reservations.deleted_at')
                    ->where('reservation_status','!=',$status->id)
                    ->where('reservations.id',$request->backsearchevent)
                    ->get(['name_social_area','reservations.id as idarea','residence_id']);

                  $access_type = AccessType::where('name','invitado')->get();
                  if($area->isEmpty())
                  {
                      $area = "";
                      
                  }

                  $stregistro = $reservas->residence_id;

            }
            else
            {
              if (isset($_GET["street"]))
              {
                  $calle = $request->street;
                  
                  if(empty($calle) || is_null($calle))
                  {
                      $access = "";
                      $event = Reservation::join('social_areas','social_areas.id','=','social_area')
                      ->join('streets','streets.id','=','residence_id')
                      ->where('date',$date->toDateString())
                      ->whereNull('reservations.deleted_at')
                      ->where('reservation_status','!=',$status->id)
                      ->get(['name_social_area','name_street','number','time_start','time_end','reservations.id as rid']);

                      if($event->isEmpty())
                      {
                          $event = "";
                      }
                      $employe = "";

                      $st = "";
                      $number = "";
                      $scalle = $calle;
                      $mensaje = 1;
                      $backsearchevent ="";

                      if($permission_employe == 0)
                      {
                          $access_type = AccessType::where('name','empleado')->get();
                      }
                      elseif($permission_visit == 0)
                      {
                          $access_type = AccessType::Where('name','visitante')->get();
                      }
                      else
                      {
                          $access_type = AccessType::where('name','empleado')->orWhere('name','visitante')->get();
                      }

                      
                      $area = "";
                      $nombre_area = "";
                      $stregistro = "";


                  }
                  else
                  {
                      try{

                          $s = Street::findOrfail($calle);
                          
                      } catch (\Illuminate\Database\QueryException $e) {
               
                         $errors = 'La residencia que buscas no esta registrada.';
                         return redirect()->back()
                            ->withErrors($errors);
                              
                      } catch (\Exception $e) {
                      
                          $errors = 'La residencia que buscas no esta registrada.';
                          return redirect()->back()
                            ->withErrors($errors);
                      }

                    

                      $event = Reservation::join('social_areas','social_areas.id','=','social_area')
                      ->join('streets','streets.id','=','residence_id')
                      ->where('date',$date->toDateString())
                      ->whereNull('reservations.deleted_at')
                      ->where('reservation_status','!=',$status->id)
                      ->get(['name_social_area','name_street','number','time_start','time_end','reservations.id as rid']);

                      if($event->isEmpty())
                      {
                          $event = "";
                      }

                      $type = EmployeType::where('name',"recurrente")->first();
                      $dias = array('Domingo', 'Lunes','Martes','Miercoles','Jueves','Viernes','Sabado','Domingo');
                      $fecha = $dias[date('N', strtotime($date->toDateString()))];

                      
                      if($fecha == "Lunes"){$day = "monday";}
                      if($fecha == "Martes"){$day = "tuesday";}
                      if($fecha == "Miercoles"){$day = "wendsday";}
                      if($fecha == "Jueves"){$day = "thursday";}
                      if($fecha == "Viernes"){$day = "friday";}
                      if($fecha == "Sabado"){$day = "saturday";}
                      if($fecha == "Domingo"){$day = "sunday";}

                      $now = Carbon::now();
                      $month = $now->month;
                      
                      
                      //Aqui
                      $access = AccessColony::join('access_types','access_types.id','=','type')
                          ->leftjoin('employes', 'employe_id','=','employes.id')
                          ->leftjoin('employes_categories','category','=','employes_categories.id')
                          ->leftjoin('reservations','event_id','=','reservations.id')
                          ->leftjoin('social_areas','social_area','=','social_areas.id')
                          ->leftjoin('visits','visits.id','=','visit_id')
                          ->leftjoin('guest','guest.id','=','guest_id')
                          ->where('access_colonies.residence_id',$s->id)
                          /*->where('access_colonies.date',$date->toDateString())                                                 
                          ->whereNull('check_out')*/
                          ->where(function($query){
                              
                            $query->where('access_colonies.check_in','!=','null')->WhereNull('access_colonies.check_out')->orwhere('access_colonies.date',Carbon::now()->toDateString())->orwhere('access_colonies.date','==',Carbon::now()->subDay()->toDateString());
                          })
                          ->whereNull('check_out')
                          //->orwhere('access_colonies.date',$month)
                          //->orwhere('access_colonies.date',Carbon::now()->subDay()->toDateString())
                          ->select('employes.name as names','visits.name as namev','guest.name_guest as nameg','name_type','check_in','check_out','access_colonies.id','name_category','access_types.name as namest','access_colonies.residence_id','employes.url_file as eurl_file','visits.url_file as vurl_file','guest.url_file as gurl_file','employes.id as employeid','social_areas.name_social_area')
                          ->paginate(15);
                    
                          
                      
                      if($access->isEmpty())
                      {
                          $access = "";
                      }

                      $employe = RecurrentEmploye::join('employes','employe_id','=','employes.id')
                          ->join('employes_categories','category','=','employes_categories.id')
                          //->where('type',$type->id)
                          ->where('type',1)
                          ->where($day, 1)
                          //->where('date_end','>=',$date->toDateString())
                          ->where('residence_id',$s->id)
                          ->whereNull('employes.deleted_at')
                          ->groupBy('employes.name')
                          ->get(['employes.name as names', 'name_category','time_start','time_end','url_file','employes.id','residence_id','check_in']);
                    

                      if($employe->isEmpty())
                      {
                          $employe = "";
                      }

                      $visit = RecurrentVisit::join('visits','visits.id','=','visit_id')
                          ->select('name','check_in','url_file','visits.id as idv','residence_id')
                          //->where('type',$type->id)
                          ->where('type',1)
                          ->where($day, 1)
                          ///->whereDate('date_end','>=',$date->toDateString())
                          ->where('residence_id',$s->id)
                          ->whereNull('visits.deleted_at')
                          ->groupBy('visits.name')
                          ->get();
                      
                      
                      if($visit->isEmpty())
                      {
                          $visit = "";
                      }




                      $area = Reservation::join('social_areas','social_areas.id','=','social_area')
                      ->where('date',$date->toDateString())
                      ->whereNull('reservations.deleted_at')
                      ->where('reservation_status','!=',$status->id)
                      ->where('residence_id',$s->id)
                      ->get(['name_social_area','reservations.id as idarea']);

                    
                      $empleado = null;
                      $visitante = null;
                      $invitado = null;

                      if($permission_employe == 1)
                      {
                          $empleado = 1;
                          if($permission_visit == 1)
                          {
                              $visitante = 1;
                          }
                          elseif($permission_guest == 1)
                          {
                              $invitado = 1;
                          }
                      }
                      elseif($permission_visit == 1)
                      {
                          $visitante = 1;
                          if($permission_employe == 1)
                          {
                              $empleado = 1;
                          }
                          elseif($permission_guest == 1)
                          {
                              $invitado = 1;
                          }
                      }
                      elseif($permission_guest == 1)
                      {
                          $invitado = 1;
                          if($permission_visit == 1)
                          {
                              $visitante = 1;
                          }
                          elseif($permission_employe == 1)
                          {
                              $empleado = 1;
                          }
                      }
                     
                      $stregistro = $s->id;

                      $access_type="";
                      if($permission_employe == 1 && $permission_visit == 1 && $permission_guest == 1)
                      {
                          $access_type = AccessType::all();
                      }
                      elseif($permission_employe == 1)
                      {
                          $access_type = AccessType::where('name','empleado')
                              ->when($visitante, function ($query) use ($visitante) {
                                     
                                return $query->orwhere('name', 'visitante');
                              })
                              ->when($invitado, function ($query) use ($invitado) {
                                            
                                return $query->orwhere('name', 'invitado');
                              })

                            ->get();
                      }
                      elseif($permission_visit == 1)
                      {
                          
                          $access_type = AccessType::where('name', 'visitante')
                              ->when($empleado, function ($query) use ($empleado) {
                                  
                                return $query->orwhere('name', 'empleado');
                              })
                              ->when($invitado, function ($query) use ($invitado) {
                                            
                                return $query->orwhere('name', 'invitado');
                              })

                            ->get();

                            if($stregistro == 1)
                            {
                                $access_type = "";
                            }


                      }
                      elseif($permission_guest == 1)
                      {

                          $access_type = AccessType::where('name', 'invitado')
                            ->when($empleado, function ($query) use ($empleado) {
                                  
                                return $query->orwhere('name', 'empleado');
                              })
                              ->when($visitante, function ($query) use ($visitante) {
                                     
                                return $query->orwhere('name', 'visitante');
                              })

                            ->get();

                          if($stregistro == 1)
                          {
                              $access_type = "";
                          }


                      }


                   

                      if($area->isEmpty())
                      {
                          $area = "";
                          
                      }

                      $st = $s->name_street;
                      $number = $s->number;
                      $scalle = $calle;
                      $mensaje = "";
                      $backsearchevent = "";
                      $nombre_area = "";
                      
                      

                      
                  }

              }
              else
              {
                  
                $access = "";
                $event = Reservation::join('social_areas','social_areas.id','=','social_area')
                  ->join('streets','streets.id','=','residence_id')
                  ->where('date',$date->toDateString())
                  ->whereNull('reservations.deleted_at')
                  ->where('reservation_status','!=',$status->id)
                  ->get(['name_social_area','name_street','number','time_start','time_end','reservations.id as rid']);
                if($event->isEmpty())
                {
                  $event = "";
                }
                $employe = "";
                $st = "";
                $number = "";
                $scalle = $calle;
                $mensaje = "";
                $backsearchevent = "";

                $empleado = null;
                $visitante = null;
               

                if($permission_employe == 1)
                {
                  $empleado = 1;
                }
                elseif($permission_visit == 1)
                {
                  $visitante = 1;
                }
               

                $access_type = AccessType::when($empleado, function ($query) use ($empleado) {
                                  
                      return $query->where('name', 'empleado');
                    })
                    ->when($visitante, function ($query) use ($visitante) {
                                     
                      return $query->where('name', 'visitante');
                    })
                  ->get();

                //$access_type = AccessType::where('name','empleado')->orWhere('name','visitante')->get();
                $area ="";
                $nombre_area = "";
                $stregistro = "";
     
              }

              if(isset($_GET["eventid"]))
              {
                  $access = AccessColony::join('access_types','access_types.id','=','type')
                          ->join('guest', 'guest_id','=','guest.id')
                          ->where('date',$date->toDateString())
                          ->where('event_id',$request->eventid)
                          ->whereNull('check_out')
                          ->get(['guest.name_guest as names','check_in','check_out','access_colonies.id','access_types.name as namest','access_colonies.residence_id','guest.url_file as gurl_file','name_type']);
                  if($access->isEmpty())
                  {
                      $access = "";
                  } 
                  $event = Reservation::join('social_areas','social_areas.id','=','social_area')
                    ->join('streets','streets.id','=','residence_id')
                    ->where('date',$date->toDateString())
                    ->whereNull('reservations.deleted_at')
                    ->where('reservation_status','!=',$status->id)
                    ->get(['name_social_area','name_street','number','time_start','time_end','reservations.id as rid']);
                  if($event->isEmpty())
                  {
                    $event = "";
                  }
                  
                  $employe = "";

                  $st = "";
                  $number = "";
                  $reservas = Reservation::findOrfail($request->eventid);
                  $nombre_area = SocialArea::findOrfail($reservas->social_area);
                  if($permission_guest == 0)
                  {
                      $scalle = "";
                  }
                  else
                  {
                      $scalle = $reservas->residence_id;
                  }
                  
                  $mensaje = "";
                  $backsearchevent = $request->eventid;
                  $access_type = AccessType::where('name','invitado')->get();
                  $area = Reservation::join('social_areas','social_areas.id','=','social_area')
                    ->where('date',$date->toDateString())
                    ->whereNull('reservations.deleted_at')
                    ->where('reservation_status','!=',$status->id)
                    ->where('reservations.id',$request->eventid)
                    ->get(['name_social_area','reservations.id as idarea','residence_id']);

                  $access_type = AccessType::where('name','invitado')->get();
                  if($area->isEmpty())
                  {
                      $area = "";
                      
                  }

                  $stregistro = $reservas->residence_id;
              }



          }

            $street = Street::getStreetwithUser();
            $a = 0;
            $b = 0;
            $c = 0;
            $d = 0;
            $e = 0;
            $category = EmployeCategory::all();
            $QRlook = 0;
         
            
            
            return view('dashboard.guard', compact('event','access','employe','st','number','street','mensaje','a','b','c','backsearchevent','d','category','access_type','scalle','area','nombre_area','visit','e','stregistro','QRlook','fechatodos1','fechatodos2','calle'));
        }
        else
        {
            return redirect('/home');
        }

       
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
         try{
        
            $fecha = Carbon::now();

            $access = AccessColony::findOrfail($request->id);
            
            $access->update([
                'check_in' => $fecha,
            ]);

            if($request->backsearchevent)
            {
                $backsearchevent = $request->backsearchevent;
                return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $backsearchevent]);
            }
            elseif($request->qr)
            {
                $mensaje = "Se guardo la entrada correctamente.";
                Session::flash('message2', $mensaje );
                return redirect()->action('DashboardGuardController@index');
            }
            else
            {
              $street = $request->backsearch;
              return redirect()->action('DashboardGuardController@index', ['street' => $street]);
            }
        
        } catch (\Illuminate\Database\QueryException $e) {
             
           $error = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($error);
                
        } catch (\Exception $e) {
        
            $error = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($error);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        try{
            $fecha = Carbon::now();

            $access = AccessColony::findOrfail($request->id);
            if($access->type == 2)
            {
                $recurrent = RecurrentEmploye::where('employe_id',$access->employe_id)->get();

                if($recurrent->isEmpty())
                {

                }
                else
                {

                    $recur= RecurrentEmploye::where('employe_id',$access->employe_id)->first();
                    $recur->update([

                      'check_in' => 0,

                    ]);
                }
                

            }
            elseif($access->type == 3)
            {
                $recurrent = RecurrentVisit::where('visit_id',$access->visit_id)->get();

                if($recurrent->isEmpty())
                {

                }
                else
                {

                    $recur= RecurrentVisit::where('visit_id',$access->visit_id)->first();
                    $recur->update([

                      'check_in' => 0,

                    ]);
                }
            }
            
                $access->update([

                  'check_out' => $fecha,

                ]);
            
            

            if($request->backsearchevent)
            {
                $backsearchevent = $request->backsearchevent;
                return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $backsearchevent]);
            }
            else
            {
                $street = $request->backsearch;
                return redirect()->action('DashboardGuardController@index', ['street' => $street]);
            }
            

        } catch (\Illuminate\Database\QueryException $e) {
             
           $error = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($error);
            
                
        } catch (\Exception $e) {
        
            $error = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($error);
          
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
