<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\GuardInfo;
use App\Colony;
use App\AccountInfo;
use App\Employe;
use Auth;
use App\Income;
use DB;
use App\MemberColony;
use App\IncomeCategory;
use App\PaymentType;
use Carbon\Carbon;
use App\Month;
use App\Street;
use App\Admin;
use App\Payment;
use App\Reservation;
use App\Report;
use App\AccessColony;
use App\Popup;
use App\Config;
use App\User;
use App\Rol;



class DashboardResController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        
   

        $user = Auth::user();
      
        if($user->can('index', \App\Res::class))
        {
            
            $income = Report::getIncomesLastYear();
            $debts = Report::getDebtResident();
            $debt = number_format($debts, 2, '.', ',');
            $alldebts = Report::getAllDebtResident2();
            $alldebt = number_format($alldebts, 2, '.', ',');
            $a = 0;
            $cartera = Report::getAllDebtResident();
            $carterap = Report::getallPay();
            $date = Carbon::now();

            $pays = Report::getPays();
            if($pays == " ")
            {
                $pay = 0;
            }
            else
            {
                $pay = $pays;
            }
            

            $visit = AccessColony::leftjoin('employes','employe_id','=','employes.id')
                ->leftjoin('employes_types','employes.type','=','employes_types.id')
                ->leftjoin('recurrent_employes','recurrent_employes.employe_id','=','employes.id')
                ->leftjoin('visits','visits.id','=','visit_id')
                ->leftjoin('guest','guest_id','=','guest.id')
                ->where('access_colonies.residence_id', Auth::user()->street_id)
                ->whereNotNull('access_colonies.check_in')
                ->orderBy('access_colonies.created_at','DESC')
                ->take(5)
                ->get(['visits.name as namev','employes.name as namee','guest.name_guest as nameg','date','access_colonies.check_in','access_colonies.check_out','time_start','time_end','employes_types.name as typename','guard_create']);
            

            $event = Reservation::join('social_areas','social_area','=','social_areas.id')
                ->join('status','reservation_status','=','status.id')
                ->where('date','>=', $date->toDateString())
                ->where('residence_id',Auth::user()->street_id)
                ->orderBy('reservations.created_at','DESC')
                ->take(5)
                ->get();

            $popup = Popup::all();
            $date = Carbon::now();

            if($popup->isEmpty())
            {
                $pop = "";
            }
            else
            {
                foreach ($popup as $popups) 
                {
                    $start = $popups->start;
                    $end = $popups->end;
                    $pop = $popups->popup_message;
                }

                if($date->toDateString() >= $start && $date->toDateString() <= $end  )
                {
                    $pop = $pop;
                }
                else
                {
                    $pop = "";
                }
            }

            $config = Config::all();
            foreach ($config as $configs) 
            {
                $showdebt = $configs->show_debt_resident;
            }

            return view('dashboard.resident', compact('income','debt','alldebt','a','visit','event','pop','pay','showdebt'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
