<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccountReceivable;
use App\PaymentAccountReceivable;
use App\Payment;
use DB;

class DetailsPaymentResidentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $pago = $request->paymentid;
        
        $income = Payment::join('payment_types','payment_types.id','=','payment_type')
            ->join('status','status', '=','status.id')
            ->select('payment_date','capture_date','description','amount','payment_name','payments.id as ids','status_name','status.name as stname')
            ->where('payments.id',$pago)
            ->get();
 

        $detalle = PaymentAccountReceivable::join('accounts_receivables','accounts_receivables.id','=','id_account_receivables')
            ->join('income_categories','income_categories.id','=','category')
            ->select('category_name','accounts_receivables.description','paid')
            ->where('id_payment',$pago)
            ->get();

        $total = PaymentAccountReceivable::join('accounts_receivables','accounts_receivables.id','=','id_account_receivables')
            ->join('income_categories','income_categories.id','=','category')
            ->select(DB::raw('SUM(paid) as pay'))
            ->where('id_payment',$pago)
            ->get();
        

        return view('incomes.residentincomes.detailpay', compact('detalle','income','total'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
