<?php

namespace App\Http\Controllers;

use App\Directory;
use Illuminate\Http\Request;
use App\PerfilConfig;
use App\User;
use Auth;
use App\Config;

class DirectoryController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $users = Auth::user();
      
        if($users->can('index', \App\Directory::class))
        {
            
            $permission = Config::permissionDebtors();
            if($permission == 1)
            {
                $filtro = $request->input('streetnumber');

                $user = User::join('streets','streets.id','=','street_id')
                    ->leftjoin('perfil_configs','user_id','=','users.id')
                    ->select('name','email','name_street','number','phone_resident')
                    ->where('private_profile',1)
                    ->when($filtro, function ($query) use ($filtro) {
                        
                        return $query->where('streets.id',$filtro);   
                        
                    })
                    ->orderby('name_street','ASC')
                    ->orderby('number','ASC')
                    ->paginate(15);

             

                return view('directory.index', compact('user'));
            }
            else
            {
                return redirect('/home');
            }
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Directory  $directory
     * @return \Illuminate\Http\Response
     */
    public function show(Directory $directory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Directory  $directory
     * @return \Illuminate\Http\Response
     */
    public function edit(Directory $directory)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Directory  $directory
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Directory $directory)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Directory  $directory
     * @return \Illuminate\Http\Response
     */
    public function destroy(Directory $directory)
    {
        //
    }
}
