<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Discussion;
use App\Status;
use App\Street;
use App\DiscussionResidence;
use Auth;
use DB;
use Carbon\Carbon;
use Illuminate\Pagination\LengthAwarePaginator as Paginator;
use App\Config;
use Illuminate\Pagination\LengthAwarePaginator;

class DiscussionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = Auth::user();

        if ($user->can('index', \App\Income::class)) {

            if ($request->abierto == 1) {
                $abierto = 1;
            } else {
                $abierto = 0;
            }

            $a = 0;

            $di = Discussion::all();

            foreach ($di as $dis) {
                $rd = DiscussionResidence::where('id_discussions', $dis->id)->get();
                $rr = $rd->toArray();
                $sta = Status::findOrfail($dis->status);

                $iddiscusion = $dis->id;
                $title = $dis->title;
                $description = $dis->description;
                $start_date = $dis->start_date;
                $end_date = $dis->end_date;
                $status = $dis->status;
                $status_name = $sta->status_name;
                $staname = $sta->name;

                if (empty($rr)) {
                    $q[] = array(
                        'id' => $iddiscusion,
                        'title' => $title,
                        'description' => $description,
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                        'status' => $status,
                        'status_name' => $status_name,
                        'staname' => $staname,
                        'status_resident' => 0,
                        'favor' => 0,
                        'contra' => 0,
                        'absten' => 0
                    );
                } else {
                    $fo = DiscussionResidence::where('id_discussions', $dis->id)->where('id_discussions_options', 1)->get();
                    $favor = count($fo);
                    $co = DiscussionResidence::where('id_discussions', $dis->id)->where('id_discussions_options', 2)->get();
                    $contra = count($co);
                    $ao = DiscussionResidence::where('id_discussions', $dis->id)->where('id_discussions_options', 3)->get();
                    $absten = count($ao);




                    $q[] = array(
                        'id' => $iddiscusion,
                        'title' => $title,
                        'description' => $description,
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                        'status' => $status,
                        'status_name' => $status_name,
                        'staname' => $staname,
                        'status_resident' => 0,
                        'favor' => $favor,
                        'contra' => $contra,
                        'absten' => $absten
                    );
                }
            }


            if ($di->isEmpty()) {
                $total = " ";
            } else {

                $total = new LengthAwarePaginator(
                    array_slice($q, ($request->input('page', 1) * 15) - 15, 15, true),
                    count($q),
                    15,
                    $request->input('page', 1),
                    ['path'  => $request->url(), 'query' => $request->query()]
                );
            }
            return view('discussions.index', compact('abierto', 'total', 'a'));
        } else {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        try {

            DB::beginTransaction();

            $abierta = Status::where('name', 'abierta')->first();

            $discusion = Discussion::create([

                'title'  => $request->title,
                'description' => $request->description,
                'start_date' => $request->start_date,
                'end_date' => $request->end_date,
                'status' => $abierta->id

            ]);



            DB::commit();

            return redirect()->action('DiscussionController@index', ['abierto' => "1"]);
        } catch (\Illuminate\Database\QueryException $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors)
                ->withInput();
        } catch (\Exception $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors)
                ->withInput();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $discusion = Discussion::findOrfail($id);
        $status = Status::findOrfail($discusion->status);

        $street = Street::where('empty_residence', 0)->get();
        $total_street = count($street);

        /// total de residencias al corriente ///
        $date = Carbon::now();
        $estatus = Status::where('name', 'activo')->first();
        $total = Street::leftjoin(DB::raw('(SELECT SUM(to_pay) as pasado,residence  FROM accounts_receivables WHERE deadline > "' . $date->toDateString() . '" AND estatus = "' . $estatus->id . '"  GROUP BY accounts_receivables.residence) as corriente'), 'streets.id', '=', 'corriente.residence')
            ->select('pasado', 'streets.id', 'name_street', 'number')
            ->where('empty_residence', 0)
            ->get();

        if (empty($total)) {
            $r = 0;
        } else {

            foreach ($total as $totales) {
                if (is_null($totales->pasado)) {
                    $r[] = 1;
                }
            }
        }

        $total_residents = count($r);





        /// residentes que han votado /////
        $vote1 = DiscussionResidence::where('id_discussions', $id)->get();

        if (empty($vote1)) {
            $resident_voted = 0;
        } else {
            $resident_voted = count($vote1);
        }

        $config = Config::all();
        foreach ($config as $configs) {
            $permiso = $configs->discussion_debtor;
        }


        /// porcentajes ////

        $f = DiscussionResidence::where('id_discussions', $id)->where('id_discussions_options', 1)->get();
        $favor = count($f);
        $c = DiscussionResidence::where('id_discussions', $id)->where('id_discussions_options', 2)->get();
        $contra = count($c);
        $a = DiscussionResidence::where('id_discussions', $id)->where('id_discussions_options', 3)->get();
        $abstenciones = count($a);

        if ($permiso == 1) {
            $pfavor =  number_format(($favor * 100) / $total_street, 2, '.', ',');
            $pcontra =  number_format(($contra * 100) / $total_street, 2, '.', ',');
            $pabstenciones =  number_format(($abstenciones * 100) / $total_street, 2, '.', ',');
        } else {
            /*$pfavor =  number_format(($favor*100)/$total_residents, 2, '.', ',');
            $pcontra =  number_format(($contra*100)/$total_residents, 2, '.', ',');
            $pabstenciones =  number_format(($abstenciones*100)/$total_residents, 2, '.', ',');*/
            $pfavor =  number_format(($favor * 100) / $total_street, 2, '.', ',');
            $pcontra =  number_format(($contra * 100) / $total_street, 2, '.', ',');
            $pabstenciones =  number_format(($abstenciones * 100) / $total_street, 2, '.', ',');
        }



        /// residentes por votar /////



        if ($permiso == 1) {
            $r = Street::where('empty_residence', 0)->get();
            $tr = count($r);

            $to_vote = $tr - $resident_voted;
        } else {
            $r = Street::where('empty_residence', 0)->get();
            $tr = count($r);
            $to_vote = $tr - $resident_voted;
            //$to_vote = $total_residents-$resident_voted;
        }



        /// fecha limite de cierre de votación ///
        $limit_date = $discusion->end_date;

        return view('discussions.details', compact('discusion', 'status', 'total_street', 'limit_date', 'resident_voted', 'total_residents', 'to_vote', 'pfavor', 'pcontra', 'pabstenciones'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
