<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Discussion;
use App\DiscussionResidence;
use App\DiscussionOption;
use Auth;
use DB;
use App\Status;
use Illuminate\Pagination\LengthAwarePaginator as Paginator;
use Input;
use App\AccountReceivable;
use Carbon\Carbon;
use App\Config;


class DiscussionResController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = Auth::user();
      
        if($user->can('index', \App\IncomeResident::class))
        {
            
            $a = 0;

            
            $di = Discussion::all();

            foreach ($di as $dis) 
            {
                    $rd = DiscussionResidence::where('id_discussions',$dis->id)->get();
                    $rr = $rd->toArray();
                    $sta = Status::findOrfail($dis->status);

                    $iddiscusion = $dis->id;
                    $title = $dis->title;
                    $description = $dis->description;
                    $start_date = $dis->start_date;
                    $end_date = $dis->end_date;
                    $status = $dis->status;
                    $status_name = $sta->status_name;
                    $staname = $sta->name;

                    if(empty($rr))
                    {
                        $q[] = array('id' => $iddiscusion,
                            'title' => $title,
                            'description' => $description,
                            'start_date' => $start_date,
                            'end_date' => $end_date,
                            'status' => $status,
                            'status_name' => $status_name,
                            'staname' => $staname,
                            'status_resident' => 0,
                            'favor' => 0, 
                            'contra' => 0, 
                            'absten' => 0);
                    }
                    else
                    {
                        $fo = DiscussionResidence::where('id_discussions',$dis->id)->where('id_discussions_options',1)->get();
                        $favor= count($fo);
                        $co = DiscussionResidence::where('id_discussions',$dis->id)->where('id_discussions_options',2)->get();
                        $contra= count($co);
                        $ao = DiscussionResidence::where('id_discussions',$dis->id)->where('id_discussions_options',3)->get();
                        $absten= count($ao);
                        $resident = DiscussionResidence::where('id_discussions',$dis->id)->where('id_residence',Auth::user()->street_id)->get();
                        if($resident->isEmpty())
                        {
                            $residente = 0;
                        }
                        else
                        {
                            foreach ($resident as $residents) {
                            
                                $residente = $residents->status;
                            }
                        }
                        
                    
                        $q[] = array('id' => $iddiscusion,
                            'title' => $title,
                            'description' => $description,
                            'start_date' => $start_date,
                            'end_date' => $end_date,
                            'status' => $status,
                            'status_name' => $status_name,
                            'staname' => $staname,
                            'status_resident' => $residente,
                            'favor' => $favor, 
                            'contra' => $contra, 
                            'absten' => $absten);

                    }
            }
            
            $date = Carbon::now();
            $estatus = Status::where('name','activo')->first();

            $deudas = AccountReceivable::select(DB::raw('(SELECT SUM(to_pay)) as pasado'))
                ->where('deadline','<',$date->toDateString())
                ->where('estatus',$estatus->id)
                ->where('residence', Auth::user()->street_id)
                ->first();

            $config = Config::all();
            foreach ($config as $configs) 
            {
                $permiso = $configs->discussion_debtor;
            }
            

            if($di->isEmpty())
            {
                $total = " ";
            }
            else
            {
                $total = new Paginator(array_slice($q,(Input::get('page',1)*15)-15,15,true), count($q), 15, Input::get('page',1) ,['path'  => $request->url(),'query' => $request->query(),]);
            }

            
            return view('discussions.resident.index', compact('discusion','a','total','deudas','permiso'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        try{

              DB::beginTransaction();

              $config = Config::all();
              foreach ($config as $configs) 
              {
                  $permiso = $configs->discussion_debtor;
              }
              $date = Carbon::now();
              $estatus = Status::where('name','activo')->first();
              $deudas = AccountReceivable::select(DB::raw('(SELECT SUM(to_pay)) as pasado'))
                ->where('deadline','<',$date->toDateString())
                ->where('estatus',$estatus->id)
                ->where('residence', Auth::user()->street_id)
                ->first();




                //dd($request->all());
                if($request->afavor == "on")
                {
                    $option = DiscussionOption::where('name',"a_favor")->first();
                }
                else if($request->encontra == "on")
                {
                    $option = DiscussionOption::where('name',"en_contra")->first();
                }
                else if($request->abstenciones == "on")
                {
                    $option = DiscussionOption::where('name',"abstencion")->first();
                }

                if(!is_null($request->comments1))
                {
                    $comment = $request->comments1;
                }
                else if(!is_null($request->comments2))
                {
                    $comment = $request->comments2;
                }
                else
                {
                    $comment = "";
                }

                $search = DiscussionResidence::where('id_discussions',$request->iddiscussion)->where('id_residence',Auth::user()->street_id)->get();
                $s = $search->toArray();
                if(empty($s))
                {

                  $discusion_original = Discussion::findOrfail($request->iddiscussion);
                  $aceptada = Status::where('name','aceptada')->first();
                  $rechazada = Status::where('name','rechazada')->first();
                  if($discusion_original->status == $aceptada->id || $discusion_original->status == $rechazada->id)
                  {
                      $errors = ['repetido' => 'La discusión ha concluido, ya no puedes participar.'];
                     return redirect()->back()
                        ->withErrors($errors)
                          ->withInput();
                  }
                  else
                  {

                    if(!is_null($deudas->pasado))
                    {
                        if($permiso == 1)
                        {
                          $status = Status::where('name','realizada')->first();
                          $dr = DiscussionResidence::create([

                              'id_discussions' => $request->iddiscussion, 
                              'id_residence' => Auth::user()->street_id, 
                              'status' => $status->id, 
                              'id_discussions_options' => $option->id, 
                              'comments' => $comment,
                              'status'  => $status->id,

                          ]);
                        }
                        else
                        {
                            $errors = ['repetido' => 'No tienes permiso para participar en la discusión, porque no estas al corriente en tus pagos.'];
                            return redirect()->back()
                                ->withErrors($errors)
                                  ->withInput();
                        }
                    }
                    else
                    {
                        $status = Status::where('name','realizada')->first();
                        $dr = DiscussionResidence::create([

                            'id_discussions' => $request->iddiscussion, 
                            'id_residence' => Auth::user()->street_id, 
                            'status' => $status->id, 
                            'id_discussions_options' => $option->id, 
                            'comments' => $comment,
                            'status'  => $status->id,

                        ]);
                    }
                  }
                    
                }
                else
                {
                    $errors = ['repetido' => 'Ya habias participado en esta discusión.'];
                     return redirect()->back()
                        ->withErrors($errors)
                          ->withInput();
                }


            DB::commit();


            return redirect('/discussions_resident');

        } catch (\Illuminate\Database\QueryException $e) {
               
             $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
             return redirect()->back()
                ->withErrors($errors)
                  ->withInput();
                  
          } catch (\Exception $e) {
          
              $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
              return redirect()->back()
                ->withErrors($errors)
                  ->withInput(); 
                 
                  
          }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
