<?php

namespace App\Http\Controllers;

use App\Document;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use Auth;
use Session;


class DocumentController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = Auth::user();
      
        if($user->can('index', \App\Document::class ))
        {
            $document = Document::paginate(15);
            $a =1;
            if($request->abierto == 1)
            {
                 $abierto = 1;
            }
            else
            {
                 $abierto = 0;
            }
            return view('documents.index', compact('document','a','abierto'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
      
        if($user->can('create', \App\Document::class ))
        {
            return view('documents.create');
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      //dd($request->all());
        try{

               $messages = [

                    'required'  => 'Este campo es requerido.',
                    'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                    'max'   => 'El archivo no debe pesar mas de 5 mb.',
                    'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                ];

                $rules = [

                    'file'          => 'required|max:5000|mimes:jpeg,jpg,png,pdf', //5000kb image/jpeg image/png
                    'name_document' => 'required',
                ];

                $validator = Validator::make($request->all(),$rules,$messages);

                if ($validator->fails()) {
                    return redirect()->back()
                                ->withErrors($validator)
                                ->withInput();
                }
                else
                {
                    
                    
                    if (Input::hasFile('file'))
                    {
                        $fileInput= Input::file('file');
                        $fileType = $fileInput->getMimeType();
                        $clave = str_random(5);

                        if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                        { 
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }
                            
                           

                            if($request->imageData)
                            {
                              $data = base64_decode($request->imageData);

                              $im = imagecreatefromstring($data);

                              if ($im !== false) {
                   
                                  $file = new Document;
                                  $file->name_document = $request->name_document;
                                  
                                  $file->save();

                                  $name_imagen = $file->id.".".$type;
                                  $url = '/uploads/documents/';
                                  $path = public_path().$url.$name_imagen;
                                  $peso = $request->sizeData*1024;

                                  $file->update([

                                    'file_name' => $name_imagen,
                                    'url_file'  => $url.$name_imagen,
                                    'file_type' => $request->contentType,
                                    'file_size' => $peso,

                                  ]);

                                  header('Content-Type: ',$request->contentData);
                                  imagejpeg($im, $path);

                                  imagedestroy($im);
                              }
                              else 
                              {
                                  $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                   return redirect()->back()
                                      ->withErrors($errors);
                                      
                              }
                            }
                            else 
                            {
                                $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                  return redirect()->back()
                                      ->withErrors($errors);
                                     
                            }

                        }
                        else
                        {
                            
                            $path = public_path().'/uploads/documents/';
                            $url = '/uploads/documents/';
                            $fileType = $fileInput->getMimeType();
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }
                            $fileSize = $fileInput->getClientSize()/1024;

                            $file = new Document;
                            $file->name_document = $request->name_document;
                           
                            $file->save();

                            $fileName = $file->id.".".$type;

                            if($fileInput->move($path,$fileName))
                            {       
                                $file->update([

                                    'file_name' => $fileName,
                                    'url_file'  => $url.$fileName,
                                    'file_type' => $fileType,
                                    'file_size' => $fileSize,

                                ]);
                            }

                        }

                    }
                    
                   
                }

                return redirect()->action('DocumentController@index', ['abierto' => "1"]);

        } catch (\Illuminate\Database\QueryException $e) {
             
          $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
        
            
                
        } catch (\Exception $e) {
        
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
            
            
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Document  $document
     * @return \Illuminate\Http\Response
     */
    public function show(Document $document)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Document  $document
     * @return \Illuminate\Http\Response
     */
    public function edit(Document $document)
    {

        $user = Auth::user();

        if($user->can('edit', $document))
        {
            return view('documents.edit', compact('document'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Document  $document
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Document $document)
    {
        try{
                $user = Auth::user();
        
                if($user->can('update', $document))
                {
                     $messages = [

                        'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                        'max'   => 'el archivo no debe pesar mas de 5 mb.',
                        'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                        'required'  => 'Este campo es requerido.',
                    ];

                    $rules = [

                        'file' => 'max:5000|mimes:jpeg,jpg,png,pdf', //5000kb image/jpeg image/png
                        'name_document' => 'required',
                    ];

                    $validator = Validator::make($request->all(),$rules,$messages);

                    if ($validator->fails()) {
                        return redirect()->back()
                                    ->withErrors($validator)
                                    ->withInput();
                    }
                    else
                    {

                        

                        if (Input::hasFile('file'))
                        {

                          $fileInput= Input::file('file');
                          $fileType = $fileInput->getMimeType();
                          $clave = str_random(5);

                          if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                          { 
                              if($fileType == "image/jpeg")
                              {
                                  $type = "jpg";
                              }
                              else if($fileType == "application/pdf")
                              {
                                  $type = "pdf";
                              }
                              else if($fileType == "image/png")
                              {
                                  $type = "png";
                              }
                              $name_imagen = $document->id.".".$type;
                              $url = '/uploads/documents/';
                              $path = public_path().$url.$name_imagen;
                              $peso = $request->sizeData*1024;

                              if($request->imageData)
                              {
                                $data = base64_decode($request->imageData);
                                $im = imagecreatefromstring($data);
                                if ($im !== false) {
                                    header('Content-Type: ',$request->contentData);
                                    imagejpeg($im, $path);
                                    $img = public_path().$document->url_file;
                                    
                                    $document->update([
                                      'name_document' =>  $request->name_document,
                                      'file_name'     =>  $name_imagen,
                                      'url_file'      =>  $url.$name_imagen,
                                      'file_type'     =>  $request->contentType,
                                      'file_size'     =>  $peso,

                                    ]);

                                    //unlink($img);

                                    imagedestroy($im);
                                }
                                else 
                                {
                                    $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                     return redirect()->back()
                                        ->withErrors($errors);
                                }
                              }
                              else 
                              {
                                  $errors = ['error' => 'Tu navegador no tiene soporte para las funciones de carga de imagenes.Solo puedes subir pdf.'];
                                    return redirect()->back()
                                        ->withErrors($errors);
                              }

                          }
                          else
                          {
                              
                              $path = public_path().'/uploads/documents/';
                              $url = '/uploads/documents/';
                              $fileType = $fileInput->getMimeType();
                              if($fileType == "image/jpeg")
                              {
                                  $type = "jpg";
                              }
                              else if($fileType == "application/pdf")
                              {
                                  $type = "pdf";
                              }
                              else if($fileType == "image/png")
                              {
                                  $type = "png";
                              }
                              $fileSize = $fileInput->getClientSize()/1024;
                              $fileName = $document->id.".".$type;

                              $file = new Document;
                              $file->name_document = $request->name_document;
                              $file->file_name = $fileName;
                              $file->url_file = $url.$fileName;
                              $file->file_type = $fileType;
                              $file->file_size = $fileSize;
                              $img = public_path().$document->url_file;

                              if($fileInput->move($path,$fileName))
                              {       
                                  $document->update([
                                      'name_document' =>  $request->name_document,
                                      'file_name'     =>  $fileName,
                                      'url_file'      =>  $url.$fileName,
                                      'file_type'     =>  $fileType,
                                      'file_size'     =>  $fileSize,

                                  ]);

                                  //unlink($img);
                              }
                            }
                            
                        
                        }
                        else
                        {
                            $document->update([
                                'name_document' =>  $request->name_document,
                            ]);

                        }
                    }

                    return redirect('/documents');

                }
                else
                {
                    return redirect('/home');
                }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
             
           
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
            
            
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Document  $document
     * @return \Illuminate\Http\Response
     */
    public function destroy(Document $document, Request $request)
    {
        
        try{ 

            $user = Auth::user();

              $documento = Document::findOrfail($request->id);
              $documento->delete();
              return redirect('/documents');


        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }
}
