<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Payment;
use App\PaymentAccountReceivable;
use App\AccountReceivable;
use App\Account;
use App\Street;
use App\PaymentType;

class EditIncomeController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $payment = Payment::findOrfail($id);
        $account = Account::all(); 
        $street = Street::getStreetwithUser();
        $payment_type = PaymentType::all();

        return view('incomes.edit', compact('payment','account','street','payment_type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $payment = Payment::findOrfail($id);

        /**** si cambia la cuenta ****/
        if($payment->account_id != $request->accountid)
        {
            $oldaccount = Account::findOrfail($payment->account_id);
            $oldtotal = $oldaccount->balance - $payment->amount;
            $oldaccount->update([

                'balance' => $oldtotal,

            ]);

            $newaccount = Account::findOrfail($request->accountid);
            $newtotal = $newaccount->balance + $request->amount;
            $newaccount->update([

                'balance' => $newtotal,
            ]);       
        }

        /***** si cambia la cantidad ****/
        if($payment->amount != $request->amount)
        {
            
            $pivote = PaymentAccountReceivable::where('id_payment',$id)->get();

            foreach ($pivote as $pivotes) 
            {
                
                $cuenta = AccountReceivable::findOrfail($pivotes->id_account_receivables);
                $topay = $cuenta->to_pay + $pivotes->paid;
                $cuenta->update([

                    'to_pay' =>  $topay,

                ]);

                $pi = PaymentAccountReceivable::findOrfail($pivotes->id);
                $pi->delete();
               
            }
        }
        
        



        /*$fileInput= Input::file('file');

        if (Input::hasFile('file'))
        {
            $fileName = $fileInput->getClientOriginalName();
            $path = public_path().'/uploads/vouchers/';
            $url = '/uploads/vouchers/';
            $fileType = $fileInput->getMimeType();
            $fileSize = $fileInput->getClientSize()/1024;

            if($fileInput->move($path,$fileName))
            {       
                $payment->edit([

                    'amount'        => $request->amount,
                    'description'   => $request->description,
                    'residence'     => $request->residence,
                    'payment_date'  => $request->payment_date,
                    'payment_type'  => $request->payment_type,
                    'name_file'     => $fileName,
                    'url_file'      => $url.$fileName,
                    'type_file'     => $fileType,
                    'size_file'     => $fileSize,
                    'account_id'    => $request->accountid,
                ]);
            }
      
        }
        else
        {
            $payment->edit([

                'amount'        => $request->amount,
                'description'   => $request->description,
                'residence'     => $request->residence,
                'payment_date'  => $request->payment_date,
                'payment_type'  => $request->payment_type,
                'account_id'    => $request->accountid,
            ]);

            
        }*/

       
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
