<?php

namespace App\Http\Controllers;

use App\Employe;
use Illuminate\Http\Request;
use Auth;
use App\Reservation;
use DB;
use Session;
use App\WorkerEvent;
use App\AccessType;
use App\RecurrentEmploye;
use App\EmployeCategory;
use App\AccessColony;
use App\EmployeType;
use App\Visit;
use Validator;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Carbon\Carbon;
use App\Rol;
use App\User;
use App\Config;
use QrCode;

class EmployeController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = User::find(Auth::id());

        $permission = Config::permissionDebtors();
        if ($permission == 1) {

            $employe = Employe::join('employes_categories', 'employes_categories.id', '=', 'category')
                ->join('employes_types', 'employes_types.id', '=', 'type')
                ->where('residence_id', Auth::user()->street_id)
                ->select('employes.name as names', 'name_category', 'name_type', 'url_file', 'employes.id as id')
                ->paginate(10);

            if ($employe->isEmpty()) {
                $employe = "";
            }

            $type = EmployeType::all();
            $category = EmployeCategory::all();
            $em = AccessType::where('name', 'empleado')->first();
            $access = AccessColony::where('residence_id', Auth::user()->street_id)->where('type', $em->id)->whereNotNull('employe_id')->get();
            $a = 0;
            $b = 0;
            $r = Rol::where('name', "administrator")->first();

            $us = Auth::user();
            $rol = $us->belongsToMany('App\Rol')->wherePivot('user_id', Auth::id())->first();
            $rol_id = $rol->id;
            if ($request->abierto == 1) {
                $abierto = 1;
            } else {
                $abierto = 0;
            }

            if ($request->u) {
                $modal = 1;
                $u = $request->u;
                $n = $request->n;
            } else {
                $modal = 0;
                $u = "";
                $n = "";
            }

            return view('reservations.employes.index', compact('employe', 'type', 'category', 'access', 'a', 'rol_id', 'r', 'abierto', 'b', 'modal', 'u', 'n'));
        } else {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        /*$type = AccessType::all();
        return view('reservations.employes.create', compact('type'));*/
        return redirect('/employes');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $messages = [
                'mimes'         => 'El archivo debe ser tipo jpeg, jpg o png.',
                'max'           => 'el archivo no debe pesar mas de 5 mb.',
                'uploaded'      => 'El archivo no debe pesar mas de 5 mb.',
                'required'      => 'Este campo es requerido.',
                'required_if'   => 'Este campo es requerido.',
            ];

            $rules = [
                'file'          => 'max:5000|mimes:jpeg,jpg,png', //5000kb image/jpeg image/png
                'file1'         => 'max:5000|mimes:jpeg,jpg,png',
                'name'          => 'required',
                'category'      => 'required',
                'employe_type'  => 'required',
                'time_start'    => 'required_if:employe_type,recurrente',
                'time_end'      => 'required_if:employe_type,recurrente',
                'date'          => 'required_if:employe_type,eventual',
            ];

            $validator = Validator::make($request->all(), $rules, $messages);

            if ($validator->fails()) {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            } else {
                DB::beginTransaction();
                $a_id = Employe::createEmploye($request);
                DB::commit();

                if ($request->employe_type == "recurrente") {
                    return redirect('/employes');
                } else {
                    $id_visit = $a_id->id;
                    $type_access = 2;
                    $type = $a_id->type;

                    $date = Carbon::now();
                    $qstr = str_random(8);
                    $qrdate = $request->date;
                    $nameqr =  $qstr . $id_visit . $qrdate . '.png';
                    $url = '/qrcodes/' . $nameqr;
                    $path = public_path() . $url;

                    QrCode::format('png')->size(500)->merge('/public/assets/image-resources/logoqr.png', .1, false)->generate($id_visit . "/" . $type_access . "/" . $type . "/" . $qrdate, $path);

                    return redirect()->action('EmployeController@index', ['abierto' => "1", 'u' => $url, 'n' => $nameqr]);
                }
            }
        } catch (\Illuminate\Database\QueryException $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors)
                ->withInput();
        } catch (\Exception $e) {
            dd($e);
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors)
                ->withInput();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Employe  $employe
     * @return \Illuminate\Http\Response
     */
    public function show(Employe $employe)
    {

        return view('reservations.employes.createschedule', compact('employe', 'type', 'category'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Employe  $employe
     * @return \Illuminate\Http\Response
     */
    public function edit(Employe $employe)
    {
        $type = EmployeType::all();
        $category = EmployeCategory::all();
        $recurrent = RecurrentEmploye::where('employe_id', $employe->id)->first();


        return view('reservations.employes.edit', compact('employe', 'type', 'category', 'recurrent'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Employe  $employe
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Employe $employe)
    {

        try {

            $messages = [
                'mimes'         => 'El archivo debe ser tipo jpeg, jpg o png.',
                'max'           => 'el archivo no debe pesar mas de 5 mb.',
                'uploaded'      => 'El archivo no debe pesar mas de 5 mb.',
                'required'      => 'Este campo es requerido.',
                'required_if'   => 'Este campo es requerido.',
            ];

            $rules = [

                'file'          => 'max:5000|mimes:jpeg,jpg,png', //5000kb image/jpeg image/png
                'file1'         => 'max:5000|mimes:jpeg,jpg,png',
                'name'          => 'required',
                'category'      => 'required',
                'employe_type'  => 'required',
                'time_start'    => 'required_if:employe_type,recurrente',
                'time_end'      => 'required_if:employe_type,recurrente',
                //'date'          => 'required_if:employe_type,eventual',
            ];

            $validator = Validator::make($request->all(), $rules, $messages);

            if ($validator->fails()) {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            } else {

                DB::beginTransaction();

                Employe::editEmploye($request, $employe);

                DB::commit();

                return redirect('employes');
            }
        } catch (\Illuminate\Database\QueryException $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        } catch (\Exception $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Employe  $employe
     * @return \Illuminate\Http\Response
     */
    public function destroy(Employe $employe, Request $request)
    {

        try {
            $employe = Employe::findOrfail($request->id);

            $employe->delete();
            return redirect('employes');
        } catch (\Illuminate\Database\QueryException $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        } catch (\Exception $e) {

            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
                ->withErrors($errors);
        }
    }
}
