<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Validator;
use App\AccessType;
use App\AccessColony;
use Auth;
use DB;
use App\RecurrentEmploye;
use Carbon\Carbon;
use Session;
use QrCode;

class EmployeVisitController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function store(Request $request)
    {
    	try{

            $messages = [

                'required'  => 'Este campo es requerido.',
            ];

            $rules = [

                'date_aprove'  => 'required',
              
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
             
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {

            	//$date = Carbon::now();
                $type = AccessType::where('name',"empleado")->first();
                $recurrente = RecurrentEmploye::where('employe_id',$request->id)->first();
                $acc = AccessColony::where('employe_id',$request->id)->where('date',$request->date_aprove)->whereNull('check_out')->first();
                if(is_null($acc))
                {
                    $acc2 = AccessColony::where('employe_id',$request->id)->where('date',$request->date_aprove)->whereNotNull('check_out')->first();
                    if(is_null($acc2))
                    {
                        $acceso = null;
                    }
                    else
                    {
                        $acceso = null;
                    }
                }
                else
                {
                    $acceso = $acc;
                }
                


                if(is_null($recurrente) && is_null($acceso))
                {
                	$access_id = AccessColony::create([
	                    'date'          => $request->date_aprove,
	                    'employe_id'    => $request->id,
	                    'type'          => $type->id,
	                    'residence_id'  => Auth::user()->street_id,
                	]);

                    $id_visit = $access_id->id;
                    $type_access = 2;
                    $type = $type->id;

                    $date = Carbon::now();
                    $qstr = str_random(8);
                    $qrdate = $request->date_aprove;    
                    $nameqr=  $qstr.$id_visit.$qrdate.'.png';
                    $url = '/qrcodes/'.$nameqr;
                    $path = public_path().$url;

                    QrCode::format('png')->size(500)->merge('/public/assets/image-resources/logoqr.png',.1,false)->generate($id_visit."/".$type_access."/".$type."/".$qrdate, $path);

                    //ID de acceso                     
                    $idacc = $id_visit;  

                    //ID de visitante
                    $idvd = $access_id->visit_id;

                    //ID de la residencia
                    $rid = DB::table('visits')
                        ->select('residence_id')
                        ->where('residence_id',Auth::user()->street_id)
                        ->where('id', '=', $idvd)
                        ->get();

                        $pas1_3 = substr($rid,17);
                        $pas2_3 = str_replace('}]', '', $pas1_3);
                        $ridf = $pas2_3;

                    //Nombre del visitante
                    $nidv = DB::table('access_colonies')
                        ->select('employe_id')

                        ->where('id', '=', $access_id->id)
                        ->get();

                        $pas0_1 = substr($nidv,15);
                        $pas0_2 = str_replace('}]', '', $pas0_1);
                        $idve = $pas0_2;

                    $visit2 = DB::table('employes')
                        ->select('name')
                        ->where('residence_id',Auth::user()->street_id)
                        ->where('id', '=', $idve)
                        ->get();

                        $pas1 = substr($visit2,10);
                        $pas2 = str_replace('"}]', '', $pas1);
                        $nameVisit = $pas2;

                        $nameVisit = str_replace('\u00c1', 'Á', $nameVisit);
                        $nameVisit = str_replace('u00c1', 'Á', $nameVisit);
                        $nameVisit = str_replace('\u00e1', 'á', $nameVisit);
                        $nameVisit = str_replace('u00e1', 'á', $nameVisit);     
                        $nameVisit = str_replace('\u00c9', 'É', $nameVisit);
                        $nameVisit = str_replace('u00c9', 'É', $nameVisit);               
                        $nameVisit = str_replace('\u00e9', 'é', $nameVisit);
                        $nameVisit = str_replace('u00e9', 'é', $nameVisit);
                        $nameVisit = str_replace('\u00cd', 'Í', $nameVisit);
                        $nameVisit = str_replace('u00cd', 'Í', $nameVisit);
                        $nameVisit = str_replace('\u00ed', 'í', $nameVisit);
                        $nameVisit = str_replace('u00ed', 'í', $nameVisit);
                        $nameVisit = str_replace('\u00d3', 'Ó', $nameVisit);
                        $nameVisit = str_replace('u00d3', 'Ó', $nameVisit);
                        $nameVisit = str_replace('\u00f3', 'ó', $nameVisit);
                        $nameVisit = str_replace('u00f3', 'ó', $nameVisit);
                        $nameVisit = str_replace('\u00da', 'Ú', $nameVisit);
                        $nameVisit = str_replace('u00da', 'Ú', $nameVisit);
                        $nameVisit = str_replace('\u00fa', 'ú', $nameVisit);
                        $nameVisit = str_replace('u00fa', 'ú', $nameVisit);
                        $nameVisit = str_replace('\u00d1', 'Ñ', $nameVisit);
                        $nameVisit = str_replace('u00d1', 'Ñ', $nameVisit);
                        $nameVisit = str_replace('\u00f1', 'ñ', $nameVisit);
                        $nameVisit = str_replace('u00f1', 'ñ', $nameVisit);
                        $nameVisit = str_replace('\u00b4', '´', $nameVisit);
                        $nameVisit = str_replace('u00b4', '´', $nameVisit);
                        $nameVisit = str_replace('\u00fc', 'ü', $nameVisit);
                        $nameVisit = str_replace('u00fc', 'ü', $nameVisit);
                        $nameVisit = str_replace('\u00dc', 'Ü', $nameVisit);
                        $nameVisit = str_replace('u00dc', 'Ü', $nameVisit);
                        /*$errors = ['error' => $nameVisit];
                        return redirect()->back()
                            ->withErrors($errors);*/

                    //URL de la colonia
                    $urls = DB::table('domine_colonies')
                        ->select('url')
                        ->get();

                        $pas1_1 = substr($urls,9);
                        $pas2_1 = str_replace('"}]', '', $pas1_1);
                        $pas3_1 = str_replace('\/', '/', $pas2_1);
                        $urlf = $pas3_1;

                    //Calle y numero de la residencia
                    $residence = DB::table('streets')
                        ->where('id', '=', Auth::user()->street_id)
                        ->select('name_street','number')            
                        ->get();
                    
                        $pas1_4 = str_replace('[{"name_street":"', ' ', $residence);
                        $pas2_4 = str_replace('","number":"', ' ', $pas1_4);
                        $pas3_4 = str_replace('"}]', ' ', $pas2_4);
                        $residencef = $pas3_4;

                    //Imagen nuevax
                    $im = imagecreate(600, 200);
                    $bg = imagecolorallocate($im, 255, 255, 255);
                    $textcolor = imagecolorallocate($im, 0, 0, 0);   
                    $textcolora = imagecolorallocate($im, 51, 122, 230);
                    $string1_1 = "QR de uso unico";  
                    $font = 'fonts/arial.ttf';
                    imagettftext($im, 11, 0, 198, 11, $textcolor, $font, $string1_1); 

                    $string1_1 = "Expira el:";                             
                    //imagestring($im, 3, 0, 15, $string1_1, $textcolor);
                    imagettftext($im, 12, 0, 72, 35, $textcolor, $font, $string1_1); 
                    $string2_1 = "".$qrdate;            
                    //imagestring($im, 3, 100, 15, $string2_1, $textcolora);
                    imagettftext($im, 12, 0, 142, 35, $textcolora, $font, $string2_1); 
                    
                    $string1_3 = "Direccion:";                              
                    //imagestring($im, 3, 0, 27, $string1_2, $textcolor);
                    imagettftext($im, 12, 0, 72, 60, $textcolor, $font, $string1_3); 
                    $string2_3 = "".$residencef;
                    //imagestring($im, 3, 100, 27, $string2_2, $textcolora);
                    imagettftext($im, 12, 0, 145, 60, $textcolora, $font, $string2_3); 

                    $string1_4 = "Empleado / Proveedor:";                              
                    //imagestring($im, 3, 0, 38, $string1_2, $textcolor);
                    imagettftext($im, 12, 0, 72, 85, $textcolor, $font, $string1_4); 
                    $string2_4 = "".$nameVisit;
                    //imagestring($im, 3, 93, 38, $string2_2, $textcolora);
                    imagettftext($im, 12, 0, 240, 85, $textcolora, $font, $string2_4); 

                    /*$string1_5 = "Sitio web:";                              
                    //imagestring($im, 3, 0, 49, $string1_2, $textcolor);
                    imagettftext($im, 11, 0, 165, 112, $textcolor, $font, $string1_5); */
                    $string2_5 = "https://residenz.mx/";
                    //imagestring($im, 3, 100, 49, $string2_2, $textcolora);   
                    imagettftext($im, 11, 0, 190, 112, $textcolora, $font, $string2_5);

                    $nu = substr($url,1);
                    
                    $baseimagen = ImageCreate(500,580);
                    $black = ImageColorAllocate($baseimagen, 255, 255, 255);
                    $ts_viewer = ImageCreateFromPng($nu);
                    $union2 = imagecopymerge($baseimagen, $ts_viewer, 0, 20, 0, 0, 500, 600, 100);   
                    $img1 = ImageCreateFromPng('images/logo_residenz_ok.png');           
                    $union3 = imagecopymerge($baseimagen, $im, 0, 455, 0, 0, 500, 200, 100);
                    $union1 = imagecopymerge($baseimagen, $img1, 200, 25, 0, 0, 300, 40, 100);                                         
                    header("Content-Type: image/png");
                    ImagePng($baseimagen, "qrcodes/".$nameqr);

                    $url = '/qrcodes/'.$nameqr;

                    return redirect()->action('EmployeController@index', ['u' => $url,'n' => $nameqr]);
                }
                else if(!is_null($recurrente) && is_null($acceso))
                {

                	
                	$dias = array('Domingo', 'Lunes','Martes','Miercoles','Jueves','Viernes','Sabado','Domingo');
                    $fecha = $dias[date('N', strtotime($request->date_aprove))];

                    if($fecha == "Lunes"){$day = "monday";}
                    if($fecha == "Martes"){$day = "tuesday";}
                    if($fecha == "Miercoles"){$day = "wendsday";}
                    if($fecha == "Jueves"){$day = "thursday";}
                    if($fecha == "Viernes"){$day = "friday";}
                    if($fecha == "Sabado"){$day = "saturday";}
                    if($fecha == "Domingo"){$day = "sunday";}

                   

                    if($recurrente->$day == 1)
                    {
                    	$mensaje = 'El empleado ya tiene autorización para accesar el día '.$request->date_aprove.'.';
                    	Session::flash('message', $mensaje );
                    	return redirect()->action('EmployeController@index');
                    	

                    }
                    else
                    {
                    	$access_id = AccessColony::create([
		                    'date'          => $request->date_aprove,
		                    'employe_id'    => $request->id,
		                    'type'          => $type->id,
		                    'residence_id'  => Auth::user()->street_id,
                		]);
                    }

                    /*$id_visit = $access_id->id;
                    $type_access = 2;
                    $type = $type->id;


                    $date = Carbon::now();
                    $qstr = str_random(8);
                    $qrdate = $request->date_aprove;    
                    $nameqr=  $qstr.$id_visit.$qrdate.'.png';
                    $url = '/qrcodes/'.$nameqr;
                    $path = public_path().$url;

                    QrCode::format('png')->size(500)->merge('/public/assets/image-resources/logoqr.png',.1,false)->generate($id_visit."/".$type_access."/".$type."/".$qrdate, $path);

                    return redirect()->action('EmployeController@index', ['u' => $url,'n' => $nameqr]);*/

                    return redirect('/employes');
                	
                }
                else if(!is_null($recurrente) && !is_null($acceso))
                {
                    $mensaje = 'El empleado ya tiene autorización para accesar el día '.$request->date_aprove.'.';
                        Session::flash('message', $mensaje );
                        return redirect()->action('EmployeController@index');
                }
                else if(!is_null($acceso) && is_null($recurrente))
                {
                	
                    $mensaje = 'El empleado ya tiene autorización para accesar el día '.$request->date_aprove.'.';
                    Session::flash('message', $mensaje );
                    return redirect()->action('EmployeController@index');
	
                }


                //return redirect('/employes');
                
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              
              
                
        } catch (\Exception $e) {
        
            $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
             
              
        }
    }
}
