<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Reservation;
use Auth;
use App\Status;

class EventController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    
    /** EN ESTA FUNCION SE TRAEN TODOS LAS RESERVACIONES EN STATUS DE RESERVA Y SE REGRESARN EN JSON PARA PODER SER LEIDAS POR EL FULLCALENDAR **/
    public function index()
    {

        $status = Status::where('name',"cancelado")->first();
        $reservation = Reservation::join('social_areas', 'social_area','=','social_areas.id')
            ->join('status', 'reservation_status','=','status.id')
            ->join('streets','streets.id','=','residence_id')
            ->where('reservation_status','!=',$status->id)
            // #Boton cancelar en evento gratuito
            ->get(['reservations.id','title','date','time_start','time_end','reservations.color','url_voucher','name_social_area','reservation_status','residence_id','status_name','streets.name_street','streets.number','social_areas.cost','payment_type','status.name as stname']);


            

        return Response()->json($reservation);

    }

}
