<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Reservation;

class EventGuardController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    
    /** EN ESTA FUNCION SE TRAEN TODOS LAS RESERVACIONES EN STATUS DE RESERVA Y SE REGRESARN EN JSON PARA PODER SER LEIDAS POR EL FULLCALENDAR **/
    public function index()
    {
        $reservation = Reservation::join('social_areas', 'social_area','=','social_areas.id')
            ->join('users', 'user_id' ,'=', 'users.id')
            ->join('streets', 'users.street_id','=', 'streets.id')
            ->get(['reservations.id','title','start','end','reservations.color','url_voucher','name_social_area','reservation_status','name','name_street','number']);

        return Response()->json($reservation);
    }
}
