<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\WorkerEvent;
use Auth;

class EventWorkersController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    
    /** EN ESTA FUNCION SE TRAEN TODOS LAS RESERVACIONES EN STATUS DE RESERVA Y SE REGRESARN EN JSON PARA PODER SER LEIDAS POR EL FULLCALENDAR **/
    public function index()
    {
        $reservation = WorkerEvent::join('users', 'user_id', '=', 'users.id')
        	->join('streets', 'street_id','=','streets.id')
        	->join('employes', 'employe_id','=','employes.id')
            ->get(['workers_events.id','title','start','end','color','name_street','number','name_employe']);

        return Response()->json($reservation);
    }
}
