<?php

namespace App\Http\Controllers;

use App\ExpenseCategory;
use Illuminate\Http\Request;
use Auth;
use Session;

class ExpenseConceptController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $expense_concept = ExpenseCategory::all();
        return view('configuration.expense_concepts.index', compact('expense_concept'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('configuration.expense_concepts.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        ExpenseConcept::create([
            'concept_name' => $request->concept_name,
            'concept_description' => $request->concept_description,
        ]);
        return redirect('/configuration/expense_concepts');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ExpenseConcept  $expenseConcept
     * @return \Illuminate\Http\Response
     */
    public function show(ExpenseCategory $expenseCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ExpenseConcept  $expenseConcept
     * @return \Illuminate\Http\Response
     */
    public function edit(ExpenseCategory $expenseCategory)
    {
        return view('configuration.expense_concepts.edit', compact('expenseConcept'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ExpenseConcept  $expenseConcept
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ExpenseCategory $expenseCategory)
    {
        $expenseConcept->update([
            'concept_name' => $request->concept_name,
            'concept_description' => $request->concept_description,
        ]);
        return redirect('/configuration/expense_concepts');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ExpenseConcept  $expenseConcept
     * @return \Illuminate\Http\Response
     */
    public function destroy(ExpenseCategory $expenseCategory)
    {
        $expenseConcept->delete();
        return redirect('/configuration/expense_concepts');
    }
}
