<?php

namespace App\Http\Controllers;

use App\Expense;
use Illuminate\Http\Request;
use App\ExpenseCategory;
use App\PaymentType;
use Session;
use Carbon\Carbon;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use DB;
use Auth;
use App\Month;
use App\Admin;
use App\AccountToPay;
use App\Account;
use App\AccountToPayExpenses;

class ExpenseController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $user = Auth::user();
      
        if($user->can('index', \App\Expense::class ))
        {

            $fecha= $request->input('fecha');
            $categoria = $request->input('categoria');
            
            $expen = DB::table('expenses')
                ->join('payment_types', 'payment_type', '=', 'payment_types.id')
                ->join('expense_categories', 'expense_categories.id', '=', 'category')
                ->join('months', 'expenses.month','=','months.id')
                ->select('expenses.*','payment_types.payment_name', 'expense_categories.category_description','month_year_text')
                ->when($fecha, function ($query) use ($fecha) 
                {
                        
                    return $query->where('accounting_date',$fecha);
                       
                })
                ->when($categoria, function ($query) use ($categoria) 
                {
                        
                    return $query->where('category',$categoria);
                       
                })
                ->whereNull('expenses.deleted_at')
                ->distinct()
                ->orderBy('expenses.created_at','DESC')
                ->paginate(15);

            $por = DB::table('accounts_to_pay')
                ->join('expense_categories', 'expense_categories.id', '=', 'category')
                ->select('accounts_to_pay.*','expense_categories.category_description','accounts_to_pay.id as ids')
                ->where('to_pay','!=',0)
                ->whereNull('accounts_to_pay.deleted_at')
                ->orderBy('deadline','ASC')
                ->paginate(15);


            if($expen->isEmpty())
            {
                $expense = "";
                
            }
            else
            {
                $expense = $expen;
                
            }

            if($por->isEmpty())
            {
                $porpagar = "";
                
            }
            else
            {
                $porpagar = $por;
                
            }
            
            $a = 0;
            $expense_category = ExpenseCategory::orderby('category_description','ASC')->get();
            $payment_type = PaymentType::all();
            $month = Month::all();
            $actual_month = Admin::getActualMonth();
            $c = 0;
            $b = 0;
            $account = Account::all();
            if($request->abierto == 1)
            {
                 $abierto = 1;
            }
            else
            {
                 $abierto = 0;
            }
            

            return view('expenses.index', compact('expense','a','expense_category','payment_type','month','actual_month','porpagar','c','b','account','abierto','fecha','categoria'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
      
        if($user->can('create', \App\Expense::class ))
        {
            $expense_category = ExpenseCategory::all();
            $payment_type = PaymentType::all();
            $month = Month::all();
            $actual_month = Admin::getActualMonth();
            return view('expenses.create', compact('expense_category','payment_type','month','actual_month'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        
    	try{
                $actual_month = Admin::getActualMonth();
                $messages = [

                    'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                    'max'   => 'el archivo no debe pesar mas de 5 mb.',
                    'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                    'required' => 'Este campo es requerido.',
                    'min'      => 'No puede ser 0.'
                ];

                $rules = [

                    'file'      => 'max:5000|mimes:jpeg,jpg,png,pdf', //5000kb image/jpeg image/png
                    'category'  => 'required',
                    'amount'    => 'required|min:0',
                    'deadline'  => 'required',
                ];

                $validator = Validator::make($request->all(),$rules,$messages);


                if ($validator->fails()) {
                    return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {
                    $fecha= Carbon::now();

                    $fileInput= Input::file('file');

                    if (Input::hasFile('file'))
                    {
                        $fileName = $fileInput->getClientOriginalName();
                        $path = public_path().'/uploads/vouchers/expenses/';
                        $url = '/uploads/vouchers/expenses/';
                        $fileType = $fileInput->getMimeType();
                        $fileSize = $fileInput->getClientSize()/1024;

                        if($fileInput->move($path,$fileName))
                        {       
                            
                            AccountToPay::create([

					        	'category'       	=> $request->category,
					        	'description'    	=> $request->description,
					        	'debt'         	    => $request->amount,
                                'to_pay'            => $request->amount,
					        	'capture_date'      => $fecha->toDateString(),
                                'deadline'          => $request->deadline,
					        	

					        ]);
                        }
                    
                    }
                    else
                    {
                    	AccountToPay::create([

					        'category'       	=> $request->category,
					        'description'    	=> $request->description,
					        'debt'              => $request->amount,
                            'to_pay'            => $request->amount,
					        'capture_date'      => $fecha->toDateString(),
                            'deadline'          => $request->deadline,

					   ]);
                    }

                    return redirect()->action('ExpenseController@index', ['abierto' => "1"]);
                }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
        

        
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Expense  $expense
     * @return \Illuminate\Http\Response
     */
    public function show(Expense $expense)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Expense  $expense
     * @return \Illuminate\Http\Response
     */
    public function edit(Expense $expense)
    {
        
        $user = Auth::user();
      
        if($user->can('edit', $expense ))
        {
            $expense_category = ExpenseCategory::all();
            $payment_type = PaymentType::all();
            $month = Month::all();
            return view('expenses.edit', compact('expense','payment_type','expense_category','month'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Expense  $expense
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,  $id)
    {
        
        
        try{

            DB::beginTransaction();

            $user = Auth::user();
            $topay = AccountToPay::findOrfail($request->id);
         
            $actual_month = Admin::getActualMonth();
      
                
                $messages = [

                    'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                    'max'   => 'el archivo no debe pesar mas de 5 mb.',
                    'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                    'required'  => 'Este campo es requerido.',
                ];

                $rules = [

                    'file'              => 'max:5000|mimes:jpeg,jpg,png,pdf', //5000kb image/jpeg image/png
                    /*'account'           => 'required',
                    'payment_type'      => 'required',
                    'accounting_date'   => 'required',*/
                   
                ];

                $validator = Validator::make($request->all(),$rules,$messages);


                if ($validator->fails()) {
                    return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {
                    $fecha= Carbon::now();


                    if (Input::hasFile('file'))
                    {
                        $fileInput= Input::file('file');
                        $fileType = $fileInput->getMimeType();
                        $clave = str_random(5);

                        if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                        { 
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }
                            
                           

                            if($request->imageData)
                            {
                              $data = base64_decode($request->imageData);
                              $im = imagecreatefromstring($data);
                              if ($im !== false) {
                                  
                               
                                  $total = $topay->to_pay - $request->amount;

                                    if($total < 0)
                                    {
                                        $errors = ['pago' => 'Intentas pagar un monto mayor al que debes.'];
                                        return redirect()->back()
                                          ->withErrors($errors);
                                    }

                                    
                                    $topay->update([

                                        'to_pay'   => $total,
                                    ]);

                                    $expense = Expense::create([

                                        'category'          => $topay->category,
                                        'description'       => $topay->description,
                                        'amount'            => $request->amount,
                                        'month'             => $actual_month->id,
                                        'accounting_date'   => $request->accounting_date,
                                        'capture_date'      => $fecha->toDateString(),
                                        'payment_type'      => $request->payment_type,
                                        'account_id'        => $request->account,

                                    ]);

                                    $name_imagen = $expense->id.".".$type;
                                    $url = '/uploads/vouchers/expenses/';
                                    $path = public_path().$url.$name_imagen;
                                    $peso = $request->sizeData*1024;

                                    $expense->update([

                                        'voucher_name'      => $name_imagen,
                                        'url_voucher'       => $url.$name_imagen,
                                        'voucher_type'      => $request->contentType,
                                        'voucher_size'      => $peso,
                                    ]);

                                    header('Content-Type: ',$request->contentData);
                                    imagejpeg($im, $path);

                                    

                                    $pivote = AccountToPayExpenses::create([

                                        'id_expense'        => $expense->id,
                                        'id_account_topay'  => $topay->id,
                                        'paid'              => $request->amount,

                                    ]);

                                    $account = Account::findOrfail($request->account);
                                    $balance = $account->balance - $request->amount;
                                    if($balance < 0)
                                    {
                                        $errors = ['cuenta' =>  'La cuenta que seleccionaste no tiene los fondos para cubrir el pago.'];
                                        return redirect()->back()
                                          ->withErrors($errors);
                                    }
                                    $account->update([

                                        'balance' => $balance,

                                    ]);
          

                                  imagedestroy($im);
                              }
                              else 
                              {
                                  $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                   return redirect()->back()
                                      ->withErrors($errors);
                              }
                            }
                            else 
                            {
                                $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                  return redirect()->back()
                                      ->withErrors($errors);
                            }

                        }
                        else
                        {
                            
                            $path = public_path().'/uploads/vouchers/expenses/';
                            $url = '/uploads/vouchers/expenses/';
                            $fileType = $fileInput->getMimeType();
                            $fileSize = $fileInput->getClientSize()/1024;

                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }
                           

                                  

                                $total = $topay->to_pay - $request->amount;

                                if($total < 0)
                                {
                                    $errors = ['pago' => 'Intentas pagar un monto mayor al que debes.'];
                                    return redirect()->back()
                                      ->withErrors($errors);
                                }

                                
                                $topay->update([

                                    'to_pay'   => $total,
                                ]);

                                $expense = Expense::create([

                                    'category'          => $topay->category,
                                    'description'       => $topay->description,
                                    'amount'            => $request->amount,
                                    'month'             => $actual_month->id,
                                    'accounting_date'   => $request->accounting_date,
                                    'capture_date'      => $fecha->toDateString(),
                                    'payment_type'      => $request->payment_type,
                                    'account_id'        => $request->account,

                                ]);

                                $fileName = $expense->id.".".$type;

                                if($fileInput->move($path,$fileName))
                                { 
                                    $expense->update([

                                        'voucher_name'      => $fileName,
                                        'url_voucher'       => $url.$fileName,
                                        'voucher_type'      => $fileType,
                                        'voucher_size'      => $fileSize,

                                    ]);
                                }

                                $pivote = AccountToPayExpenses::create([

                                    'id_expense'        => $expense->id,
                                    'id_account_topay'  => $topay->id,
                                    'paid'              => $request->amount,

                                ]);

                                $account = Account::findOrfail($request->account);
                                $balance = $account->balance - $request->amount;
                                if($balance < 0)
                                {
                                    $errors = ['cuenta' =>  'La cuenta que seleccionaste no tiene los fondos para cubrir el pago.'];
                                    return redirect()->back()
                                      ->withErrors($errors);
                                }
                                $account->update([

                                    'balance' => $balance,

                                ]);
      
                            
                        }
                    
                    }
                    else
                    {
                        $total = $topay->to_pay - $request->amount;
                        if($total < 0)
                        {
                            $errors = ['pago' =>  'Intentas pagar un monto mayor al que debes.'];
                            return redirect()->back()
                                ->withErrors($errors);   
                        }

                            
                        $topay->update([
 
                            'to_pay'   => $total,
                        ]);

                        $expense = Expense::create([

                            'category'          => $topay->category,
                            'description'       => $topay->description,
                            'amount'            => $request->amount,
                            'month'             => $actual_month->id,
                            'accounting_date'   => $request->accounting_date,
                            'capture_date'      => $fecha->toDateString(),
                            'payment_type'      => $request->payment_type,
                            'account_id'        => $request->account,
                        ]);

                        $pivote = AccountToPayExpenses::create([

                            'id_expense'        => $expense->id,
                            'id_account_topay'  => $topay->id,
                            'paid'              => $request->amount,

                        ]);

                        $account = Account::findOrfail($request->account);
                        $balance = $account->balance - $request->amount;
                        if($balance < 0)
                        {
                            $errors = ['cuenta' => 'La cuenta que seleccionaste no tiene los fondos para cubrir el pago.'];
                            return redirect()->back()
                                ->withErrors($errors);
                        }

                        $account->update([

                            'balance' => $balance,

                        ]);
                    }

                   
                }

            DB::commit();


             return redirect('/expenses');


        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              
                
        } catch (\Exception $e) {
        
            $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              

           
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Expense  $expense
     * @return \Illuminate\Http\Response
     */
    public function destroy( Request $request)
    {
        try{

            $user = Auth::user();
            $topay = AccountToPay::findOrfail($request->id);
            $topay->delete();
            return redirect('/expenses');

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              //throw $e;
                
        } catch (\Exception $e) {
        
            $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              //throw $e;
        }
    }
}
