<?php

namespace App\Http\Controllers;

use App\ExtraordinaryAccount;
use Illuminate\Http\Request;
use App\Street;
use App\AccountReceivable;
use App\IncomeCategory;
use App\Admin;
use App\Config;
use Carbon\Carbon;
use Session;
use Validator;
use Auth;
use App\Status;


class ExtraordinaryAccountController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();
      
        if($user->can('index', \App\Income::class))
        {
            $street = Street::where('empty_residence',0)->get();
            return view('extraordinary_account.index', compact('street'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        
        try{

            $messages = [
                'required'  => 'Este campo es requerido.',
                'required_without' => 'Este campo es requerido, a menos que selecciones la opción todos los residentes.',
                'min'      => 'No puede ser 0.'
            ];

            $rules = [

                'amount' => 'required|min:0',
                'residence'  => 'required_without:allstreet',
                'description' => 'required',
                'deadline'    => 'required',
              
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
             
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {

                $street = Street::where('empty_residence',0)->get();
                $category = IncomeCategory::where('name','extraordinary')->first();
                $actual_month = Admin::getActualMonth();
                $config = Config::find(1);
                $day = $config->days_to_be_debtor;
                $fecha = Carbon::now();
                $status = Status::where('name','activo')->first();
                $d = $fecha->toDateString();

                /*$nuevafecha = strtotime ( '+'.$day.'days' , strtotime ($fecha->toDateString()));
                $nuevafecha = date ( 'Y-m-j' , $nuevafecha );*/


                if($request->allstreet)
                {
                    foreach ($street as $streets) 
                    {
                        $account = AccountReceivable::create([

                            'category'   => $category->id,
                            'debt'       => $request->amount,
                            'to_pay'     => $request->amount,
                            'month'      => $actual_month->id,
                            'residence'  => $streets->id,
                            'deadline'   => $request->deadline,
                            'description' => $request->description,
                            'estatus'      => $status->id,
                        ]);
                    }

                    $m = 'Se ha creado la cuenta extraordinaria para todos los residentes exitosamente.';
                }
                else
                {
                    $account = AccountReceivable::create([

                        'category'   => $category->id,
                        'debt'       => $request->amount,
                        'to_pay'     => $request->amount,
                        'month'      => $actual_month->id,
                        'residence'  => $request->residence,
                        'deadline'   => $request->deadline,
                        'description' => $request->description,
                        'estatus'      => $status->id,
                    ]);

                    $m = 'Se ha creado la cuenta extraordinaria exitosamente.';
                }

                Session::flash('message', $m); 
                return redirect('/extraordinary_accounts');
            }

        } catch (\Illuminate\Database\QueryException $e) {
               
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
             return redirect()->back()
                ->withErrors($errors)
                  ->withInput();
                  throw $e;
      
          } catch (\Exception $e) {
          
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
              return redirect()->back()
                ->withErrors($errors)
                  ->withInput();  
                  throw $e;
          }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ExtraordinaryAccount  $extraordinaryAccount
     * @return \Illuminate\Http\Response
     */
    public function show(ExtraordinaryAccount $extraordinaryAccount)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ExtraordinaryAccount  $extraordinaryAccount
     * @return \Illuminate\Http\Response
     */
    public function edit(ExtraordinaryAccount $extraordinaryAccount)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ExtraordinaryAccount  $extraordinaryAccount
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ExtraordinaryAccount $extraordinaryAccount)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ExtraordinaryAccount  $extraordinaryAccount
     * @return \Illuminate\Http\Response
     */
    public function destroy(ExtraordinaryAccount $extraordinaryAccount)
    {
        //
    }
}
