<?php

namespace App\Http\Controllers;

use App\GuardInfo;
use Illuminate\Http\Request;
use Auth;
use Session;
use App\DayGuard;
use App\GuardSchedule;
use Validator;

class GuardInfoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = Auth::user();
      
        if($user->can('index', \App\GuardInfo::class))
        {
            $guard_info = GuardInfo::paginate(15); 
            $guard_s = GuardSchedule::join('days_guards','guard_schedules.days','=','days_guards.id')->get();
         
            $a = 0;
            $b = 0;
            $day = DayGuard::all();

            if($request->abierto == 1)
            {
                 $abierto = 1;
            }
            else
            {
                 $abierto = 0;
            }

            return view('configuration.guard_infos.index', compact('guard_info','a','day','guard_s','b','abierto'));
        }
        else
        {
            return redirect()->back();
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
        if($user->can('create', \App\GuardInfo::class ))
        {
            $day = DayGuard::all();
            
            return view('configuration.guard_infos.create', compact('day'));
        }
        else
        {
            return redirect()->back();
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        try{

            $messages = [

                'required'  => 'Este campo es requerido.',
            ];

            $rules = [

                'name_guard' => 'required',
                'days'       => 'required',
                'schedule'   => 'required',
               
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) 
            {
                
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {
            
                GuardInfo::createGuardInfo($request);

                return redirect()->action('GuardInfoController@index', ['abierto' => "1"]);
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors)
              ->withInput();
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors)
              ->withInput();
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\GuardInfo  $guardInfo
     * @return \Illuminate\Http\Response
     */
    public function show(GuardInfo $guardInfo)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\GuardInfo  $guardInfo
     * @return \Illuminate\Http\Response
     */
    public function edit(GuardInfo $guardInfo)
    {
        try{

            $user = Auth::user();

            if($user->can('edit', $guardInfo))
            {
                $day = DayGuard::all();
                $schedule = GuardSchedule::where('guard_id',$guardInfo->id)->get();
                $a = 0;
                return view('configuration.guard_infos.edit', compact('guardInfo','day','schedule','a'));
            }
            else
            {
                return redirect()->back();
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\GuardInfo  $guardInfo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, GuardInfo $guardInfo)
    {
        
        try{

            $user = Auth::user();

            if($user->can('edit', $guardInfo))
            {

                GuardInfo::updateGuardInfo($request,$guardInfo);

                return redirect('/configuration/guard_info');
            }
            else
            {
                return redirect()->back();
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           /*$errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);*/
              throw $e;
                
        } catch (\Exception $e) {
        
           /*$errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);*/
               throw $e;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\GuardInfo  $guardInfo
     * @return \Illuminate\Http\Response
     */
    public function destroy(GuardInfo $guardInfo, Request $request)
    {
        try{
                $user = Auth::user();
                if($user->can('edit', $guardInfo))
                {
                    $guard = GuardInfo::findOrfail($request->id);
                    $guard->delete();
                    return redirect('/configuration/guard_info');
                }
                else
                {
                    return redirect()->back();
                }
                
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
        
    }
}
