<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AccessColony;
use App\Employe;
use App\AccessType;
use App\EmployeCategory;
use App\EmployeType;
use Carbon\Carbon;
use Validator;
use App\Guest;
use DB;
use App\Visit;
use App\RecurrentVisit;
use App\RecurrentEmploye;
use Session;

class GuardRegisterVisitController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        

        try{
        
        /*$request->type
        $request->name
        $request->category
        $request->residence
        $request->eventregresar*/
        
            $messages = [
                'required'      => 'Este campo es requerido.',
                'required_if'   => 'Este campo es requerido.',
            ];

            $rules = [

                'type'          => 'required', 
                'nameg'         => 'required_if:type,1',
                'namee'         => 'required_if:type,2',
                'namev'         => 'required_if:type,3',
                'social_area'   => 'required_if:type,1',
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
                  
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {

                DB::beginTransaction();

                    $date = Carbon::now();
                    $tipoacceso = AccessType::findOrfail($request->type);
                    $empleado = AccessType::where('name','empleado')->first();
                    $invitado = AccessType::where('name','invitado')->first();
                    $visitante = AccessType::where('name','visitante')->first();
                    $eventual = EmployeType::where('name','eventual')->first();


                    if($tipoacceso->name == "empleado")
                    {
                                
                        $id = $request->input('idnamee');

                        if(is_null($id))
                        {
                            $employe = Employe::create([

                                'name'          => $request->namee,
                                'category'      => $request->category,
                                'type'          => $eventual->id,
                                'residence_id'  => $request->residence,

                            ]);  


                            $acces = AccessColony::create([

                                'date'          => $date->toDateString(),
                                'employe_id'    => $employe->id,
                                'type'          => $empleado->id,
                                'residence_id'  => $request->residence,
                                'check_in'      => $date,
                                'guard_create'  => 1,
                            ]);

                            
                        }
                        else
                        {
                            
                            

                            $employe = Employe::findOrfail($id);
                            $recurrente = RecurrentEmploye::where('employe_id',$id)->first();
                            $acc = AccessColony::where('employe_id',$id)->where('date',$date->toDateString())->whereNull('check_out')->first();
                            if(is_null($acc))
                            {
                                $acc2 = AccessColony::where('employe_id',$id)->where('date',$date->toDateString())->whereNotNull('check_out')->first();
                                if(is_null($acc2))
                                {
                                    $acceso = null;
                                    $check_in = " ";
                                }
                                else
                                {
                                    $acceso = null;
                                    $check_in = " ";
                                }
                            }
                            else
                            {
                                $acceso = $acc;
                                $check_in = $acc->check_in;
                            }



              
          

                            if(is_null($recurrente) && is_null($acceso))
                            {
                                AccessColony::create([

                                    'date'          => $date->toDateString(),
                                    'employe_id'    => $employe->id,
                                    'type'          => $empleado->id,
                                    'residence_id'  => $request->residence,
                                    'check_in'      => $date,
                                    'guard_create'  => 1,
                                ]);
                            }
                            else if(!is_null($recurrente) && is_null($acceso))
                            {

                                    
                                $dias = array('Domingo', 'Lunes','Martes','Miercoles','Jueves','Viernes','Sabado','Domingo');
                                $fecha = $dias[date('N', strtotime($date->toDateString()))];

                                if($fecha == "Lunes"){$day = "monday";}
                                if($fecha == "Martes"){$day = "tuesday";}
                                if($fecha == "Miercoles"){$day = "wendsday";}
                                if($fecha == "Jueves"){$day = "thursday";}
                                if($fecha == "Viernes"){$day = "friday";}
                                if($fecha == "Sabado"){$day = "saturday";}
                                if($fecha == "Domingo"){$day = "sunday";}

                                if($recurrente->$day == 1)
                                {
                                    if($check_in == " ")
                                    {
                                        $mensaje = 'El empleado ya tiene autorización para accesar el día de hoy.';
                                    }
                                    else
                                    {
                                        $mensaje = 'El empleado ya tiene registrado su acceso.';
                                    }

                                    Session::flash('message', $mensaje );
                                    if($request->eventregresar)
                                    {

                                        return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $request->eventregresar]);
                                    }
                                    else
                                    {
                                        return redirect()->action('DashboardGuardController@index', ['street' => $request->residence]);
                                    }
                                }
                                else
                                {
                                    AccessColony::create([

                                        'date'          => $date->toDateString(),
                                        'employe_id'    => $employe->id,
                                        'type'          => $empleado->id,
                                        'residence_id'  => $request->residence,
                                        'check_in'      => $date,
                                        'guard_create'  => 1,
                                    ]);
                                }
                                    
                            }
                            else if(!is_null($recurrente) && !is_null($acceso))
                            {
                                if($check_in == " ")
                                {
                                    $mensaje = 'El empleado ya tiene autorización para accesar el día de hoy.';
                                }
                                else
                                {
                                    $mensaje = 'El empleado ya tiene registrado su acceso.';
                                }
                                Session::flash('message', $mensaje );
                                if($request->eventregresar)
                                {

                                    return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $request->eventregresar]);
                                }
                                else
                                {
                                    return redirect()->action('DashboardGuardController@index', ['street' => $request->residence]);
                                }
                                
                            }
                            else if(!is_null($acceso) && is_null($recurrente))
                            {  
                                if(is_null($check_in))
                                {
                                    $mensaje = 'El empleado ya tiene autorización para accesar el día de hoy.';
                                }
                                else
                                {
                                    $mensaje = 'El empleado ya tiene registrado su acceso.';
                                }

                                Session::flash('message', $mensaje );
                                if($request->eventregresar)
                                {

                                    return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $request->eventregresar]);
                                }
                                else
                                {
                                    return redirect()->action('DashboardGuardController@index', ['street' => $request->residence]);
                                }
                            }

                        
                            

                        }
                    }
                    else if($tipoacceso->name == "invitado")
                    {

                        
                        $guest = Guest::create([

                            'name_guest'      => $request->nameg,
                            'reservation_id'  => $request->social_area,
                        ]);

                        AccessColony::create([

                            'date'          => $date->toDateString(),
                            'type'          => $invitado->id,
                            'residence_id'  => $request->residence,
                            'event_id'      => $request->social_area,
                            'guest_id'      => $guest->id,
                            'check_in'      => $date,
                            'guard_create'  => 1,
                        ]);
                   

                        
                    }
                    else if($tipoacceso->name == "visitante")
                    {
                       
                        $id = $request->input('idnamev');

                        if(is_null($id))
                        {
                        
                            $visit = Visit::create([

                                'name'          => $request->namev,
                                'type'          => $eventual->id,
                                'residence_id'  => $request->residence,

                            ]);

                            AccessColony::create([

                                'date'          => $date->toDateString(),
                                'type'          => $visitante->id,
                                'visit_id'      => $visit->id,
                                'residence_id'  => $request->residence,
                                'check_in'      => $date,
                                'guard_create'  => 1,

                            ]);
                        }
                        else
                        {

                            $visit = Visit::findOrfail($id);
                            $recurrente = RecurrentVisit::where('visit_id',$id)->first();
                            $acc = AccessColony::where('visit_id',$id)->where('date',$date->toDateString())->whereNull('check_out')->first();
                            if(is_null($acc))
                            {
                                $acc2 = AccessColony::where('visit_id',$id)->where('date',$date->toDateString())->whereNotNull('check_out')->first();
                                if(is_null($acc2))
                                {
                                    $acceso = null;
                                    $check_in = " ";

                                }
                                else
                                {
                                    $acceso = null;
                                    $check_in = " ";
                                }
                            }
                            else
                            {
                                $acceso = $acc;
                                $check_in = $acc->check_in;
                            }


                            
                            
          

                            if(is_null($recurrente) && is_null($acceso))
                            {
                                AccessColony::create([

                                    'date'          => $date->toDateString(),
                                    'type'          => $visitante->id,
                                    'visit_id'      => $visit->id,
                                    'residence_id'  => $request->residence,
                                    'check_in'      => $date,
                                    'guard_create'  => 1,

                                ]);
                            }
                            else if(!is_null($recurrente) && is_null($acceso))
                            {

                                    
                                $dias = array('Domingo', 'Lunes','Martes','Miercoles','Jueves','Viernes','Sabado','Domingo');
                                $fecha = $dias[date('N', strtotime($date->toDateString()))];

                                if($fecha == "Lunes"){$day = "monday";}
                                if($fecha == "Martes"){$day = "tuesday";}
                                if($fecha == "Miercoles"){$day = "wendsday";}
                                if($fecha == "Jueves"){$day = "thursday";}
                                if($fecha == "Viernes"){$day = "friday";}
                                if($fecha == "Sabado"){$day = "saturday";}
                                if($fecha == "Domingo"){$day = "sunday";}

                                if($recurrente->$day == 1)
                                {
                                    if($check_in == " ")
                                    {
                                        $mensaje = 'La visita ya tiene autorización para accesar el día de hoy.';
                                    }
                                    else
                                    {
                                        $mensaje = 'La visita ya tiene registrado su acceso.';
                                    }
                                    
                                    Session::flash('message', $mensaje );
                                    if($request->eventregresar)
                                    {

                                        return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $request->eventregresar]);
                                    }
                                    else
                                    {
                                        return redirect()->action('DashboardGuardController@index', ['street' => $request->residence]);
                                    }
                                }
                                else
                                {
                                    AccessColony::create([

                                        'date'          => $date->toDateString(),
                                        'type'          => $visitante->id,
                                        'visit_id'      => $visit->id,
                                        'residence_id'  => $request->residence,
                                        'check_in'      => $date,
                                        'guard_create'  => 1,

                                    ]);
                                }
                                    
                            }
                            else if(!is_null($recurrente) && !is_null($acceso))
                            {
                                if($check_in == " ")
                                {
                                    $mensaje = 'La visita ya tiene autorización para accesar el día de hoy.';
                                }
                                else
                                {
                                    $mensaje = 'La visita ya tiene registrado su acceso.';
                                }

                                Session::flash('message', $mensaje );
                                if($request->eventregresar)
                                {

                                    return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $request->eventregresar]);
                                }
                                else
                                {
                                    return redirect()->action('DashboardGuardController@index', ['street' => $request->residence]);
                                }
                                
                            }
                            else if(!is_null($acceso) && is_null($recurrente))
                            {  
                                if(is_null($check_in))
                                {
                                    $mensaje = 'La visita ya tiene autorización para accesar el día de hoy.';
                                }
                                else
                                {
                                    $mensaje = 'La visita ya tiene registrado su acceso.';
                                }
                                Session::flash('message', $mensaje );
                                if($request->eventregresar)
                                {

                                    return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $request->eventregresar]);
                                }
                                else
                                {
                                    return redirect()->action('DashboardGuardController@index', ['street' => $request->residence]);
                                }
                            }

                            
                        }
                       
                    }
                 DB::commit();

                    if($request->eventregresar)
                    {

                        return redirect()->action('DashboardGuardController@index', ['backsearchevent' => $request->eventregresar]);
                    }
                    else
                    {
                        return redirect()->action('DashboardGuardController@index', ['street' => $request->residence]);
                    }
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           /*$errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);*/
              throw $e;
        
                
        } catch (\Exception $e) {
        
            /*$errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);*/
              throw $e;
             
        }
        

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
