<?php

namespace App\Http\Controllers;

use App\IncomeCategory;
use Illuminate\Http\Request;
use Auth;
use Session;

class IncomeConceptController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $income_concept = IncomeCategory::all();
        return view('configuration.income_concepts.index', compact('income_concept'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('configuration.income_concepts.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        IncomeCategory::create([
            'concept_name' => $request->concept_name,
            'concept_description' => $request->concept_description,
        ]);

        return redirect('/configuration/income_concepts');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\IncomeConcept  $incomeConcept
     * @return \Illuminate\Http\Response
     */
    public function show(IncomeCategory $incomeCategory)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\IncomeConcept  $incomeConcept
     * @return \Illuminate\Http\Response
     */
    public function edit(IncomeCategory $incomeCategory)
    {
        return view('configuration.income_concepts.edit', compact('incomeConcept'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\IncomeConcept  $incomeConcept
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, IncomeCategory $incomeCategory)
    {
        $incomeConcept->update([
            'concept_name' => $request->concept_name,
            'concept_description' => $request->concept_description,
        ]);
        return redirect('/configuration/income_concepts');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\IncomeConcept  $incomeConcept
     * @return \Illuminate\Http\Response
     */
    public function destroy(IncomeCategory $incomeCategory)
    {
        $incomeConcept->delete();
        return redirect('/configuration/income_concepts');
    }
}
