<?php

namespace App\Http\Controllers;

use App\Payment;
use Illuminate\Http\Request;
use App\IncomeCategory;
use App\Street;
use Carbon\Carbon;
use DB;
use Auth;
use App\PaymentType;
use App\Month;
use App\AccountInfo;
use App\IncomeResident;
use Session;
use App\IncomeLate;
use App\AccountReceivable;
use App\Status;
use App\Report;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use App\Account;
use App\Admin;


class IncomeController extends Controller
{
    
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        

        $user = Auth::user();
      
        if($user->can('index', \App\Income::class))
        {
            $status = Status::where('name','aprobado')->first();
            $status2 = Status::where('name','pendiente')->first();
            $status3 = Status::where('name','confirmar')->first();
            $status4 = Status::where('name','adelantado')->first();
            $calle = $request->street;

            //Filtro de Ingresos por fecha
            $fecha1 = $request->input('fecha1');
            $fecha2 = $request->input('fecha2');

            if (isset($_GET["street"]))
            {
                $calle = $request->street;

                if(empty($calle) && empty($fecha1) && empty($fecha2))
                {
                    $income = Payment::join('streets','streets.id','=','residence')
                    ->join('payment_types','payment_types.id','=','payment_type')
                    ->join('months','payments.month','=','months.id')
                    ->join('status','status', '=','status.id')
                    ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status.name as stname','status_name')
                    ->where(function ($query) use ($status,$status4) {
                      $query->where('status',$status->id)
                            ->orwhere('status',$status4->id);
                      })
                    ->orderby('created_at','DESC')
                    ->paginate(10);
                }
                elseif($fecha1 && is_null($calle) && is_null($fecha2)){                    

                    $income = Payment::join('streets','streets.id','=','residence')
                        ->join('payment_types','payment_types.id','=','payment_type')
                        ->join('months','payments.month','=','months.id')
                        ->join('status','status', '=','status.id')
                        ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status.name as stname','status_name')
                        ->where(function ($query) use ($status,$status4) {
                          $query->where('status',$status->id)
                                ->orwhere('status',$status4->id);
                          })
                        ->where('payment_date',$fecha1)
                        ->orderby('created_at','DESC')
                        ->paginate(10);

                    $url = \Request::url();
                    $u = $url.'?street='.$calle;                  
                    $income->withPath($u);
                }elseif($fecha2 && is_null($fecha1) && is_null($calle)){                     

                    $income = Payment::join('streets','streets.id','=','residence')
                        ->join('payment_types','payment_types.id','=','payment_type')
                        ->join('months','payments.month','=','months.id')
                        ->join('status','status', '=','status.id')
                        ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status.name as stname','status_name')
                        ->where(function ($query) use ($status,$status4) {
                          $query->where('status',$status->id)
                                ->orwhere('status',$status4->id);
                          })
                        ->where('capture_date',$fecha2)
                        ->orderby('created_at','DESC')
                        ->paginate(10);

                    $url = \Request::url();
                    $u = $url.'?street='.$calle;                  
                    $income->withPath($u);
                }elseif($fecha2 && $fecha1 && is_null($calle)){
                    
                    $income = Payment::join('streets','streets.id','=','residence')
                        ->join('payment_types','payment_types.id','=','payment_type')
                        ->join('months','payments.month','=','months.id')
                        ->join('status','status', '=','status.id')
                        ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status.name as stname','status_name')
                        ->where(function ($query) use ($status,$status4) {
                            $query->where('status',$status->id)
                                ->orwhere('status',$status4->id);
                          })
                        ->where(function ($query) use ($fecha1,$fecha2) {
                            $query->where('payment_date',$fecha1)
                                ->where('capture_date',$fecha2);
                        })
                        ->orderby('created_at','DESC')
                        ->paginate(10);

                    $url = \Request::url();
                    $u = $url.'?street='.$calle;                  
                    $income->withPath($u);
                }elseif($fecha1 && $calle && is_null($fecha2)){
                    $s = Street::findOrfail($calle);  

                    $income = Payment::join('streets','streets.id','=','residence')
                        ->join('payment_types','payment_types.id','=','payment_type')
                        ->join('months','payments.month','=','months.id')
                        ->join('status','status', '=','status.id')
                        ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status.name as stname','status_name')
                        ->where(function ($query) use ($status,$status4) {
                            $query->where('status',$status->id)
                                ->orwhere('status',$status4->id);
                          })
                        ->where(function ($query) use ($fecha1,$s) {
                            $query->where('payment_date',$fecha1)
                                ->where('residence',$s->id);
                        })
                        ->orderby('created_at','DESC')
                        ->paginate(10);

                    $url = \Request::url();
                    $u = $url.'?street='.$calle;                  
                    $income->withPath($u);
                }elseif($fecha2 && $calle && is_null($fecha1)){
                    $s = Street::findOrfail($calle);  

                    $income = Payment::join('streets','streets.id','=','residence')
                        ->join('payment_types','payment_types.id','=','payment_type')
                        ->join('months','payments.month','=','months.id')
                        ->join('status','status', '=','status.id')
                        ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status.name as stname','status_name')
                        ->where(function ($query) use ($status,$status4) {
                            $query->where('status',$status->id)
                                ->orwhere('status',$status4->id);
                          })
                        ->where(function ($query) use ($fecha2,$s) {
                            $query->where('capture_date',$fecha2)
                                ->where('residence',$s->id);
                        })
                        ->orderby('created_at','DESC')
                        ->paginate(10);

                    $url = \Request::url();
                    $u = $url.'?street='.$calle;                  
                    $income->withPath($u);
                }elseif($fecha2 && $calle && $fecha1){
                    $s = Street::findOrfail($calle);  

                    $income = Payment::join('streets','streets.id','=','residence')
                        ->join('payment_types','payment_types.id','=','payment_type')
                        ->join('months','payments.month','=','months.id')
                        ->join('status','status', '=','status.id')
                        ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status.name as stname','status_name')
                        ->where(function ($query) use ($status,$status4) {
                            $query->where('status',$status->id)
                                ->orwhere('status',$status4->id);
                          })
                        ->where(function ($query) use ($fecha1,$fecha2,$s) {
                            $query->where('payment_date',$fecha1)
                                ->where('capture_date',$fecha2)
                                ->where('residence',$s->id);
                        })
                        ->orderby('created_at','DESC')
                        ->paginate(10);

                    $url = \Request::url();
                    $u = $url.'?street='.$calle;                  
                    $income->withPath($u);
                }elseif($calle && is_null($fecha1) && is_null($fecha1))
                {
                    $s = Street::findOrfail($calle);                   

                    $income = Payment::join('streets','streets.id','=','residence')
                        ->join('payment_types','payment_types.id','=','payment_type')
                        ->join('months','payments.month','=','months.id')
                        ->join('status','status', '=','status.id')
                        ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status.name as stname','status_name')
                        ->where(function ($query) use ($status,$status4) {
                          $query->where('status',$status->id)
                                ->orwhere('status',$status4->id);
                          })
                        ->where('residence',$s->id)
                        ->orderby('created_at','DESC')
                        ->paginate(10);

                    $url = \Request::url();
                    $u = $url.'?street='.$calle;                  
                    $income->withPath($u);
                }

                
            }
            else
            {
                 $income = Payment::join('streets','streets.id','=','residence')
                    ->join('payment_types','payment_types.id','=','payment_type')
                    ->join('months','payments.month','=','months.id')
                    ->join('status','status', '=','status.id')
                    ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status.name as stname','status_name')
                    ->where(function ($query) use ($status,$status4) {
                      $query->where('status',$status->id)
                            ->orwhere('status',$status4->id);
                      })
                    ->orderby('created_at','DESC')
                    ->paginate(10);
            }

            $incomes_resident = Payment::join('streets','streets.id','=','residence')
                ->join('payment_types','payment_types.id','=','payment_type')
                ->join('months','payments.month','=','months.id')
                ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','payment_types.id as ipayt')
                ->where('status',$status2->id)
                ->orWhere('status',$status3->id)
                ->orderby('created_at','DESC')
                ->paginate(10);

         

            $account = Account::all();

            $a = 0;
            $b = 0;
            $c = 0;
            $d = 0;
            $v = 0;
            $street = Street::all();
            $payment_type = PaymentType::all();
            if($request->abierto == 1)
            {
                 $abierto = 1;
            }
            else
            {
                 $abierto = 0;
            }

            if($request->regreso == 1) 
            {
                $regreso = 1;
            }
            else
            {
                $regreso = 0;
            }

            $modal= $request->input('modal');
            $debt = $request->input('debt');
            $resident = $request->input('resident');
            $pago = $request->input('pago');
            $monto = $request->input('monto');
            $id = $request->input('id');
            $tipopago = $request->input('tipopago');
            $cuenta = $request->input('cuenta');
            

            return view('incomes.index', compact('income','voucher','incomes_resident','a','b','c','street','payment_type','account','d','v','abierto','regreso','modal','debt','resident','pago','monto','id','tipopago','cuenta','fecha1','fecha2','calle'));
        }
        else
        {
            return redirect('/home');
        }
        
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
      
        if($user->can('create', \App\Income::class))
        {
            $income_category = IncomeCategory::all();
            $resident = Street::getStreetwithUser();

            $payment_type = PaymentType::all();
            $month = Month::all();
            $fecha= Carbon::now();
            $t = $fecha->toDateString();
            
            $year = substr($t, -10,4);
            $mon = substr($t, -5,2);
            $actual_month = Month::where('year',$year)->where('month',$mon)->first();

            $amount = 0;
            $month = Month::all();
            $incomes_residents = "";

            return view('incomes.create', compact('income_category','resident','payment_type','month','actual_month', 'amount','incomes_resident'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
       //dd($request->all());

        $messages = [
            'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
            'max'   => 'el archivo no debe pesar mas de 5 mb.',
            'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
            'required'  => 'Este campo es requerido.',
            'min'      => 'No puede ser 0.',
        ];

        $rules = [
            'file'          => 'max:5000|mimes:jpeg,jpg,png,pdf',//5000kb image/jpeg image/png
            'residence'     => 'required',
            'amount'        => 'required|min:0',
            'payment_type'  => 'required',
            'payment_date'  => 'required',
            //'accountid'     => 'required',
          
        ];

        $validator = Validator::make($request->all(),$rules,$messages);

        if ($validator->fails()) {
         
            
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        else
        {
          try{

              DB::beginTransaction();
    
                  $pays = Payment::createPay($request,1);

              DB::commit();

              return redirect()->action('IncomeController@index', ['abierto' => "1"]);

          } catch (\Illuminate\Database\QueryException $e) {
               
             $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
             return redirect()->back()
                ->withErrors($errors)
                  ->withInput();
                  
             
      
          } catch (\Exception $e) {
          
              $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
              return redirect()->back()
                ->withErrors($errors)
                  ->withInput(); 
                 
                  
          }
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Income  $income
     * @return \Illuminate\Http\Response
     */
    public function show(Income $income)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Income  $income
     * @return \Illuminate\Http\Response
     */
    public function edit(Payment $payment,$id)
    {
        try{
                /*$user = Auth::user();
                if($user->can('edit', $income))
                {*/
                $payment = Payment::findOrfail($id);
                $resident = Street::getStreetwithUser();
                $payment_type = PaymentType::all();
                $month = Month::all();
                $status = Status::where('name','aprobado')->first();



                $history = Payment::join('streets','streets.id','=','residence')
                    ->join('payment_types','payment_types.id','=','payment_type')
                    ->join('months','payments.month','=','months.id')
                    ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids')
                    ->where('status',$status->id)
                    ->where('streets.id', $payment->residence)
                    ->paginate(15);
                   
                return view('incomes.edit', compact('payment','resident','payment_type','month','history'));
                /*}
                else
                {
                    return redirect('/home');
                }*/
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Income  $income
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Payment $payment,$id)
    {
        try{
            
            /*$user = Auth::user();
            if($user->can('update', $income))
            { */ 
                $payment = Payment::findOrfail($id);
                Payment::updatePay($request,$payment);
                return redirect('/incomes');
            /*}
            else
            {
                return redirect('/home');
            }*/

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Income  $income
     * @return \Illuminate\Http\Response
     */
    public function destroy(Payment $payment, Request $request)
    {
        try{
                $user = Auth::user();
                /*if($user->can('delete', $payment))
                {*/
                    $incomes = Payment::findOrfail($request->id);
                    $incomes->delete();
                    return redirect('/incomes');
                /*}
                else
                {
                    return redirect('/home');
                }*/
                
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }
}
