<?php

namespace App\Http\Controllers;

use App\Payment;
use Illuminate\Http\Request;
use Auth;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use App\IncomeCategory;
use App\Street;
use App\PaymentType;
use App\Month;
use App\AccountInfo;
use Carbon\Carbon;
use App\Income;
use Session;
use DB;
use App\Status;
use App\Report;
use App\Account;
use App\Admin;
use App\Config;
use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Mail\PayMail;
use Illuminate\Support\Facades\Mail;


class IncomeResidentController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //Filtro de Ingresos por fecha
        $fecha1 = $request->input('fecha1');
        $fecha2 = $request->input('fecha2');

        //$income = IncomeResident::where('user_id', Auth::id())->paginate(15);
        /*$income = Payment::join('streets','streets.id','=','residence')
            ->join('payment_types','payment_types.id','=','payment_type')
            ->join('months','payments.month','=','months.id')
            ->join('status','status', '=','status.id')
            ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status_name','status.name as stname')
            ->where('residence',Auth::user()->street_id)
            ->when($fecha1, function ($query) use ($fecha1,$fecha2) {
                            
                if(is_null($fecha2))
                {
                    return $query->where('payment_date','>=',$fecha1);
                }
                else
                {
                        
                    return $query->whereBetween('payment_date',[$fecha1,$fecha2]);
                        
                }
                
            })
            ->when($fecha2, function ($query) use ($fecha1,$fecha2) {
                    
                if(is_null($fecha1))
                {   
                    return $query->where('payment_date','<=',$fecha2);
                }
                
            })
            ->orderby('payments.created_at', 'DESC')
            ->paginate(10);*/

            if(empty($fecha1) && empty($fecha2))
            {
                $income = Payment::join('streets','streets.id','=','residence')
                    ->join('payment_types','payment_types.id','=','payment_type')
                    ->join('months','payments.month','=','months.id')
                    ->join('status','status', '=','status.id')
                    ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status_name','status.name as stname')
                    ->where('residence',Auth::user()->street_id)
                    ->orderby('created_at','DESC')
                    ->paginate(10);
            }elseif($fecha1 && is_null($fecha2)){                    

                $income = Payment::join('streets','streets.id','=','residence')
                    ->join('payment_types','payment_types.id','=','payment_type')
                    ->join('months','payments.month','=','months.id')
                    ->join('status','status', '=','status.id')
                    ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status_name','status.name as stname')
                    ->where('residence',Auth::user()->street_id)
                    ->where('payment_date',$fecha1)
                    ->orderby('created_at','DESC')
                    ->paginate(10);

                
            }elseif($fecha2 && is_null($fecha1)){                     

                $income = Payment::join('streets','streets.id','=','residence')
                    ->join('payment_types','payment_types.id','=','payment_type')
                    ->join('months','payments.month','=','months.id')
                    ->join('status','status', '=','status.id')
                    ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status_name','status.name as stname')
                    ->where('residence',Auth::user()->street_id)
                    ->where('capture_date',$fecha2)
                    ->orderby('created_at','DESC')
                    ->paginate(10);

                
            }elseif($fecha2 && $fecha1){
                
                $income = Payment::join('streets','streets.id','=','residence')
                    ->join('payment_types','payment_types.id','=','payment_type')
                    ->join('months','payments.month','=','months.id')
                    ->join('status','status', '=','status.id')
                    ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','status_name','status.name as stname')
                    ->where('residence',Auth::user()->street_id)
                    ->where(function ($query) use ($fecha1,$fecha2) {
                        $query->where('payment_date',$fecha1)
                            ->where('capture_date',$fecha2);
                    })
                    ->orderby('created_at','DESC')
                    ->paginate(10);

                
            }

        $status2 = Status::where('name','pendiente')->first();
        $status3 = Status::where('name','confirmar')->first();
        $incomes_resident = Payment::join('streets','streets.id','=','residence')
                ->join('payment_types','payment_types.id','=','payment_type')
                ->join('months','payments.month','=','months.id')
                ->select('payments.*','payment_name','month_year_text','name_street','number','payments.id as ids','payment_types.id as ipayt')
                ->where('residence',Auth::user()->street_id)
                ->where(function ($query) use ($status2,$status3) {
                      $query->where('status',$status2->id)
                            ->orwhere('status',$status3->id);
                  })
                ->orderby('created_at','DESC')
                ->paginate(10);

        $fecha= Carbon::now();
        $t = $fecha->toDateString();
                
        $year = substr($t, -10,4);
        $mon = substr($t, -5,2);
                
        $user = Auth::user();
        $income_category = IncomeCategory::all();
        $resident = Street::findOrfail($user->street_id);
        $payment_type = PaymentType::all();
                
        $actual_month = Month::where('year',$year)->where('month',$mon)->first();
        $amount = "";
        $month = Month::all();
        $a = 0;
        if($request->abierto == 1)
        {
            $abierto = 1;
        }
        else
        {
            $abierto = 0;
        }
        $d = 0;
        $b = 0;
        $c = 1;

        return view('incomes.residentincomes.index', compact('income','amount','month','actual_month','payment_type','resident','income_category','a','abierto','incomes_resident','d','b','c','fecha1','fecha2'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        try{
            $user = Auth::user();
          
            if($user->can('create', \App\IncomeResident::class))
            {
                $fecha= Carbon::now();
                $t = $fecha->toDateString();
                
                $year = substr($t, -10,4);
                $mon = substr($t, -5,2);
                
                $user = Auth::user();
                $income_category = IncomeCategory::all();
                $resident = Street::findOrfail($user->street_id);
                $payment_type = PaymentType::all();
                
                $actual_month = Month::where('year',$year)->where('month',$mon)->first();
                $amount = "";
                $month = Month::all();
                
                return view('incomes.residentincomes.create', compact('income_category','resident','payment_type','month','amount','actual_month'));
            }
            else
            {
                return redirect('/home');
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $messages = [
            'mimes' => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
            'max'   => 'el archivo no debe pesar mas de 5 mb.',
            'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
            'required'  => 'Este campo es requerido.',
            'min'      => 'No puede ser 0.',
        ];

        $rules = [
            'file'          => 'max:5000|mimes:jpeg,jpg,png,pdf', //5000kb image/jpeg image/png
            'amount'        => 'required|min:0',
            'payment_type'  => 'required',
            'payment_date'  => 'required',
        ];

        $validator = Validator::make($request->all(),$rules,$messages);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        else
        {
          
          try{

              

              DB::beginTransaction();
    
                  $pays = Payment::createPay($request,2);

              DB::commit();


               return redirect()->action('IncomeResidentController@index', ['abierto' => "1"]);
                  

          } catch (\Illuminate\Database\QueryException $e) {
               
             $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
             return redirect()->back()
                ->withErrors($errors)
                ->withInput();
                  
          } catch (\Exception $e) {
          
              $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
              return redirect()->back()
                ->withErrors($errors)
                ->withInput();
          }

      }




    }

    /**
     * Display the specified resource.
     *
     * @param  \App\IncomeResident  $incomeResident
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\IncomeResident  $incomeResident
     * @return \Illuminate\Http\Response
     */
    public function edit(Payment $payment, $id)
    {
        

        try{
            $user = Auth::user();
            /*if($user->can('edit', $incomeResident))
            {*/
                $incomeR = Payment::findOrfail($id);
                $income_category = IncomeCategory::all();
                $resident = Street::findOrfail($incomeR->residence);
                $payment_type = PaymentType::all();
                $month = Month::all();
                $street = Street::findOrfail($incomeR->residence);
                return view('incomes.residentincomes.edit', compact('income_category','resident','payment_type','month','incomeR','street'));
            /*}
            else
            {
                return redirect('/home');
            }*/
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\IncomeResident  $incomeResident
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Payment $payment,$id)
    {
        

            try{
                
                DB::beginTransaction();

                    $user = Auth::user();
                    $income = Payment::findOrfail($request->id);
                    $debt = Report::getDebtResidentAdministratorWithoutEvents($income->residence);
                    $fecha = Carbon::now();
                    $actual_month = Admin::getActualMonth();
                    $sta_rechazado = Status::where('name','rechazada')->first(); 
                    $sta_adelantado = Status::where('name','adelantado')->first();
                    $sta_aprobado = Status::where('name','aprobado')->first();
                    if($income->status == $sta_adelantado->id || $income->status == $sta_rechazado->id || $income->status == $sta_aprobado->id)
                    {
                              
                        if($income->status == $sta_adelantado->id || $income->status == $sta_rechazado->id)
                        {
                            $mensaje = 'El pago ya había sido rechazado, y no se pudo aprobar.';
                            Session::flash('message', $mensaje );
                            return redirect('/incomes');

                        }
                        else
                        {
                            $mensaje = 'El pago ya había sido aprobado.';
                            Session::flash('message', $mensaje );
                            return redirect('/incomes');
                        }
                        
                              
                    }
                    else
                    {



                      if($request->pagos_adelantados == 1)
                      {
                            
                          $account = Account::findOrfail($request->accountid);

                          if($debt > 0)
                          {
                              $status = Status::where('name','aprobado')->first(); 
                              $pay = Payment::create([
                        
                                  'amount'        => $debt,
                                  'description'   => $income->description,
                                  'residence'     => $income->residence,
                                  'capture_date'  => $fecha->toDateString(),
                                  'payment_date'  => $income->payment_date,
                                  'payment_type'  => $request->paytipo,
                                  'name_file'     => $income->name_file,
                                  'url_file'      => $income->url_file,
                                  'type_file'     => $income->type_file,
                                  'size_file'     => $income->size_file,
                                  'month'         => $actual_month->id,
                                  'status'        => $status->id,
                                  'account_id'    => $request->accountid,
                               

                              ]);

                              $balance = $account->balance + $debt;
                              $account->update([

                                  'balance' => $balance,

                              ]);

                              Payment::payAccount($income->residence,$debt,$pay->id);
                              $total = $income->amount - $debt;



                          }
                          else
                          {
                              $total = $income->amount;
                          }


                            $actual_month = Admin::getActualMonth();
                            $status = Status::where('name','adelantado')->first();
      
                            $income->update([

                                'status'       => $status->id,
                                'amount'       => $total,
                                'payment_type' => $request->paytipo,
                                'account_id'    => $request->accountid,

                            ]);
              
                            $balance = $account->balance + $income->amount;
                            $account->update([

                                'balance' => $balance,

                            ]);
                            $config = Config::all();
                            foreach ($config as $configs) 
                            {
                                $send = $configs->send_mail;
                            }

                            if($send == 1)
                            {
                                $user = User::where('street_id',$income->residence)->first();
                                if(is_null($user))
                                {

                                }
                                else
                                {
                                    $tipo_pago = PaymentType::findOrFail($income->payment_type);
                                    $pago = 1;
                                    Mail::to($user->email)->send(new PayMail($user,$income,$tipo_pago,$pago));
                                }
                                
                            }
                            
                      }
                      else
                      {

                          
                             
                          
                              if($debt < $income->amount)
                              {
                                  //$errors = ['deuda' => 'Estas excediendo el monto del saldo del residente.El saldo es de $'.$debt.'. Si el saldo es de $0 rechaza el pago.'];
                                  $total = $income->amount - $debt;
                                  $street = Street::findOrfail($income->residence);
                                  $cuenta = $request->account;
                                  return redirect()->action('IncomeController@index', ['modal' => 1,'debt' => $debt, 'resident' => $street->name_street." ".$street->number, 'monto' => $income->amount, 'pago' => $total,'id' => $income->id,'tipopago' => $request->paytipo,'cuenta' => $cuenta]);
                                  /*return redirect()->back()
                                      ->withErrors($errors)
                                      ->withInput($debt);*/
                              }
                              else
                              {
                          
                                  
                                  $status = Status::where('name','aprobado')->first(); 
                                  $status2 = Status::where('name',"rechazada")->first();

                                  if($income->status == $status2->id)
                                  {
                                      
                                      $mensaje = 'El pago ya había sido rechazado, y no se pudo aprobar.';
                                      Session::flash('message', $mensaje );
                                      return redirect('/incomes');
                                      
                                  }


                                  $income->update([

                                      'status'        => $status->id,
                                      'payment_type'  => $request->paytipo,
                                      'account_id'    => $request->account,

                                  ]);

                                  Payment::payAccount($income->residence,$income->amount,$income->id);

                                  $account = Account::findOrfail($request->account);
                                  $balance = $account->balance + $income->amount;
                                  $account->update([

                                    'balance' => $balance,

                                  ]);
                              }
                          


                      }
                    }

                    


                    /////

                    

                DB::commit();

                return redirect('/incomes');
 

            } catch (\Illuminate\Database\QueryException $e) {
                 
              $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
               return redirect()->back()
                  ->withErrors($errors)
                  ->withInput();
                
                  
                  
                    
            } catch (\Exception $e) {
            
              $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
                return redirect()->back()
                  ->withErrors($errors)
                  ->withInput();
                  
                
                 
            }
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\IncomeResident  $incomeResident
     * @return \Illuminate\Http\Response
     */
    public function destroy(Payment $payment,Request $request)
    {
        try{
                /*$user = Auth::user();
                if($user->can('delete', $incomeResident))
                {*/
                    $status = Status::where('name',"rechazada")->first();
                    $status2 = Status::where('name','aprobado')->first(); 
                    $status3 = Status::where('name','adelantado')->first();
                    $incomes = Payment::findOrfail($request->id);
                    if($incomes->status == $status2->id || $incomes->status == $status3->id)
                    {
                        if($request->user)
                        {
                            $mensaje = 'El pago ya había sido aprobado, y no se pudo rechazar.';
                            Session::flash('message', $mensaje );
                            return redirect('/incomes/residents');
                        }
                        else
                        {
                            $mensaje = 'El pago ya había sido aprobado, y no se pudo rechazar.';
                            Session::flash('message', $mensaje );
                            return redirect('/incomes');
                        }
                    }


                    $incomes->update([

                        'status' => $status->id,
                        'reason_reject'  => $request->reason_reject
                    ]);
                    
                    if($request->user)
                    {
                        return redirect('/incomes/residents');
                    }
                    else
                    {
                        return redirect('/incomes');
                    }
                    
                /*}
                else
                {
                    return redirect('/home');
                }*/
                
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors)
              ->withInput();
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors)
              ->withInput();
        }
    }
}
