<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\MemberColony;
use App\Colony;
use App\Account;
use App\AccountType;
use App\GuardInfo;
use App\GuardSchedule;

class InfoController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    	$type = AccountType::where('name','banco')->first();
    	$accounts= Account::where('account_type', $type->id)->get(['accounts.id as ids','bank_name','number_account','branch_office','CLABE','card','email']);
        if($accounts->isEmpty())
        {
            $account = $accounts->toArray();
        }
        else
        {
            $account = $accounts;
        }

        $c = Colony::all();
        $member = MemberColony::all();

        if($c->isEmpty())
        {$colony = $c->toArray();}else{$colony = $c;}

        $guard_info = GuardInfo::paginate(15); 
        $guard_s = GuardSchedule::join('days_guards','guard_schedules.days','=','days_guards.id')->get();
        $a = 0;

        return view('configuration.account_infos.index', compact('account','colony','member','guard_info','guard_s','a'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
