<?php

namespace App\Http\Controllers;

use App\LogoColony;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use Auth;
use Session;


class LogoColonyController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();
      
        if($user->can('index', \App\LogoColony::class))
        {
            $lcolony = LogoColony::all();
            if($lcolony->isEmpty())
            {
                $logo = $lcolony->toArray();
            }
            else
            {
                $logo = $lcolony ;
            }
            return view('configuration.logo_colonies.index', compact('logo'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
      
        if($user->can('index', \App\LogoColony::class))
        {
            return view('configuration.logo_colonies.create');
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try{
                $messages = [

                    'required' => 'Es necesario cargar un archivo.',
                    'mimes' => 'El archivo debe ser tipo jpeg, jpg o png.',
                    'max'   => 'El archivo no debe pesar mas de 5 mb.',
                    'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                ];

                $rules = [
                     'file' => 'required|max:5000|mimes:jpeg,jpg,png', //5000kb image/jpeg image/png
                ];

                $validator = Validator::make($request->all(),$rules,$messages);

                if ($validator->fails()) {
                    return redirect()->action('ConfigMasterController@index',['i' => 1])
                                ->withErrors($validator)
                                ->withInput();
                }
                else
                {

                    if (Input::hasFile('file'))
                    {

                        $fileInput= Input::file('file');
                        $fileType = $fileInput->getMimeType();
                        $clave = str_random(5);

                        if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                        { 
                            
                            $name_imagen = $clave.$request->imageName;
                            $url = '/uploads/logo/';
                            $path = public_path().$url.$name_imagen;
                            $peso = $request->sizeData*1024;

                            if($request->imageData)
                            {
                              $data = base64_decode($request->imageData);
                              $im = imagecreatefromstring($data);
                              if ($im !== false) {
                                  header('Content-Type: ',$request->contentData);
                                  imagejpeg($im, $path);
                               
                                  $file = new LogoColony;
                                  $file->file_name = $name_imagen;
                                  $file->url_file = $url.$name_imagen;
                                  $file->file_type = $request->contentType;
                                  $file->file_size = $peso;
                                  $file->save();

                                  imagedestroy($im);
                              }
                              else 
                              {
                                  $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                   return redirect()->back()
                                      ->withErrors($errors);
                              }
                            }
                            else 
                            {
                                $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                  return redirect()->back()
                                      ->withErrors($errors);
                            }

                        }
                        
                    
                    }
                }

                return redirect()->action('ConfigMasterController@index',['i' => 1]);

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error3' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->action('ConfigMasterController@index',['i' => 1])
              ->withErrors($errors)
              ->withInput();
                
        } catch (\Exception $e) {
        
            $errors = ['error3' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->action('ConfigMasterController@index',['i' => 1])
              ->withErrors($errors)
              ->withInput();
        }
     
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\LogoColony  $logoColony
     * @return \Illuminate\Http\Response
     */
    public function show(LogoColony $logoColony)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\LogoColony  $logoColony
     * @return \Illuminate\Http\Response
     */
    public function edit(LogoColony $logoColony)
    {
        try{

            $user = Auth::user();
            if($user->can('edit', $logoColony))
            {
                return view('configuration.logo_colonies.edit', compact('logoColony'));
            }
            else
            {
                return redirect('/home');
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = 'Ha ocurrido un error intentalo otra vez.';
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = 'Ha ocurrido un error intentalo otra vez.';
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\LogoColony  $logoColony
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, LogoColony $logoColony)
    {
        
        try{
                $user = Auth::user();
                if($user->can('update', $logoColony))
                {
                    $messages = [

                        'required' => 'Es necesario cargar un archivo.',
                        'mimes' => 'El archivo debe ser tipo jpeg, jpg o png.',
                        'max'   => 'el archivo no debe pesar mas de 5 mb.',
                        'uploaded' => 'El archivo no debe pesar mas de 5 mb.',
                    ];

                    $rules = [
                         'file' => 'required|max:5000|mimes:jpeg,jpg,png', //5000kb image/jpeg image/png
                    ];

                    $validator = Validator::make($request->all(),$rules,$messages);

                    if ($validator->fails()) {
                        return redirect()->action('ConfigMasterController@index',['i' => 1])
                                    ->withErrors($validator)
                                    ->withInput();
                    }
                    else
                    {

                        

                        if (Input::hasFile('file'))
                        {
                            
                            $fileInput= Input::file('file');
                            $fileType = $fileInput->getMimeType();
                            $clave = str_random(5);

                            if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                            { 
                                
                                $name_imagen = $clave.$request->imageName;
                                $url = '/uploads/logo/';
                                $path = public_path().$url.$name_imagen;
                                $peso = $request->sizeData*1024;
                                $img = public_path().$logoColony->url_file;

                                if($request->imageData)
                                {
                                  $data = base64_decode($request->imageData);
                                  $im = imagecreatefromstring($data);
                                  if ($im !== false) 
                                  {
                                      header('Content-Type: ',$request->contentData);
                                      imagejpeg($im, $path);
                                   
                                      $logoColony->update([

                                          'file_name' => $name_imagen,
                                          'url_file'  => $url.$name_imagen,
                                          'file_type' => $request->contentType,
                                          'file_size' => $peso,
                                          
                                      ]);

                                      imagedestroy($im);
                                      unlink($img);
                                  }
                                  else 
                                  {
                                      $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                       return redirect()->back()
                                          ->withErrors($errors);
                                  }
                                }
                                else 
                                {
                                    $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                      return redirect()->back()
                                          ->withErrors($errors);
                                }

                            }
                            
                        
                        }
                    }

                    return redirect()->action('ConfigMasterController@index',['i' => 1]);
                }
                else
                {
                    return redirect('/home');
                }
                
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' =>  'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->action('ConfigMasterController@index',['i' => 1])
              ->withErrors($errors)
              ->withInput();
             
                
        } catch (\Exception $e) {
        
            $errors = ['error' =>  'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->action('ConfigMasterController@index',['i' => 1])
              ->withErrors($errors)
              ->withInput();
              throw $e;
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\LogoColony  $logoColony
     * @return \Illuminate\Http\Response
     */
    public function destroy(LogoColony $logoColony)
    {
        //
    }
}
