<?php

namespace App\Http\Controllers;

use App\Message;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\ParameterBag;
use Symfony\Component\HttpFoundation\File\UploadedFile;
use Input;
use File;
use Validator;
use Auth;
use Session;

class MessageController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user = Auth::user();
          
        if($user->can('index', \App\Message::class))
        {
            $message = Message::paginate(15);
            $a = 0;
            return view('messages.index', compact('message','a'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user = Auth::user();
          
        if($user->can('create', \App\Message::class))
        {
            return view('messages.create');
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
        //dd($request->all());
        try{
                
                $messages = [

                    'mimes'     => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                    'max'       => 'el archivo no debe pesar mas de 5 mb.',
                    'uploaded'  => 'El archivo no debe pesar mas de 5 mb.',
                    'required'  => 'Este campo es requerido.',
                ];

                $rules = [

                    'file'     => 'max:5000|mimes:jpeg,jpg,png,pdf', //5000kb image/jpeg image/png
                    'subject'  => 'required',
                    'body'     => 'required',
                ];

                $validator = Validator::make($request->all(),$rules,$messages);

                if ($validator->fails()) 
                {
                    return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {

                    

                    if (Input::hasFile('file'))
                    {

                        $fileInput= Input::file('file');
                        $fileType = $fileInput->getMimeType();
                        $clave = str_random(5);

                        if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                        { 
                              
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }

                           

                            if($request->btngrdr == 1)
                            {
                                $guardar = 0;
                            }
                            else
                            {
                                $guardar = 1;
                            }

                            $mess = Message::create([

                                'subject'   => $request->subject,
                                'body'      => $request->body,
                                'draft'     => $guardar,
                                

                            ]);

                            if($request->imageData)
                            {
                                $name_imagen = $mess->id.".".$type;
                                $url = '/uploads/messages/';
                                $path = public_path().$url.$name_imagen;
                               
                                $peso = $request->sizeData*1024;
                                $data = base64_decode($request->imageData);
                                $im = imagecreatefromstring($data);
                                if ($im !== false) {
                                    header('Content-Type: ',$request->contentData);
                                    imagejpeg($im, $path);

                                    $mess->update([

                                        'file_name' => $name_imagen, 
                                        'url_file'  => $url.$name_imagen,
                                        'file_type' => $request->contentType,
                                        'file_size' => $peso,

                                    ]);

                                   
                                    
                                    imagedestroy($im);
                                }
                                else 
                                {
                                    $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                     return redirect()->back()
                                        ->withErrors($errors);
                                }
                              }
                              else 
                              {
                                  $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                    return redirect()->back()
                                        ->withErrors($errors);
                              }

                        }
                        else
                        {
                                
                                $path = public_path().'/uploads/messages/';
                                $url = '/uploads/messages/';
                                $fileType = $fileInput->getMimeType();
                                if($fileType == "image/jpeg")
                                {
                                    $type = "jpg";
                                }
                                else if($fileType == "application/pdf")
                                {
                                    $type = "pdf";
                                }
                                else if($fileType == "image/png")
                                {
                                    $type = "png";
                                }
                                $fileSize = $fileInput->getClientSize()/1024;

                                if($request->btngrdr == 1)
                                {
                                    $guardar = 0;
                                }
                                else
                                {
                                    $guardar = 1;
                                }

                                      
                                $mess = Message::create([

                                    'subject'   => $request->subject,
                                    'body'      => $request->body,
                                    'draft'     => $guardar,
                                    

                                ]);

                                $fileName = $mess->id.".".$type;

                                if($fileInput->move($path,$fileName))
                                { 
                                    $mess->update([
                                        'file_name' => $fileName, 
                                        'url_file'  => $url.$fileName,
                                        'file_type' => $fileType,
                                        'file_size' => $fileSize,
                                    ]);
                                }
                        }
                    
                       

                    }
                    else
                    {
                        
                        if($request->btngrdr == 1)
                        {
                            $guardar = 0;
                        }
                        else
                        {
                            $guardar = 1;
                        }
                        Message::create([

                            'subject'   => $request->subject,
                            'body'      => $request->body,
                            'draft'     => $guardar,

                        ]);

                        
                    }

                    return redirect('/messages');

                }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors)
              ->withInput();
           
          
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors)
              ->withInput();
          
          
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Message  $message
     * @return \Illuminate\Http\Response
     */
    public function show(Message $message)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Message  $message
     * @return \Illuminate\Http\Response
     */
    public function edit(Message $message)
    {
        $user = Auth::user();

        if($user->can('edit', $message))
        {
            return view('messages.edit', compact('message'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Message  $message
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Message $message)
    {
         

         try{

            $user = Auth::user();
            if($user->can('update', $message))
            {
                $messages = [

                    'mimes'     => 'El archivo debe ser tipo jpeg, jpg, png o pdf.',
                    'max'       => 'el archivo no debe pesar mas de 5 mb.',
                    'uploaded'  => 'El archivo no debe pesar mas de 5 mb.',
                    'required'  => 'Este campo es requerido.',
                ];

                $rules = [

                    'file'    => 'max:5000|mimes:jpeg,jpg,png,pdf', //5000kb image/jpeg image/png
                    'subject' => 'required',
                    'body'    => 'required',
                ];

                $validator = Validator::make($request->all(),$rules,$messages);

                if ($validator->fails()) 
                {
                    return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
                }
                else
                {

                    

                    if (Input::hasFile('file'))
                    {
                        
                        $fileInput= Input::file('file');
                        $fileType = $fileInput->getMimeType();
                        $clave = str_random(5);

                        if($fileType == 'image/jpg' || $fileType == 'image/jpeg' || $fileType == 'image/png')
                        { 
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }
                            $name_imagen = $message->id.".".$type;
                            $url = '/uploads/messages/';
                            $path = public_path().$url.$name_imagen;
                            $peso = $request->sizeData*1024;

                            if($request->imageData)
                            {
                                $data = base64_decode($request->imageData);
                                $im = imagecreatefromstring($data);
                                if ($im !== false) {
                                    header('Content-Type: ',$request->contentData);
                                    imagejpeg($im, $path);
                                    imagedestroy($im);

                                    $img = public_path().$message->url_file;
                                    $old_img = $message->url_file;

                                    if($request->btngrdr == 1)
                                    {
                                        $guardar = 0;
                                    }
                                    else
                                    {
                                        $guardar = 1;
                                    }

    
                                    $message->update([

                                        'subject'   => $request->subject,
                                        'body'      => $request->body,
                                        'draft'     => $guardar,
                                        'file_name' => $name_imagen,
                                        'url_file'  => $url.$name_imagen,
                                        'file_type' => $request->contentType,
                                        'file_size' => $peso,      
                                    ]);

                                    /*if(!is_null($old_img))
                                    {
                                        unlink($img);
                                    }*/

                                    
                                    
                                    
                                }
                                else 
                                {
                                    $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                     return redirect()->back()
                                        ->withErrors($errors);
                                }
                              }
                              else 
                              {
                                  $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
                                    return redirect()->back()
                                        ->withErrors($errors);
                              }

                        }
                        else 
                        {  
                            
                            $path = public_path().'/uploads/messages/';
                            $url = '/uploads/messages/';
                            $fileType = $fileInput->getMimeType();
                            if($fileType == "image/jpeg")
                            {
                                $type = "jpg";
                            }
                            else if($fileType == "application/pdf")
                            {
                                $type = "pdf";
                            }
                            else if($fileType == "image/png")
                            {
                                $type = "png";
                            }
                            $fileSize = $fileInput->getClientSize()/1024;
                            $img = public_path().$message->url_file;
                            $old_img = $message->url_file;

                            if($request->btngrdr == 1)
                            {
                                $guardar = 0;
                            }
                            else
                            {
                                $guardar = 1;
                            } 

                            $fileName = $message->id.".".$type;

                            if($fileInput->move($path,$fileName))
                            {       
                                $message->update([

                                    'subject'   => $request->subject,
                                    'body'      => $request->body,
                                    'draft'     => $guardar,
                                    'file_name' => $fileName,
                                    'url_file'  => $url.$fileName,
                                    'file_type' => $fileType,
                                    'file_size' => $fileSize,      
                                ]);

                                /*if(!is_null($old_img))
                                {
                                    unlink($img);
                                }*/
                            }
                        }

                       
                        
                    }
                    else
                    {

                        if($request->btngrdr == 1)
                        {
                            $guardar = 0;
                        }
                        else
                        {
                            $guardar = 1;
                        } 

                        $message->update([

                            'subject'   => $request->subject,
                            'body'      => $request->body,
                            'draft'     => $guardar,
                        ]);

                        
                    }

                    return redirect('/messages');

                }

            }
            else
            {
                return redirect('/home');
            }

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              throw $e;
      
                
        } catch (\Exception $e) {
        
            $errors = ['error' =>  'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              throw $e;
            
        }


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Message  $message
     * @return \Illuminate\Http\Response
     */
    public function destroy(Message $message, Request $request)
    {
        try{
            $message = Message::findOrfail($request->id);

            $user = Auth::user();
            if($user->can('update', $message))
            {
                $message->delete();
                return redirect('/messages');
            }
            else
            {
                return redirect()->back();
            }
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error2' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }
}
