<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Street;
use App\MonthlyContribution;
use Auth;

class MonthlyPayAsignController extends Controller
{
     public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         try{

            $user = Auth::user();
            if($user->can('index', \App\Config::class))
            {
                $amount = MonthlyContribution::findOrfail($request->idamount);

                $street = Street::where('empty_residence', 0)->get();

                foreach ($street as $streets) 
                {
                    
                    $str = Street::findOrfail($streets->id);

                    $str->update([

                        'contribution' => $amount->id, 

                    ]);
                     
                }

                return redirect('/monthly_contribution');
            }
            else
            {
                return redirect()->back();
            }

            
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              //throw $e;
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              //throw $e;
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        try{

            $user = Auth::user();
            
            $user = Auth::user();
            if($user->can('index', \App\Config::class))
            {
                $a = MonthlyContribution::findOrfail($id);

                $o = MonthlyContribution::where('asign', 1);

                $o->update([
                    'asign' => 0,
                ]);

                $a->update([
                    'asign' => 1,
                ]);

                return redirect('/monthly_contribution');
            }
            else
            {
                return redirect()->back();
            }

            
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              //throw $e;
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              //throw $e;
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
      
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
