<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\MonthlyContribution;
use App\Street;
use DB;
use App\Status;
use Auth;
use App\Config;

class MonthlyPayController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        try{

            $user = Auth::user();
            if($user->can('index', \App\Config::class))
            {
                $config = Config::first();
                if($config->multiple_contributions == 1)
                {
                    $amount = MonthlyContribution::all();
                    $atri = MonthlyContribution::all();
                    $filtro = $request->input('streetnumber');
                    $status = Status::where('name','activo')->first();
                    $status2 = Status::where('name','cancelado')->first();
                    $street = Street::select('streets.id','name_street','number','monthly_contributions.id as mid','contribution','amount')
                        ->leftjoin('monthly_contributions','contribution','=','monthly_contributions.id')->where('empty_residence',0)
                         ->when($filtro, function ($query) use ($filtro) {
                                    
                              return $query->where('streets.id',$filtro);   
                                    
                            })
                         ->paginate(15);

                    $a = 0;
                    $b = 0;

                    if($request->abierto == 1)
                    {
                        $abierto = 1;
                    }
                    else
                    {
                        $abierto = 0;
                    }
                }
                else
                {
                    return redirect()->back();
                }
            }
            else
            {
                return redirect()->back();
            }
         

            return view('diferent_pay.index', compact('amount','abierto','street','a','b','atri'));


        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              //throw $e;
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              //throw $e;
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
           
        try{

            $user = Auth::user();
            if($user->can('index', \App\Config::class))
            {

                $amount = MonthlyContribution::create([

                    'amount' => $request->contribution,

                ]);

               return redirect('/monthly_contribution');
            }
            else
            {
                return redirect()->back();
            }
           

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              //throw $e;
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              //throw $e;
        }


    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        try{
            
            $user = Auth::user();
            if($user->can('index', \App\Config::class))
            {
           
                $street = Street::findOrfail($id);


                $street->update([

                    'contribution' => $request->atribamount,
                ]);
                return redirect('/monthly_contribution');  
            }
            else
            {
                return redirect()->back();
            }

            


        
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
            
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
             
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
         try{

            $user = Auth::user();
            if($user->can('index', \App\Config::class))
            {

                $table = DB::table('monthly_contributions')->count();
                if($table > 1)
                {
                    $d = MonthlyContribution::findOrfail($request->id);
         
                    $d->delete();
                }
                else
                {
                    $errors = ['error' => 'No puede eliminar la aportación mensual por que esta asignada a un o mas residencias.'];
                   return redirect()->back()
                      ->withErrors($errors);
                }

                return redirect('/monthly_contribution');
            }
            else
            {
                return redirect()->back();
            }
                
        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
              //throw $e;
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              //throw $e;
        }
    }

   
}
