<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use App\PerfilConfig;
use Auth;
use Session;
use App\User;
use Validator;
use DB;
use App\DomineColony;
use Mail;
use App\Mail\ResidentRegister;

class PerfilConfigController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $users = Auth::user();
        
        $resident = User::leftjoin('streets','street_id','=','streets.id')
                ->select('users.*','name_street','number')
                ->where('hidden',0)
                ->where('name','!=',$users->name)
                ->where('street_id',$users->street_id)
                ->orderBy('created_at','ASC')
                ->paginate(5);
      
        if($users->can('index', \App\PerfilConfig::class))
        {
            $perfil = PerfilConfig::where('user_id', Auth::user()->id)->first();
            $user = Auth::user();
            $us = User::find($user->id);
            $rol = $us->belongsToMany('App\Rol')->wherePivot('user_id', $user->id)->first();


            return view('configuration.perfil_configs.index', compact('perfil','user','rol','resident'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       

          try{

            $messages = [
            'unique'    => 'El correo electrónico ya esta registrado.',
            'email'     => 'Debe ser un correo electrónico válido.',
            'required'  => 'Este campo es requerido.',
            ];

            $rules = [
                'email_user' => 'unique:users,email|required|email', 
                'name_user'  => 'required',
              
            ];

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {

                    
                    DB::beginTransaction();

                    
                        $pass = str_random(8);

                        $street = Auth::user();

                        $user = User::create([

                            'name' => $request->name_user,
                            'email' => $request->email_user,
                            'password' => bcrypt($pass),
                            'phone_resident' => $request->phone_resident,
                            'street_id' => $street->street_id,
                        ]);

                        $user->roles()->attach('4',['user_id'=> $user->id]);
                       
                        PerfilConfig::create([

                            'user_id' => $user->id,
                            'private_profile' => 0,
                        ]);

                        
                        $u = DomineColony::all();

                        foreach ($u as $us)
                        {
                            $url = $us->url;
                        }

                   
                     
                        Mail::to($request->email_user)->send(new ResidentRegister($user,$pass,$url));


                        
                    

                    DB::commit();

                    $mensaje = 'Recuerda avisar al residente que revise el correo que registraste para que vea su constraseña.';
                    Session::flash('message', $mensaje ); 

                    //return redirect()->action('UserController@index', ['abierto' => "1"]);
                    return redirect('/configuration/perfil_config');
                }


        } catch (\Illuminate\Database\QueryException $e) {
             
          $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);

            
            
                
        } catch (\Exception $e) {
        
            $errors = ['error' =>  'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
              
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\PerfilConfig  $perfilConfig
     * @return \Illuminate\Http\Response
     */
    public function show(PerfilConfig $perfilConfig)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\PerfilConfig  $perfilConfig
     * @return \Illuminate\Http\Response
     */
    public function edit(PerfilConfig $perfilConfig)
    {
        $user = Auth::user();
        if($user->can('edit', $perfilConfig))
        {
            return view('configuration.perfil_configs.edit', compact('perfilConfig'));
        }
        else
        {
            return redirect('/home');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\PerfilConfig  $perfilConfig
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PerfilConfig $perfilConfig)
    {

        //dd($request->all());
        try{

            $u = Auth::user();
            $user = User::findOrfail($request->user);

            $messages = [

                'required'  => 'Este campo es requerido.',
                'unique'    => 'El correo electrónico ya esta registrado.',
                'email'     => 'Debe ser un correo electrónico válido.',
            ];

            if($user->email == $request->email)
            {
                $rules = [

                    'name' => 'required',
                    'email' => 'required',
                ];
            }
            else
            {
                $rules = [

                    'name' => 'required',
                    'email' => 'required|email|unique:users,email',
                ];
            }

            

            $validator = Validator::make($request->all(),$rules,$messages);

            if ($validator->fails()) 
            {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            else
            {


                if(is_null($request->name))
                {
                    $name = $user->name;
                }
                else
                {
                    $name = $request->name;
                }
                    
                if(is_null($request->email))
                {
                    $email = $user->email;
                }
                else
                {
                    $email = $request->email;
                }

                /*if(is_null($request->phone_resident))
                {
                    $phone = $user->phone_resident;
                }
                else
                {
                    $phone = $request->phone_resident;
                }*/



                $user->update([

                    'name' => $name,
                    'email' => $email,
                    'phone_resident' => $request->phone_resident,
                       

                ]);
                        
                if($request->private_profile)
                {
                    $public = 1;
                }
                else
                {
                    $public = 0;
                }

                              
                $perfilConfig->update([

                    'private_profile' => $public,

                ]);
                            
                return redirect('configuration/perfil_config');
            }
                    
                    
        

        } catch (\Illuminate\Database\QueryException $e) {
             
           $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
           return redirect()->back()
              ->withErrors($errors);
                
        } catch (\Exception $e) {
        
            $errors = ['error' => 'Ha ocurrido un error intentalo otra vez.'];
            return redirect()->back()
              ->withErrors($errors);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\PerfilConfig  $perfilConfig
     * @return \Illuminate\Http\Response
     */
    public function destroy(PerfilConfig $perfilConfig)
    {
        //
    }
}
